///////////////////////////////////////////////////////////
//  Copyright (c) 1995/2006 Xilinx Inc.
//  All Right Reserved.
///////////////////////////////////////////////////////////
//
//   ____   ___
//  /   /\/   / 
// /___/  \  /    Vendor      : Xilinx 
// \  \    \/     Version : 10.1
//  \  \          Description : Xilinx Functional Simulation Library Component
//  /  /                        PCI Express
// /__/   /\      Filename    : PCIE_INTERNAL_1_1.v
// \  \  /  \     Timestamp   : Thu Dec 8 2005   
//  \__\/\__ \                    
//                                 
//  Revision:
//    12/08/05 - Initial version.
//    01/09/06 - Added case statement, specify block
//    01/23/06 - Parameter MC updates CR#224562
//    02/23/06 - CR#226003 - Added integer, real parameter type
//    04/24/06 - CR#230393 - Updated parameters, timing according to the spreadsheets
//             - Updated Header
//    04/28/06 - CR#230712 - Spreadsheet update
//    05/23/06 - CR#231962 - Add buffers for connectivity
//    06/22/06 - CR#233879 - Add parameter bus range
//    08/02/06 - CR#235013 - Missing GSR added in SWIFT instantiation
//    08/14/06 - CR#421379 - PCIE updated to PCIE_INTERNAL_1_1
//                         - spreadsheet updates for parameter default values
//    10/26/06 -           - replaced zero_delay with CLK_DELAY to be consistent with writers (PPC440 update)
//                         - in_delay 50 to 0
//  End Revision
///////////////////////////////////////////////////////////

`timescale 1 ps / 1 ps 

module PCIE_INTERNAL_1_1 (
	BUSMASTERENABLE,
	CRMDOHOTRESETN,
	CRMPWRSOFTRESETN,
	CRMRXHOTRESETN,
	DLLTXPMDLLPOUTSTANDING,
	INTERRUPTDISABLE,
	IOSPACEENABLE,
	L0ASAUTONOMOUSINITCOMPLETED,
	L0ATTENTIONINDICATORCONTROL,
	L0CFGLOOPBACKACK,
	L0COMPLETERID,
	L0CORRERRMSGRCVD,
	L0DLLASRXSTATE,
	L0DLLASTXSTATE,
	L0DLLERRORVECTOR,
	L0DLLRXACKOUTSTANDING,
	L0DLLTXNONFCOUTSTANDING,
	L0DLLTXOUTSTANDING,
	L0DLLVCSTATUS,
	L0DLUPDOWN,
	L0ERRMSGREQID,
	L0FATALERRMSGRCVD,
	L0FIRSTCFGWRITEOCCURRED,
	L0FWDCORRERROUT,
	L0FWDFATALERROUT,
	L0FWDNONFATALERROUT,
	L0LTSSMSTATE,
	L0MACENTEREDL0,
	L0MACLINKTRAINING,
	L0MACLINKUP,
	L0MACNEGOTIATEDLINKWIDTH,
	L0MACNEWSTATEACK,
	L0MACRXL0SSTATE,
	L0MACUPSTREAMDOWNSTREAM,
	L0MCFOUND,
	L0MSIENABLE0,
	L0MULTIMSGEN0,
	L0NONFATALERRMSGRCVD,
	L0PMEACK,
	L0PMEEN,
	L0PMEREQOUT,
	L0POWERCONTROLLERCONTROL,
	L0POWERINDICATORCONTROL,
	L0PWRINHIBITTRANSFERS,
	L0PWRL1STATE,
	L0PWRL23READYDEVICE,
	L0PWRL23READYSTATE,
	L0PWRSTATE0,
	L0PWRTURNOFFREQ,
	L0PWRTXL0SSTATE,
	L0RECEIVEDASSERTINTALEGACYINT,
	L0RECEIVEDASSERTINTBLEGACYINT,
	L0RECEIVEDASSERTINTCLEGACYINT,
	L0RECEIVEDASSERTINTDLEGACYINT,
	L0RECEIVEDDEASSERTINTALEGACYINT,
	L0RECEIVEDDEASSERTINTBLEGACYINT,
	L0RECEIVEDDEASSERTINTCLEGACYINT,
	L0RECEIVEDDEASSERTINTDLEGACYINT,
	L0RXBEACON,
	L0RXDLLFCCMPLMCCRED,
	L0RXDLLFCCMPLMCUPDATE,
	L0RXDLLFCNPOSTBYPCRED,
	L0RXDLLFCNPOSTBYPUPDATE,
	L0RXDLLFCPOSTORDCRED,
	L0RXDLLFCPOSTORDUPDATE,
	L0RXDLLPM,
	L0RXDLLPMTYPE,
	L0RXDLLSBFCDATA,
	L0RXDLLSBFCUPDATE,
	L0RXDLLTLPECRCOK,
	L0RXDLLTLPEND,
	L0RXMACLINKERROR,
	L0STATSCFGOTHERRECEIVED,
	L0STATSCFGOTHERTRANSMITTED,
	L0STATSCFGRECEIVED,
	L0STATSCFGTRANSMITTED,
	L0STATSDLLPRECEIVED,
	L0STATSDLLPTRANSMITTED,
	L0STATSOSRECEIVED,
	L0STATSOSTRANSMITTED,
	L0STATSTLPRECEIVED,
	L0STATSTLPTRANSMITTED,
	L0TOGGLEELECTROMECHANICALINTERLOCK,
	L0TRANSFORMEDVC,
	L0TXDLLFCCMPLMCUPDATED,
	L0TXDLLFCNPOSTBYPUPDATED,
	L0TXDLLFCPOSTORDUPDATED,
	L0TXDLLPMUPDATED,
	L0TXDLLSBFCUPDATED,
	L0UCBYPFOUND,
	L0UCORDFOUND,
	L0UNLOCKRECEIVED,
	LLKRX4DWHEADERN,
	LLKRXCHCOMPLETIONAVAILABLEN,
	LLKRXCHCOMPLETIONPARTIALN,
	LLKRXCHCONFIGAVAILABLEN,
	LLKRXCHCONFIGPARTIALN,
	LLKRXCHNONPOSTEDAVAILABLEN,
	LLKRXCHNONPOSTEDPARTIALN,
	LLKRXCHPOSTEDAVAILABLEN,
	LLKRXCHPOSTEDPARTIALN,
	LLKRXDATA,
	LLKRXECRCBADN,
	LLKRXEOFN,
	LLKRXEOPN,
	LLKRXPREFERREDTYPE,
	LLKRXSOFN,
	LLKRXSOPN,
	LLKRXSRCDSCN,
	LLKRXSRCLASTREQN,
	LLKRXSRCRDYN,
	LLKRXVALIDN,
	LLKTCSTATUS,
	LLKTXCHANSPACE,
	LLKTXCHCOMPLETIONREADYN,
	LLKTXCHNONPOSTEDREADYN,
	LLKTXCHPOSTEDREADYN,
	LLKTXCONFIGREADYN,
	LLKTXDSTRDYN,
	MAXPAYLOADSIZE,
	MAXREADREQUESTSIZE,
	MEMSPACEENABLE,
	MGMTPSO,
	MGMTRDATA,
	MGMTSTATSCREDIT,
	MIMDLLBRADD,
	MIMDLLBREN,
	MIMDLLBWADD,
	MIMDLLBWDATA,
	MIMDLLBWEN,
	MIMRXBRADD,
	MIMRXBREN,
	MIMRXBWADD,
	MIMRXBWDATA,
	MIMRXBWEN,
	MIMTXBRADD,
	MIMTXBREN,
	MIMTXBWADD,
	MIMTXBWDATA,
	MIMTXBWEN,
	PARITYERRORRESPONSE,
	PIPEDESKEWLANESL0,
	PIPEDESKEWLANESL1,
	PIPEDESKEWLANESL2,
	PIPEDESKEWLANESL3,
	PIPEDESKEWLANESL4,
	PIPEDESKEWLANESL5,
	PIPEDESKEWLANESL6,
	PIPEDESKEWLANESL7,
	PIPEPOWERDOWNL0,
	PIPEPOWERDOWNL1,
	PIPEPOWERDOWNL2,
	PIPEPOWERDOWNL3,
	PIPEPOWERDOWNL4,
	PIPEPOWERDOWNL5,
	PIPEPOWERDOWNL6,
	PIPEPOWERDOWNL7,
	PIPERESETL0,
	PIPERESETL1,
	PIPERESETL2,
	PIPERESETL3,
	PIPERESETL4,
	PIPERESETL5,
	PIPERESETL6,
	PIPERESETL7,
	PIPERXPOLARITYL0,
	PIPERXPOLARITYL1,
	PIPERXPOLARITYL2,
	PIPERXPOLARITYL3,
	PIPERXPOLARITYL4,
	PIPERXPOLARITYL5,
	PIPERXPOLARITYL6,
	PIPERXPOLARITYL7,
	PIPETXCOMPLIANCEL0,
	PIPETXCOMPLIANCEL1,
	PIPETXCOMPLIANCEL2,
	PIPETXCOMPLIANCEL3,
	PIPETXCOMPLIANCEL4,
	PIPETXCOMPLIANCEL5,
	PIPETXCOMPLIANCEL6,
	PIPETXCOMPLIANCEL7,
	PIPETXDATAKL0,
	PIPETXDATAKL1,
	PIPETXDATAKL2,
	PIPETXDATAKL3,
	PIPETXDATAKL4,
	PIPETXDATAKL5,
	PIPETXDATAKL6,
	PIPETXDATAKL7,
	PIPETXDATAL0,
	PIPETXDATAL1,
	PIPETXDATAL2,
	PIPETXDATAL3,
	PIPETXDATAL4,
	PIPETXDATAL5,
	PIPETXDATAL6,
	PIPETXDATAL7,
	PIPETXDETECTRXLOOPBACKL0,
	PIPETXDETECTRXLOOPBACKL1,
	PIPETXDETECTRXLOOPBACKL2,
	PIPETXDETECTRXLOOPBACKL3,
	PIPETXDETECTRXLOOPBACKL4,
	PIPETXDETECTRXLOOPBACKL5,
	PIPETXDETECTRXLOOPBACKL6,
	PIPETXDETECTRXLOOPBACKL7,
	PIPETXELECIDLEL0,
	PIPETXELECIDLEL1,
	PIPETXELECIDLEL2,
	PIPETXELECIDLEL3,
	PIPETXELECIDLEL4,
	PIPETXELECIDLEL5,
	PIPETXELECIDLEL6,
	PIPETXELECIDLEL7,
	SERRENABLE,
	URREPORTINGENABLE,

	AUXPOWER,
	CFGNEGOTIATEDLINKWIDTH,
	COMPLIANCEAVOID,
	CRMCFGBRIDGEHOTRESET,
	CRMCORECLK,
	CRMCORECLKDLO,
	CRMCORECLKRXO,
	CRMCORECLKTXO,
	CRMLINKRSTN,
	CRMMACRSTN,
	CRMMGMTRSTN,
	CRMNVRSTN,
	CRMTXHOTRESETN,
	CRMURSTN,
	CRMUSERCFGRSTN,
	CRMUSERCLK,
	CRMUSERCLKRXO,
	CRMUSERCLKTXO,
	CROSSLINKSEED,
	L0ACKNAKTIMERADJUSTMENT,
	L0ALLDOWNPORTSINL1,
	L0ALLDOWNRXPORTSINL0S,
	L0ASE,
	L0ASPORTCOUNT,
	L0ASTURNPOOLBITSCONSUMED,
	L0ATTENTIONBUTTONPRESSED,
	L0CFGASSPANTREEOWNEDSTATE,
	L0CFGASSTATECHANGECMD,
	L0CFGDISABLESCRAMBLE,
	L0CFGEXTENDEDSYNC,
	L0CFGL0SENTRYENABLE,
	L0CFGL0SENTRYSUP,
	L0CFGL0SEXITLAT,
	L0CFGLINKDISABLE,
	L0CFGLOOPBACKMASTER,
	L0CFGNEGOTIATEDMAXP,
	L0CFGVCENABLE,
	L0CFGVCID,
	L0DLLHOLDLINKUP,
	L0ELECTROMECHANICALINTERLOCKENGAGED,
	L0FWDASSERTINTALEGACYINT,
	L0FWDASSERTINTBLEGACYINT,
	L0FWDASSERTINTCLEGACYINT,
	L0FWDASSERTINTDLEGACYINT,
	L0FWDCORRERRIN,
	L0FWDDEASSERTINTALEGACYINT,
	L0FWDDEASSERTINTBLEGACYINT,
	L0FWDDEASSERTINTCLEGACYINT,
	L0FWDDEASSERTINTDLEGACYINT,
	L0FWDFATALERRIN,
	L0FWDNONFATALERRIN,
	L0LEGACYINTFUNCT0,
	L0MRLSENSORCLOSEDN,
	L0MSIREQUEST0,
	L0PACKETHEADERFROMUSER,
	L0PMEREQIN,
	L0PORTNUMBER,
	L0POWERFAULTDETECTED,
	L0PRESENCEDETECTSLOTEMPTYN,
	L0PWRNEWSTATEREQ,
	L0PWRNEXTLINKSTATE,
	L0REPLAYTIMERADJUSTMENT,
	L0ROOTTURNOFFREQ,
	L0RXTLTLPNONINITIALIZEDVC,
	L0SENDUNLOCKMESSAGE,
	L0SETCOMPLETERABORTERROR,
	L0SETCOMPLETIONTIMEOUTCORRERROR,
	L0SETCOMPLETIONTIMEOUTUNCORRERROR,
	L0SETDETECTEDCORRERROR,
	L0SETDETECTEDFATALERROR,
	L0SETDETECTEDNONFATALERROR,
	L0SETLINKDETECTEDPARITYERROR,
	L0SETLINKMASTERDATAPARITY,
	L0SETLINKRECEIVEDMASTERABORT,
	L0SETLINKRECEIVEDTARGETABORT,
	L0SETLINKSIGNALLEDTARGETABORT,
	L0SETLINKSYSTEMERROR,
	L0SETUNEXPECTEDCOMPLETIONCORRERROR,
	L0SETUNEXPECTEDCOMPLETIONUNCORRERROR,
	L0SETUNSUPPORTEDREQUESTNONPOSTEDERROR,
	L0SETUNSUPPORTEDREQUESTOTHERERROR,
	L0SETUSERDETECTEDPARITYERROR,
	L0SETUSERMASTERDATAPARITY,
	L0SETUSERRECEIVEDMASTERABORT,
	L0SETUSERRECEIVEDTARGETABORT,
	L0SETUSERSIGNALLEDTARGETABORT,
	L0SETUSERSYSTEMERROR,
	L0TLASFCCREDSTARVATION,
	L0TLLINKRETRAIN,
	L0TRANSACTIONSPENDING,
	L0TXBEACON,
	L0TXCFGPM,
	L0TXCFGPMTYPE,
	L0TXTLFCCMPLMCCRED,
	L0TXTLFCCMPLMCUPDATE,
	L0TXTLFCNPOSTBYPCRED,
	L0TXTLFCNPOSTBYPUPDATE,
	L0TXTLFCPOSTORDCRED,
	L0TXTLFCPOSTORDUPDATE,
	L0TXTLSBFCDATA,
	L0TXTLSBFCUPDATE,
	L0TXTLTLPDATA,
	L0TXTLTLPEDB,
	L0TXTLTLPENABLE,
	L0TXTLTLPEND,
	L0TXTLTLPLATENCY,
	L0TXTLTLPREQ,
	L0TXTLTLPREQEND,
	L0TXTLTLPWIDTH,
	L0UPSTREAMRXPORTINL0S,
	L0VC0PREVIEWEXPAND,
	L0WAKEN,
	LLKRXCHFIFO,
	LLKRXCHTC,
	LLKRXDSTCONTREQN,
	LLKRXDSTREQN,
	LLKTX4DWHEADERN,
	LLKTXCHFIFO,
	LLKTXCHTC,
	LLKTXCOMPLETEN,
	LLKTXCREATEECRCN,
	LLKTXDATA,
	LLKTXENABLEN,
	LLKTXEOFN,
	LLKTXEOPN,
	LLKTXSOFN,
	LLKTXSOPN,
	LLKTXSRCDSCN,
	LLKTXSRCRDYN,
	MAINPOWER,
	MGMTADDR,
	MGMTBWREN,
	MGMTRDEN,
	MGMTSTATSCREDITSEL,
	MGMTWDATA,
	MGMTWREN,
	MIMDLLBRDATA,
	MIMRXBRDATA,
	MIMTXBRDATA,
	PIPEPHYSTATUSL0,
	PIPEPHYSTATUSL1,
	PIPEPHYSTATUSL2,
	PIPEPHYSTATUSL3,
	PIPEPHYSTATUSL4,
	PIPEPHYSTATUSL5,
	PIPEPHYSTATUSL6,
	PIPEPHYSTATUSL7,
	PIPERXCHANISALIGNEDL0,
	PIPERXCHANISALIGNEDL1,
	PIPERXCHANISALIGNEDL2,
	PIPERXCHANISALIGNEDL3,
	PIPERXCHANISALIGNEDL4,
	PIPERXCHANISALIGNEDL5,
	PIPERXCHANISALIGNEDL6,
	PIPERXCHANISALIGNEDL7,
	PIPERXDATAKL0,
	PIPERXDATAKL1,
	PIPERXDATAKL2,
	PIPERXDATAKL3,
	PIPERXDATAKL4,
	PIPERXDATAKL5,
	PIPERXDATAKL6,
	PIPERXDATAKL7,
	PIPERXDATAL0,
	PIPERXDATAL1,
	PIPERXDATAL2,
	PIPERXDATAL3,
	PIPERXDATAL4,
	PIPERXDATAL5,
	PIPERXDATAL6,
	PIPERXDATAL7,
	PIPERXELECIDLEL0,
	PIPERXELECIDLEL1,
	PIPERXELECIDLEL2,
	PIPERXELECIDLEL3,
	PIPERXELECIDLEL4,
	PIPERXELECIDLEL5,
	PIPERXELECIDLEL6,
	PIPERXELECIDLEL7,
	PIPERXSTATUSL0,
	PIPERXSTATUSL1,
	PIPERXSTATUSL2,
	PIPERXSTATUSL3,
	PIPERXSTATUSL4,
	PIPERXSTATUSL5,
	PIPERXSTATUSL6,
	PIPERXSTATUSL7,
	PIPERXVALIDL0,
	PIPERXVALIDL1,
	PIPERXVALIDL2,
	PIPERXVALIDL3,
	PIPERXVALIDL4,
	PIPERXVALIDL5,
	PIPERXVALIDL6,
	PIPERXVALIDL7

);

parameter AERCAPABILITYECRCCHECKCAPABLE = "FALSE";
parameter AERCAPABILITYECRCGENCAPABLE = "FALSE";
parameter BAR0EXIST = "TRUE";
parameter BAR0PREFETCHABLE = "TRUE";
parameter BAR1EXIST = "FALSE";
parameter BAR1PREFETCHABLE = "FALSE";
parameter BAR2EXIST = "FALSE";
parameter BAR2PREFETCHABLE = "FALSE";
parameter BAR3EXIST = "FALSE";
parameter BAR3PREFETCHABLE = "FALSE";
parameter BAR4EXIST = "FALSE";
parameter BAR4PREFETCHABLE = "FALSE";
parameter BAR5EXIST = "FALSE";
parameter BAR5PREFETCHABLE = "FALSE";
parameter CLKDIVIDED = "FALSE";
parameter DUALCOREENABLE = "FALSE";
parameter DUALCORESLAVE = "FALSE";
parameter INFINITECOMPLETIONS = "TRUE";
parameter ISSWITCH = "FALSE";
parameter LINKSTATUSSLOTCLOCKCONFIG = "FALSE";
parameter LLKBYPASS = "FALSE";
parameter PBCAPABILITYSYSTEMALLOCATED = "FALSE";
parameter PCIECAPABILITYSLOTIMPL = "FALSE";
parameter PMCAPABILITYD1SUPPORT = "FALSE";
parameter PMCAPABILITYD2SUPPORT = "FALSE";
parameter PMCAPABILITYDSI = "TRUE";
parameter RAMSHARETXRX = "FALSE";
parameter RESETMODE = "FALSE";
parameter RETRYREADADDRPIPE = "FALSE";
parameter RETRYREADDATAPIPE = "FALSE";
parameter RETRYWRITEPIPE = "FALSE";
parameter RXREADADDRPIPE = "FALSE";
parameter RXREADDATAPIPE = "FALSE";
parameter RXWRITEPIPE = "FALSE";
parameter SELECTASMODE = "FALSE";
parameter SELECTDLLIF = "FALSE";
parameter SLOTCAPABILITYATTBUTTONPRESENT = "FALSE";
parameter SLOTCAPABILITYATTINDICATORPRESENT = "FALSE";
parameter SLOTCAPABILITYHOTPLUGCAPABLE = "FALSE";
parameter SLOTCAPABILITYHOTPLUGSURPRISE = "FALSE";
parameter SLOTCAPABILITYMSLSENSORPRESENT = "FALSE";
parameter SLOTCAPABILITYPOWERCONTROLLERPRESENT = "FALSE";
parameter SLOTCAPABILITYPOWERINDICATORPRESENT = "FALSE";
parameter SLOTIMPLEMENTED = "FALSE";
parameter TXREADADDRPIPE = "FALSE";
parameter TXREADDATAPIPE = "FALSE";
parameter TXWRITEPIPE = "FALSE";
parameter UPSTREAMFACING = "TRUE";
parameter XLINKSUPPORTED = "FALSE";
parameter [10:0] VC0TOTALCREDITSCD = 11'h0;
parameter [10:0] VC0TOTALCREDITSPD = 11'h34;
parameter [10:0] VC1TOTALCREDITSCD = 11'h0;
parameter [10:0] VC1TOTALCREDITSPD = 11'h0;
parameter [11:0] AERBASEPTR = 12'h110;
parameter [11:0] AERCAPABILITYNEXTPTR = 12'h138;
parameter [11:0] DSNBASEPTR = 12'h148;
parameter [11:0] DSNCAPABILITYNEXTPTR = 12'h154;
parameter [11:0] EXTCFGXPCAPPTR = 12'h0;
parameter [11:0] MSIBASEPTR = 12'h48;
parameter [11:0] PBBASEPTR = 12'h138;
parameter [11:0] PBCAPABILITYNEXTPTR = 12'h148;
parameter [11:0] PMBASEPTR = 12'h40;
parameter [11:0] RETRYRAMSIZE = 12'h9;
parameter [11:0] VCBASEPTR = 12'h154;
parameter [11:0] VCCAPABILITYNEXTPTR = 12'h0;
parameter [12:0] SLOTCAPABILITYPHYSICALSLOTNUM = 13'h0;
parameter [12:0] VC0RXFIFOBASEC = 13'h98;
parameter [12:0] VC0RXFIFOBASENP = 13'h80;
parameter [12:0] VC0RXFIFOBASEP = 13'h0;
parameter [12:0] VC0RXFIFOLIMITC = 13'h117;
parameter [12:0] VC0RXFIFOLIMITNP = 13'h97;
parameter [12:0] VC0RXFIFOLIMITP = 13'h7f;
parameter [12:0] VC0TXFIFOBASEC = 13'h98;
parameter [12:0] VC0TXFIFOBASENP = 13'h80;
parameter [12:0] VC0TXFIFOBASEP = 13'h0;
parameter [12:0] VC0TXFIFOLIMITC = 13'h117;
parameter [12:0] VC0TXFIFOLIMITNP = 13'h97;
parameter [12:0] VC0TXFIFOLIMITP = 13'h7f;
parameter [12:0] VC1RXFIFOBASEC = 13'h118;
parameter [12:0] VC1RXFIFOBASENP = 13'h118;
parameter [12:0] VC1RXFIFOBASEP = 13'h118;
parameter [12:0] VC1RXFIFOLIMITC = 13'h118;
parameter [12:0] VC1RXFIFOLIMITNP = 13'h118;
parameter [12:0] VC1RXFIFOLIMITP = 13'h118;
parameter [12:0] VC1TXFIFOBASEC = 13'h118;
parameter [12:0] VC1TXFIFOBASENP = 13'h118;
parameter [12:0] VC1TXFIFOBASEP = 13'h118;
parameter [12:0] VC1TXFIFOLIMITC = 13'h118;
parameter [12:0] VC1TXFIFOLIMITNP = 13'h118;
parameter [12:0] VC1TXFIFOLIMITP = 13'h118;
parameter [15:0] DEVICEID = 16'h5050;
parameter [15:0] SUBSYSTEMID = 16'h5050;
parameter [15:0] SUBSYSTEMVENDORID = 16'h10EE;
parameter [15:0] VENDORID = 16'h10EE;
parameter [1:0] LINKCAPABILITYASPMSUPPORT = 2'h1;
parameter [1:0] PBCAPABILITYDW0DATASCALE = 2'h0;
parameter [1:0] PBCAPABILITYDW0PMSTATE = 2'h0;
parameter [1:0] PBCAPABILITYDW1DATASCALE = 2'h0;
parameter [1:0] PBCAPABILITYDW1PMSTATE = 2'h0;
parameter [1:0] PBCAPABILITYDW2DATASCALE = 2'h0;
parameter [1:0] PBCAPABILITYDW2PMSTATE = 2'h0;
parameter [1:0] PBCAPABILITYDW3DATASCALE = 2'h0;
parameter [1:0] PBCAPABILITYDW3PMSTATE = 2'h0;
parameter [1:0] PMSTATUSCONTROLDATASCALE = 2'h0;
parameter [1:0] SLOTCAPABILITYSLOTPOWERLIMITSCALE = 2'h0;
parameter [23:0] CLASSCODE = 24'h058000;
parameter [2:0] CONFIGROUTING = 3'h1;
parameter [2:0] DEVICECAPABILITYENDPOINTL0SLATENCY = 3'h0;
parameter [2:0] DEVICECAPABILITYENDPOINTL1LATENCY = 3'h0;
parameter [2:0] MSICAPABILITYMULTIMSGCAP = 3'h0;
parameter [2:0] PBCAPABILITYDW0PMSUBSTATE = 3'h0;
parameter [2:0] PBCAPABILITYDW0POWERRAIL = 3'h0;
parameter [2:0] PBCAPABILITYDW0TYPE = 3'h0;
parameter [2:0] PBCAPABILITYDW1PMSUBSTATE = 3'h0;
parameter [2:0] PBCAPABILITYDW1POWERRAIL = 3'h0;
parameter [2:0] PBCAPABILITYDW1TYPE = 3'h0;
parameter [2:0] PBCAPABILITYDW2PMSUBSTATE = 3'h0;
parameter [2:0] PBCAPABILITYDW2POWERRAIL = 3'h0;
parameter [2:0] PBCAPABILITYDW2TYPE = 3'h0;
parameter [2:0] PBCAPABILITYDW3PMSUBSTATE = 3'h0;
parameter [2:0] PBCAPABILITYDW3POWERRAIL = 3'h0;
parameter [2:0] PBCAPABILITYDW3TYPE = 3'h0;
parameter [2:0] PMCAPABILITYAUXCURRENT = 3'h0;
parameter [2:0] PORTVCCAPABILITYEXTENDEDVCCOUNT = 3'h0;
parameter [31:0] CARDBUSCISPOINTER = 32'h0;
parameter [3:0] XPDEVICEPORTTYPE = 4'h0;
parameter [4:0] PCIECAPABILITYINTMSGNUM = 5'h0;
parameter [4:0] PMCAPABILITYPMESUPPORT = 5'h0;
parameter [5:0] BAR0MASKWIDTH = 6'h14;
parameter [5:0] BAR1MASKWIDTH = 6'h0;
parameter [5:0] BAR2MASKWIDTH = 6'h0;
parameter [5:0] BAR3MASKWIDTH = 6'h0;
parameter [5:0] BAR4MASKWIDTH = 6'h0;
parameter [5:0] BAR5MASKWIDTH = 6'h0;
parameter [5:0] LINKCAPABILITYMAXLINKWIDTH = 6'h01;
parameter [63:0] DEVICESERIALNUMBER = 64'hE000000001000A35;
parameter [6:0] VC0TOTALCREDITSCH = 7'h0;
parameter [6:0] VC0TOTALCREDITSNPH = 7'h08;
parameter [6:0] VC0TOTALCREDITSPH = 7'h08;
parameter [6:0] VC1TOTALCREDITSCH = 7'h0;
parameter [6:0] VC1TOTALCREDITSNPH = 7'h0;
parameter [6:0] VC1TOTALCREDITSPH = 7'h0;
parameter [7:0] ACTIVELANESIN = 8'h1;
parameter [7:0] CAPABILITIESPOINTER = 8'h40;
parameter [7:0] EXTCFGCAPPTR = 8'h0;
parameter [7:0] HEADERTYPE = 8'h0;
parameter [7:0] INTERRUPTPIN = 8'h0;
parameter [7:0] MSICAPABILITYNEXTPTR = 8'h60;
parameter [7:0] PBCAPABILITYDW0BASEPOWER = 8'h0;
parameter [7:0] PBCAPABILITYDW1BASEPOWER = 8'h0;
parameter [7:0] PBCAPABILITYDW2BASEPOWER = 8'h0;
parameter [7:0] PBCAPABILITYDW3BASEPOWER = 8'h0;
parameter [7:0] PCIECAPABILITYNEXTPTR = 8'h0;
parameter [7:0] PMCAPABILITYNEXTPTR = 8'h60;
parameter [7:0] PMDATA0 = 8'h0;
parameter [7:0] PMDATA1 = 8'h0;
parameter [7:0] PMDATA2 = 8'h0;
parameter [7:0] PMDATA3 = 8'h0;
parameter [7:0] PMDATA4 = 8'h0;
parameter [7:0] PMDATA5 = 8'h0;
parameter [7:0] PMDATA6 = 8'h0;
parameter [7:0] PMDATA7 = 8'h0;
parameter [7:0] PMDATA8 = 8'h0;
parameter [7:0] PORTVCCAPABILITYVCARBCAP = 8'h0;
parameter [7:0] PORTVCCAPABILITYVCARBTABLEOFFSET = 8'h0;
parameter [7:0] REVISIONID = 8'h0;
parameter [7:0] SLOTCAPABILITYSLOTPOWERLIMITVALUE = 8'h0;
parameter [7:0] XPBASEPTR = 8'h60;
parameter integer BAR0ADDRWIDTH = 0;
parameter integer BAR0IOMEMN = 0;
parameter integer BAR1ADDRWIDTH = 0;
parameter integer BAR1IOMEMN = 0;
parameter integer BAR2ADDRWIDTH = 0;
parameter integer BAR2IOMEMN = 0;
parameter integer BAR3ADDRWIDTH = 0;
parameter integer BAR3IOMEMN = 0;
parameter integer BAR4ADDRWIDTH = 0;
parameter integer BAR4IOMEMN = 0;
parameter integer BAR5IOMEMN = 0;
parameter integer DUALROLECFGCNTRLROOTEPN = 0;
parameter integer L0SEXITLATENCY = 7;
parameter integer L0SEXITLATENCYCOMCLK = 7;
parameter integer L1EXITLATENCY = 7;
parameter integer L1EXITLATENCYCOMCLK = 7;
parameter integer LOWPRIORITYVCCOUNT = 0;
parameter integer PCIEREVISION = 1;
parameter integer PMDATASCALE0 = 0;
parameter integer PMDATASCALE1 = 0;
parameter integer PMDATASCALE2 = 0;
parameter integer PMDATASCALE3 = 0;
parameter integer PMDATASCALE4 = 0;
parameter integer PMDATASCALE5 = 0;
parameter integer PMDATASCALE6 = 0;
parameter integer PMDATASCALE7 = 0;
parameter integer PMDATASCALE8 = 0;
parameter integer RETRYRAMREADLATENCY = 3;
parameter integer RETRYRAMWIDTH = 0;
parameter integer RETRYRAMWRITELATENCY = 1;
parameter integer TLRAMREADLATENCY = 3;
parameter integer TLRAMWIDTH = 0;
parameter integer TLRAMWRITELATENCY = 1;
parameter integer TXTSNFTS = 255;
parameter integer TXTSNFTSCOMCLK = 255;
parameter integer XPMAXPAYLOAD = 0;
parameter integer XPRCBCONTROL = 0;

localparam in_delay = 0;
localparam out_delay = 0;
localparam CLK_DELAY = 0;

output BUSMASTERENABLE;
output CRMDOHOTRESETN;
output CRMPWRSOFTRESETN;
output CRMRXHOTRESETN;
output DLLTXPMDLLPOUTSTANDING;
output INTERRUPTDISABLE;
output IOSPACEENABLE;
output L0ASAUTONOMOUSINITCOMPLETED;
output L0CFGLOOPBACKACK;
output L0CORRERRMSGRCVD;
output L0DLLASTXSTATE;
output L0DLLRXACKOUTSTANDING;
output L0DLLTXNONFCOUTSTANDING;
output L0DLLTXOUTSTANDING;
output L0FATALERRMSGRCVD;
output L0FIRSTCFGWRITEOCCURRED;
output L0FWDCORRERROUT;
output L0FWDFATALERROUT;
output L0FWDNONFATALERROUT;
output L0MACENTEREDL0;
output L0MACLINKTRAINING;
output L0MACLINKUP;
output L0MACNEWSTATEACK;
output L0MACRXL0SSTATE;
output L0MACUPSTREAMDOWNSTREAM;
output L0MSIENABLE0;
output L0NONFATALERRMSGRCVD;
output L0PMEACK;
output L0PMEEN;
output L0PMEREQOUT;
output L0POWERCONTROLLERCONTROL;
output L0PWRINHIBITTRANSFERS;
output L0PWRL1STATE;
output L0PWRL23READYDEVICE;
output L0PWRL23READYSTATE;
output L0PWRTURNOFFREQ;
output L0PWRTXL0SSTATE;
output L0RECEIVEDASSERTINTALEGACYINT;
output L0RECEIVEDASSERTINTBLEGACYINT;
output L0RECEIVEDASSERTINTCLEGACYINT;
output L0RECEIVEDASSERTINTDLEGACYINT;
output L0RECEIVEDDEASSERTINTALEGACYINT;
output L0RECEIVEDDEASSERTINTBLEGACYINT;
output L0RECEIVEDDEASSERTINTCLEGACYINT;
output L0RECEIVEDDEASSERTINTDLEGACYINT;
output L0RXBEACON;
output L0RXDLLPM;
output L0RXDLLSBFCUPDATE;
output L0RXDLLTLPECRCOK;
output L0STATSCFGOTHERRECEIVED;
output L0STATSCFGOTHERTRANSMITTED;
output L0STATSCFGRECEIVED;
output L0STATSCFGTRANSMITTED;
output L0STATSDLLPRECEIVED;
output L0STATSDLLPTRANSMITTED;
output L0STATSOSRECEIVED;
output L0STATSOSTRANSMITTED;
output L0STATSTLPRECEIVED;
output L0STATSTLPTRANSMITTED;
output L0TOGGLEELECTROMECHANICALINTERLOCK;
output L0TXDLLPMUPDATED;
output L0TXDLLSBFCUPDATED;
output L0UNLOCKRECEIVED;
output LLKRX4DWHEADERN;
output LLKRXCHCONFIGAVAILABLEN;
output LLKRXCHCONFIGPARTIALN;
output LLKRXECRCBADN;
output LLKRXEOFN;
output LLKRXEOPN;
output LLKRXSOFN;
output LLKRXSOPN;
output LLKRXSRCDSCN;
output LLKRXSRCLASTREQN;
output LLKRXSRCRDYN;
output LLKTXCONFIGREADYN;
output LLKTXDSTRDYN;
output MEMSPACEENABLE;
output MIMDLLBREN;
output MIMDLLBWEN;
output MIMRXBREN;
output MIMRXBWEN;
output MIMTXBREN;
output MIMTXBWEN;
output PARITYERRORRESPONSE;
output PIPEDESKEWLANESL0;
output PIPEDESKEWLANESL1;
output PIPEDESKEWLANESL2;
output PIPEDESKEWLANESL3;
output PIPEDESKEWLANESL4;
output PIPEDESKEWLANESL5;
output PIPEDESKEWLANESL6;
output PIPEDESKEWLANESL7;
output PIPERESETL0;
output PIPERESETL1;
output PIPERESETL2;
output PIPERESETL3;
output PIPERESETL4;
output PIPERESETL5;
output PIPERESETL6;
output PIPERESETL7;
output PIPERXPOLARITYL0;
output PIPERXPOLARITYL1;
output PIPERXPOLARITYL2;
output PIPERXPOLARITYL3;
output PIPERXPOLARITYL4;
output PIPERXPOLARITYL5;
output PIPERXPOLARITYL6;
output PIPERXPOLARITYL7;
output PIPETXCOMPLIANCEL0;
output PIPETXCOMPLIANCEL1;
output PIPETXCOMPLIANCEL2;
output PIPETXCOMPLIANCEL3;
output PIPETXCOMPLIANCEL4;
output PIPETXCOMPLIANCEL5;
output PIPETXCOMPLIANCEL6;
output PIPETXCOMPLIANCEL7;
output PIPETXDATAKL0;
output PIPETXDATAKL1;
output PIPETXDATAKL2;
output PIPETXDATAKL3;
output PIPETXDATAKL4;
output PIPETXDATAKL5;
output PIPETXDATAKL6;
output PIPETXDATAKL7;
output PIPETXDETECTRXLOOPBACKL0;
output PIPETXDETECTRXLOOPBACKL1;
output PIPETXDETECTRXLOOPBACKL2;
output PIPETXDETECTRXLOOPBACKL3;
output PIPETXDETECTRXLOOPBACKL4;
output PIPETXDETECTRXLOOPBACKL5;
output PIPETXDETECTRXLOOPBACKL6;
output PIPETXDETECTRXLOOPBACKL7;
output PIPETXELECIDLEL0;
output PIPETXELECIDLEL1;
output PIPETXELECIDLEL2;
output PIPETXELECIDLEL3;
output PIPETXELECIDLEL4;
output PIPETXELECIDLEL5;
output PIPETXELECIDLEL6;
output PIPETXELECIDLEL7;
output SERRENABLE;
output URREPORTINGENABLE;
output [11:0] MGMTSTATSCREDIT;
output [11:0] MIMDLLBRADD;
output [11:0] MIMDLLBWADD;
output [12:0] L0COMPLETERID;
output [12:0] MIMRXBRADD;
output [12:0] MIMRXBWADD;
output [12:0] MIMTXBRADD;
output [12:0] MIMTXBWADD;
output [15:0] L0ERRMSGREQID;
output [15:0] LLKRXPREFERREDTYPE;
output [16:0] MGMTPSO;
output [18:0] L0RXDLLSBFCDATA;
output [19:0] L0RXDLLFCNPOSTBYPCRED;
output [1:0] L0ATTENTIONINDICATORCONTROL;
output [1:0] L0DLLASRXSTATE;
output [1:0] L0POWERINDICATORCONTROL;
output [1:0] L0PWRSTATE0;
output [1:0] L0RXDLLTLPEND;
output [1:0] L0RXMACLINKERROR;
output [1:0] LLKRXVALIDN;
output [1:0] PIPEPOWERDOWNL0;
output [1:0] PIPEPOWERDOWNL1;
output [1:0] PIPEPOWERDOWNL2;
output [1:0] PIPEPOWERDOWNL3;
output [1:0] PIPEPOWERDOWNL4;
output [1:0] PIPEPOWERDOWNL5;
output [1:0] PIPEPOWERDOWNL6;
output [1:0] PIPEPOWERDOWNL7;
output [23:0] L0RXDLLFCCMPLMCCRED;
output [23:0] L0RXDLLFCPOSTORDCRED;
output [2:0] L0MCFOUND;
output [2:0] L0MULTIMSGEN0;
output [2:0] L0RXDLLPMTYPE;
output [2:0] L0TRANSFORMEDVC;
output [2:0] MAXPAYLOADSIZE;
output [2:0] MAXREADREQUESTSIZE;
output [31:0] MGMTRDATA;
output [3:0] L0LTSSMSTATE;
output [3:0] L0MACNEGOTIATEDLINKWIDTH;
output [3:0] L0UCBYPFOUND;
output [3:0] L0UCORDFOUND;
output [63:0] LLKRXDATA;
output [63:0] MIMDLLBWDATA;
output [63:0] MIMRXBWDATA;
output [63:0] MIMTXBWDATA;
output [6:0] L0DLLERRORVECTOR;
output [7:0] L0DLLVCSTATUS;
output [7:0] L0DLUPDOWN;
output [7:0] L0RXDLLFCCMPLMCUPDATE;
output [7:0] L0RXDLLFCNPOSTBYPUPDATE;
output [7:0] L0RXDLLFCPOSTORDUPDATE;
output [7:0] L0TXDLLFCCMPLMCUPDATED;
output [7:0] L0TXDLLFCNPOSTBYPUPDATED;
output [7:0] L0TXDLLFCPOSTORDUPDATED;
output [7:0] LLKRXCHCOMPLETIONAVAILABLEN;
output [7:0] LLKRXCHCOMPLETIONPARTIALN;
output [7:0] LLKRXCHNONPOSTEDAVAILABLEN;
output [7:0] LLKRXCHNONPOSTEDPARTIALN;
output [7:0] LLKRXCHPOSTEDAVAILABLEN;
output [7:0] LLKRXCHPOSTEDPARTIALN;
output [7:0] LLKTCSTATUS;
output [7:0] LLKTXCHCOMPLETIONREADYN;
output [7:0] LLKTXCHNONPOSTEDREADYN;
output [7:0] LLKTXCHPOSTEDREADYN;
output [7:0] PIPETXDATAL0;
output [7:0] PIPETXDATAL1;
output [7:0] PIPETXDATAL2;
output [7:0] PIPETXDATAL3;
output [7:0] PIPETXDATAL4;
output [7:0] PIPETXDATAL5;
output [7:0] PIPETXDATAL6;
output [7:0] PIPETXDATAL7;
output [9:0] LLKTXCHANSPACE;

input AUXPOWER;
input COMPLIANCEAVOID;
input CRMCFGBRIDGEHOTRESET;
input CRMCORECLK;
input CRMCORECLKDLO;
input CRMCORECLKRXO;
input CRMCORECLKTXO;
input CRMLINKRSTN;
input CRMMACRSTN;
input CRMMGMTRSTN;
input CRMNVRSTN;
input CRMTXHOTRESETN;
input CRMURSTN;
input CRMUSERCFGRSTN;
input CRMUSERCLK;
input CRMUSERCLKRXO;
input CRMUSERCLKTXO;
input CROSSLINKSEED;
input L0ALLDOWNPORTSINL1;
input L0ALLDOWNRXPORTSINL0S;
input L0ASE;
input L0ATTENTIONBUTTONPRESSED;
input L0CFGASSPANTREEOWNEDSTATE;
input L0CFGDISABLESCRAMBLE;
input L0CFGEXTENDEDSYNC;
input L0CFGL0SENTRYENABLE;
input L0CFGL0SENTRYSUP;
input L0CFGLINKDISABLE;
input L0CFGLOOPBACKMASTER;
input L0DLLHOLDLINKUP;
input L0ELECTROMECHANICALINTERLOCKENGAGED;
input L0FWDASSERTINTALEGACYINT;
input L0FWDASSERTINTBLEGACYINT;
input L0FWDASSERTINTCLEGACYINT;
input L0FWDASSERTINTDLEGACYINT;
input L0FWDCORRERRIN;
input L0FWDDEASSERTINTALEGACYINT;
input L0FWDDEASSERTINTBLEGACYINT;
input L0FWDDEASSERTINTCLEGACYINT;
input L0FWDDEASSERTINTDLEGACYINT;
input L0FWDFATALERRIN;
input L0FWDNONFATALERRIN;
input L0LEGACYINTFUNCT0;
input L0MRLSENSORCLOSEDN;
input L0PMEREQIN;
input L0POWERFAULTDETECTED;
input L0PRESENCEDETECTSLOTEMPTYN;
input L0PWRNEWSTATEREQ;
input L0ROOTTURNOFFREQ;
input L0SENDUNLOCKMESSAGE;
input L0SETCOMPLETERABORTERROR;
input L0SETCOMPLETIONTIMEOUTCORRERROR;
input L0SETCOMPLETIONTIMEOUTUNCORRERROR;
input L0SETDETECTEDCORRERROR;
input L0SETDETECTEDFATALERROR;
input L0SETDETECTEDNONFATALERROR;
input L0SETLINKDETECTEDPARITYERROR;
input L0SETLINKMASTERDATAPARITY;
input L0SETLINKRECEIVEDMASTERABORT;
input L0SETLINKRECEIVEDTARGETABORT;
input L0SETLINKSIGNALLEDTARGETABORT;
input L0SETLINKSYSTEMERROR;
input L0SETUNEXPECTEDCOMPLETIONCORRERROR;
input L0SETUNEXPECTEDCOMPLETIONUNCORRERROR;
input L0SETUNSUPPORTEDREQUESTNONPOSTEDERROR;
input L0SETUNSUPPORTEDREQUESTOTHERERROR;
input L0SETUSERDETECTEDPARITYERROR;
input L0SETUSERMASTERDATAPARITY;
input L0SETUSERRECEIVEDMASTERABORT;
input L0SETUSERRECEIVEDTARGETABORT;
input L0SETUSERSIGNALLEDTARGETABORT;
input L0SETUSERSYSTEMERROR;
input L0TLASFCCREDSTARVATION;
input L0TLLINKRETRAIN;
input L0TRANSACTIONSPENDING;
input L0TXBEACON;
input L0TXCFGPM;
input L0TXTLSBFCUPDATE;
input L0TXTLTLPEDB;
input L0TXTLTLPREQ;
input L0TXTLTLPREQEND;
input L0TXTLTLPWIDTH;
input L0UPSTREAMRXPORTINL0S;
input L0VC0PREVIEWEXPAND;
input L0WAKEN;
input LLKRXDSTCONTREQN;
input LLKRXDSTREQN;
input LLKTX4DWHEADERN;
input LLKTXCOMPLETEN;
input LLKTXCREATEECRCN;
input LLKTXEOFN;
input LLKTXEOPN;
input LLKTXSOFN;
input LLKTXSOPN;
input LLKTXSRCDSCN;
input LLKTXSRCRDYN;
input MAINPOWER;
input MGMTRDEN;
input MGMTWREN;
input PIPEPHYSTATUSL0;
input PIPEPHYSTATUSL1;
input PIPEPHYSTATUSL2;
input PIPEPHYSTATUSL3;
input PIPEPHYSTATUSL4;
input PIPEPHYSTATUSL5;
input PIPEPHYSTATUSL6;
input PIPEPHYSTATUSL7;
input PIPERXCHANISALIGNEDL0;
input PIPERXCHANISALIGNEDL1;
input PIPERXCHANISALIGNEDL2;
input PIPERXCHANISALIGNEDL3;
input PIPERXCHANISALIGNEDL4;
input PIPERXCHANISALIGNEDL5;
input PIPERXCHANISALIGNEDL6;
input PIPERXCHANISALIGNEDL7;
input PIPERXDATAKL0;
input PIPERXDATAKL1;
input PIPERXDATAKL2;
input PIPERXDATAKL3;
input PIPERXDATAKL4;
input PIPERXDATAKL5;
input PIPERXDATAKL6;
input PIPERXDATAKL7;
input PIPERXELECIDLEL0;
input PIPERXELECIDLEL1;
input PIPERXELECIDLEL2;
input PIPERXELECIDLEL3;
input PIPERXELECIDLEL4;
input PIPERXELECIDLEL5;
input PIPERXELECIDLEL6;
input PIPERXELECIDLEL7;
input PIPERXVALIDL0;
input PIPERXVALIDL1;
input PIPERXVALIDL2;
input PIPERXVALIDL3;
input PIPERXVALIDL4;
input PIPERXVALIDL5;
input PIPERXVALIDL6;
input PIPERXVALIDL7;
input [10:0] MGMTADDR;
input [11:0] L0ACKNAKTIMERADJUSTMENT;
input [11:0] L0REPLAYTIMERADJUSTMENT;
input [127:0] L0PACKETHEADERFROMUSER;
input [159:0] L0TXTLFCCMPLMCCRED;
input [159:0] L0TXTLFCPOSTORDCRED;
input [15:0] L0TXTLFCCMPLMCUPDATE;
input [15:0] L0TXTLFCNPOSTBYPUPDATE;
input [15:0] L0TXTLFCPOSTORDUPDATE;
input [18:0] L0TXTLSBFCDATA;
input [191:0] L0TXTLFCNPOSTBYPCRED;
input [1:0] L0PWRNEXTLINKSTATE;
input [1:0] L0TXTLTLPENABLE;
input [1:0] L0TXTLTLPEND;
input [1:0] LLKRXCHFIFO;
input [1:0] LLKTXCHFIFO;
input [1:0] LLKTXENABLEN;
input [23:0] L0CFGVCID;
input [2:0] L0ASTURNPOOLBITSCONSUMED;
input [2:0] L0CFGL0SEXITLAT;
input [2:0] L0CFGNEGOTIATEDMAXP;
input [2:0] L0TXCFGPMTYPE;
input [2:0] LLKRXCHTC;
input [2:0] LLKTXCHTC;
input [2:0] PIPERXSTATUSL0;
input [2:0] PIPERXSTATUSL1;
input [2:0] PIPERXSTATUSL2;
input [2:0] PIPERXSTATUSL3;
input [2:0] PIPERXSTATUSL4;
input [2:0] PIPERXSTATUSL5;
input [2:0] PIPERXSTATUSL6;
input [2:0] PIPERXSTATUSL7;
input [31:0] MGMTWDATA;
input [3:0] L0CFGASSTATECHANGECMD;
input [3:0] L0MSIREQUEST0;
input [3:0] L0TXTLTLPLATENCY;
input [3:0] MGMTBWREN;
input [5:0] CFGNEGOTIATEDLINKWIDTH;
input [63:0] L0TXTLTLPDATA;
input [63:0] LLKTXDATA;
input [63:0] MIMDLLBRDATA;
input [63:0] MIMRXBRDATA;
input [63:0] MIMTXBRDATA;
input [6:0] MGMTSTATSCREDITSEL;
input [7:0] L0ASPORTCOUNT;
input [7:0] L0CFGVCENABLE;
input [7:0] L0PORTNUMBER;
input [7:0] L0RXTLTLPNONINITIALIZEDVC;
input [7:0] PIPERXDATAL0;
input [7:0] PIPERXDATAL1;
input [7:0] PIPERXDATAL2;
input [7:0] PIPERXDATAL3;
input [7:0] PIPERXDATAL4;
input [7:0] PIPERXDATAL5;
input [7:0] PIPERXDATAL6;
input [7:0] PIPERXDATAL7;

reg AERCAPABILITYECRCCHECKCAPABLE_BINARY;
reg AERCAPABILITYECRCGENCAPABLE_BINARY;
reg BAR0ADDRWIDTH_BINARY;
reg BAR0EXIST_BINARY;
reg BAR0IOMEMN_BINARY;
reg BAR0PREFETCHABLE_BINARY;
reg BAR1ADDRWIDTH_BINARY;
reg BAR1EXIST_BINARY;
reg BAR1IOMEMN_BINARY;
reg BAR1PREFETCHABLE_BINARY;
reg BAR2ADDRWIDTH_BINARY;
reg BAR2EXIST_BINARY;
reg BAR2IOMEMN_BINARY;
reg BAR2PREFETCHABLE_BINARY;
reg BAR3ADDRWIDTH_BINARY;
reg BAR3EXIST_BINARY;
reg BAR3IOMEMN_BINARY;
reg BAR3PREFETCHABLE_BINARY;
reg BAR4ADDRWIDTH_BINARY;
reg BAR4EXIST_BINARY;
reg BAR4IOMEMN_BINARY;
reg BAR4PREFETCHABLE_BINARY;
reg BAR5EXIST_BINARY;
reg BAR5IOMEMN_BINARY;
reg BAR5PREFETCHABLE_BINARY;
reg CLKDIVIDED_BINARY;
reg DUALCOREENABLE_BINARY;
reg DUALCORESLAVE_BINARY;
reg DUALROLECFGCNTRLROOTEPN_BINARY;
reg INFINITECOMPLETIONS_BINARY;
reg ISSWITCH_BINARY;
reg LINKSTATUSSLOTCLOCKCONFIG_BINARY;
reg LLKBYPASS_BINARY;
reg PBCAPABILITYSYSTEMALLOCATED_BINARY;
reg PCIECAPABILITYSLOTIMPL_BINARY;
reg PCIEREVISION_BINARY;
reg PMCAPABILITYD1SUPPORT_BINARY;
reg PMCAPABILITYD2SUPPORT_BINARY;
reg PMCAPABILITYDSI_BINARY;
reg RAMSHARETXRX_BINARY;
reg RESETMODE_BINARY;
reg RETRYRAMWIDTH_BINARY;
reg RETRYREADADDRPIPE_BINARY;
reg RETRYREADDATAPIPE_BINARY;
reg RETRYWRITEPIPE_BINARY;
reg RXREADADDRPIPE_BINARY;
reg RXREADDATAPIPE_BINARY;
reg RXWRITEPIPE_BINARY;
reg SELECTASMODE_BINARY;
reg SELECTDLLIF_BINARY;
reg SLOTCAPABILITYATTBUTTONPRESENT_BINARY;
reg SLOTCAPABILITYATTINDICATORPRESENT_BINARY;
reg SLOTCAPABILITYHOTPLUGCAPABLE_BINARY;
reg SLOTCAPABILITYHOTPLUGSURPRISE_BINARY;
reg SLOTCAPABILITYMSLSENSORPRESENT_BINARY;
reg SLOTCAPABILITYPOWERCONTROLLERPRESENT_BINARY;
reg SLOTCAPABILITYPOWERINDICATORPRESENT_BINARY;
reg SLOTIMPLEMENTED_BINARY;
reg TLRAMWIDTH_BINARY;
reg TXREADADDRPIPE_BINARY;
reg TXREADDATAPIPE_BINARY;
reg TXWRITEPIPE_BINARY;
reg UPSTREAMFACING_BINARY;
reg XLINKSUPPORTED_BINARY;
reg XPRCBCONTROL_BINARY;
reg [1:0] PMDATASCALE0_BINARY;
reg [1:0] PMDATASCALE1_BINARY;
reg [1:0] PMDATASCALE2_BINARY;
reg [1:0] PMDATASCALE3_BINARY;
reg [1:0] PMDATASCALE4_BINARY;
reg [1:0] PMDATASCALE5_BINARY;
reg [1:0] PMDATASCALE6_BINARY;
reg [1:0] PMDATASCALE7_BINARY;
reg [1:0] PMDATASCALE8_BINARY;
reg [2:0] L0SEXITLATENCYCOMCLK_BINARY;
reg [2:0] L0SEXITLATENCY_BINARY;
reg [2:0] L1EXITLATENCYCOMCLK_BINARY;
reg [2:0] L1EXITLATENCY_BINARY;
reg [2:0] LOWPRIORITYVCCOUNT_BINARY;
reg [2:0] RETRYRAMREADLATENCY_BINARY;
reg [2:0] RETRYRAMWRITELATENCY_BINARY;
reg [2:0] TLRAMREADLATENCY_BINARY;
reg [2:0] TLRAMWRITELATENCY_BINARY;
reg [2:0] XPMAXPAYLOAD_BINARY;
reg [7:0] TXTSNFTSCOMCLK_BINARY;
reg [7:0] TXTSNFTS_BINARY;

tri0 GSR = glbl.GSR;


initial begin
	case (TXTSNFTS)
		0 : TXTSNFTS_BINARY = 8'b00000000;
		1 : TXTSNFTS_BINARY = 8'b00000001;
		2 : TXTSNFTS_BINARY = 8'b00000010;
		3 : TXTSNFTS_BINARY = 8'b00000011;
		4 : TXTSNFTS_BINARY = 8'b00000100;
		5 : TXTSNFTS_BINARY = 8'b00000101;
		6 : TXTSNFTS_BINARY = 8'b00000110;
		7 : TXTSNFTS_BINARY = 8'b00000111;
		8 : TXTSNFTS_BINARY = 8'b00001000;
		9 : TXTSNFTS_BINARY = 8'b00001001;
		10 : TXTSNFTS_BINARY = 8'b00001010;
		11 : TXTSNFTS_BINARY = 8'b00001011;
		12 : TXTSNFTS_BINARY = 8'b00001100;
		13 : TXTSNFTS_BINARY = 8'b00001101;
		14 : TXTSNFTS_BINARY = 8'b00001110;
		15 : TXTSNFTS_BINARY = 8'b00001111;
		16 : TXTSNFTS_BINARY = 8'b00010000;
		17 : TXTSNFTS_BINARY = 8'b00010001;
		18 : TXTSNFTS_BINARY = 8'b00010010;
		19 : TXTSNFTS_BINARY = 8'b00010011;
		20 : TXTSNFTS_BINARY = 8'b00010100;
		21 : TXTSNFTS_BINARY = 8'b00010101;
		22 : TXTSNFTS_BINARY = 8'b00010110;
		23 : TXTSNFTS_BINARY = 8'b00010111;
		24 : TXTSNFTS_BINARY = 8'b00011000;
		25 : TXTSNFTS_BINARY = 8'b00011001;
		26 : TXTSNFTS_BINARY = 8'b00011010;
		27 : TXTSNFTS_BINARY = 8'b00011011;
		28 : TXTSNFTS_BINARY = 8'b00011100;
		29 : TXTSNFTS_BINARY = 8'b00011101;
		30 : TXTSNFTS_BINARY = 8'b00011110;
		31 : TXTSNFTS_BINARY = 8'b00011111;
		32 : TXTSNFTS_BINARY = 8'b00100000;
		33 : TXTSNFTS_BINARY = 8'b00100001;
		34 : TXTSNFTS_BINARY = 8'b00100010;
		35 : TXTSNFTS_BINARY = 8'b00100011;
		36 : TXTSNFTS_BINARY = 8'b00100100;
		37 : TXTSNFTS_BINARY = 8'b00100101;
		38 : TXTSNFTS_BINARY = 8'b00100110;
		39 : TXTSNFTS_BINARY = 8'b00100111;
		40 : TXTSNFTS_BINARY = 8'b00101000;
		41 : TXTSNFTS_BINARY = 8'b00101001;
		42 : TXTSNFTS_BINARY = 8'b00101010;
		43 : TXTSNFTS_BINARY = 8'b00101011;
		44 : TXTSNFTS_BINARY = 8'b00101100;
		45 : TXTSNFTS_BINARY = 8'b00101101;
		46 : TXTSNFTS_BINARY = 8'b00101110;
		47 : TXTSNFTS_BINARY = 8'b00101111;
		48 : TXTSNFTS_BINARY = 8'b00110000;
		49 : TXTSNFTS_BINARY = 8'b00110001;
		50 : TXTSNFTS_BINARY = 8'b00110010;
		51 : TXTSNFTS_BINARY = 8'b00110011;
		52 : TXTSNFTS_BINARY = 8'b00110100;
		53 : TXTSNFTS_BINARY = 8'b00110101;
		54 : TXTSNFTS_BINARY = 8'b00110110;
		55 : TXTSNFTS_BINARY = 8'b00110111;
		56 : TXTSNFTS_BINARY = 8'b00111000;
		57 : TXTSNFTS_BINARY = 8'b00111001;
		58 : TXTSNFTS_BINARY = 8'b00111010;
		59 : TXTSNFTS_BINARY = 8'b00111011;
		60 : TXTSNFTS_BINARY = 8'b00111100;
		61 : TXTSNFTS_BINARY = 8'b00111101;
		62 : TXTSNFTS_BINARY = 8'b00111110;
		63 : TXTSNFTS_BINARY = 8'b00111111;
		64 : TXTSNFTS_BINARY = 8'b01000000;
		65 : TXTSNFTS_BINARY = 8'b01000001;
		66 : TXTSNFTS_BINARY = 8'b01000010;
		67 : TXTSNFTS_BINARY = 8'b01000011;
		68 : TXTSNFTS_BINARY = 8'b01000100;
		69 : TXTSNFTS_BINARY = 8'b01000101;
		70 : TXTSNFTS_BINARY = 8'b01000110;
		71 : TXTSNFTS_BINARY = 8'b01000111;
		72 : TXTSNFTS_BINARY = 8'b01001000;
		73 : TXTSNFTS_BINARY = 8'b01001001;
		74 : TXTSNFTS_BINARY = 8'b01001010;
		75 : TXTSNFTS_BINARY = 8'b01001011;
		76 : TXTSNFTS_BINARY = 8'b01001100;
		77 : TXTSNFTS_BINARY = 8'b01001101;
		78 : TXTSNFTS_BINARY = 8'b01001110;
		79 : TXTSNFTS_BINARY = 8'b01001111;
		80 : TXTSNFTS_BINARY = 8'b01010000;
		81 : TXTSNFTS_BINARY = 8'b01010001;
		82 : TXTSNFTS_BINARY = 8'b01010010;
		83 : TXTSNFTS_BINARY = 8'b01010011;
		84 : TXTSNFTS_BINARY = 8'b01010100;
		85 : TXTSNFTS_BINARY = 8'b01010101;
		86 : TXTSNFTS_BINARY = 8'b01010110;
		87 : TXTSNFTS_BINARY = 8'b01010111;
		88 : TXTSNFTS_BINARY = 8'b01011000;
		89 : TXTSNFTS_BINARY = 8'b01011001;
		90 : TXTSNFTS_BINARY = 8'b01011010;
		91 : TXTSNFTS_BINARY = 8'b01011011;
		92 : TXTSNFTS_BINARY = 8'b01011100;
		93 : TXTSNFTS_BINARY = 8'b01011101;
		94 : TXTSNFTS_BINARY = 8'b01011110;
		95 : TXTSNFTS_BINARY = 8'b01011111;
		96 : TXTSNFTS_BINARY = 8'b01100000;
		97 : TXTSNFTS_BINARY = 8'b01100001;
		98 : TXTSNFTS_BINARY = 8'b01100010;
		99 : TXTSNFTS_BINARY = 8'b01100011;
		100 : TXTSNFTS_BINARY = 8'b01100100;
		101 : TXTSNFTS_BINARY = 8'b01100101;
		102 : TXTSNFTS_BINARY = 8'b01100110;
		103 : TXTSNFTS_BINARY = 8'b01100111;
		104 : TXTSNFTS_BINARY = 8'b01101000;
		105 : TXTSNFTS_BINARY = 8'b01101001;
		106 : TXTSNFTS_BINARY = 8'b01101010;
		107 : TXTSNFTS_BINARY = 8'b01101011;
		108 : TXTSNFTS_BINARY = 8'b01101100;
		109 : TXTSNFTS_BINARY = 8'b01101101;
		110 : TXTSNFTS_BINARY = 8'b01101110;
		111 : TXTSNFTS_BINARY = 8'b01101111;
		112 : TXTSNFTS_BINARY = 8'b01110000;
		113 : TXTSNFTS_BINARY = 8'b01110001;
		114 : TXTSNFTS_BINARY = 8'b01110010;
		115 : TXTSNFTS_BINARY = 8'b01110011;
		116 : TXTSNFTS_BINARY = 8'b01110100;
		117 : TXTSNFTS_BINARY = 8'b01110101;
		118 : TXTSNFTS_BINARY = 8'b01110110;
		119 : TXTSNFTS_BINARY = 8'b01110111;
		120 : TXTSNFTS_BINARY = 8'b01111000;
		121 : TXTSNFTS_BINARY = 8'b01111001;
		122 : TXTSNFTS_BINARY = 8'b01111010;
		123 : TXTSNFTS_BINARY = 8'b01111011;
		124 : TXTSNFTS_BINARY = 8'b01111100;
		125 : TXTSNFTS_BINARY = 8'b01111101;
		126 : TXTSNFTS_BINARY = 8'b01111110;
		127 : TXTSNFTS_BINARY = 8'b01111111;
		128 : TXTSNFTS_BINARY = 8'b10000000;
		129 : TXTSNFTS_BINARY = 8'b10000001;
		130 : TXTSNFTS_BINARY = 8'b10000010;
		131 : TXTSNFTS_BINARY = 8'b10000011;
		132 : TXTSNFTS_BINARY = 8'b10000100;
		133 : TXTSNFTS_BINARY = 8'b10000101;
		134 : TXTSNFTS_BINARY = 8'b10000110;
		135 : TXTSNFTS_BINARY = 8'b10000111;
		136 : TXTSNFTS_BINARY = 8'b10001000;
		137 : TXTSNFTS_BINARY = 8'b10001001;
		138 : TXTSNFTS_BINARY = 8'b10001010;
		139 : TXTSNFTS_BINARY = 8'b10001011;
		140 : TXTSNFTS_BINARY = 8'b10001100;
		141 : TXTSNFTS_BINARY = 8'b10001101;
		142 : TXTSNFTS_BINARY = 8'b10001110;
		143 : TXTSNFTS_BINARY = 8'b10001111;
		144 : TXTSNFTS_BINARY = 8'b10010000;
		145 : TXTSNFTS_BINARY = 8'b10010001;
		146 : TXTSNFTS_BINARY = 8'b10010010;
		147 : TXTSNFTS_BINARY = 8'b10010011;
		148 : TXTSNFTS_BINARY = 8'b10010100;
		149 : TXTSNFTS_BINARY = 8'b10010101;
		150 : TXTSNFTS_BINARY = 8'b10010110;
		151 : TXTSNFTS_BINARY = 8'b10010111;
		152 : TXTSNFTS_BINARY = 8'b10011000;
		153 : TXTSNFTS_BINARY = 8'b10011001;
		154 : TXTSNFTS_BINARY = 8'b10011010;
		155 : TXTSNFTS_BINARY = 8'b10011011;
		156 : TXTSNFTS_BINARY = 8'b10011100;
		157 : TXTSNFTS_BINARY = 8'b10011101;
		158 : TXTSNFTS_BINARY = 8'b10011110;
		159 : TXTSNFTS_BINARY = 8'b10011111;
		160 : TXTSNFTS_BINARY = 8'b10100000;
		161 : TXTSNFTS_BINARY = 8'b10100001;
		162 : TXTSNFTS_BINARY = 8'b10100010;
		163 : TXTSNFTS_BINARY = 8'b10100011;
		164 : TXTSNFTS_BINARY = 8'b10100100;
		165 : TXTSNFTS_BINARY = 8'b10100101;
		166 : TXTSNFTS_BINARY = 8'b10100110;
		167 : TXTSNFTS_BINARY = 8'b10100111;
		168 : TXTSNFTS_BINARY = 8'b10101000;
		169 : TXTSNFTS_BINARY = 8'b10101001;
		170 : TXTSNFTS_BINARY = 8'b10101010;
		171 : TXTSNFTS_BINARY = 8'b10101011;
		172 : TXTSNFTS_BINARY = 8'b10101100;
		173 : TXTSNFTS_BINARY = 8'b10101101;
		174 : TXTSNFTS_BINARY = 8'b10101110;
		175 : TXTSNFTS_BINARY = 8'b10101111;
		176 : TXTSNFTS_BINARY = 8'b10110000;
		177 : TXTSNFTS_BINARY = 8'b10110001;
		178 : TXTSNFTS_BINARY = 8'b10110010;
		179 : TXTSNFTS_BINARY = 8'b10110011;
		180 : TXTSNFTS_BINARY = 8'b10110100;
		181 : TXTSNFTS_BINARY = 8'b10110101;
		182 : TXTSNFTS_BINARY = 8'b10110110;
		183 : TXTSNFTS_BINARY = 8'b10110111;
		184 : TXTSNFTS_BINARY = 8'b10111000;
		185 : TXTSNFTS_BINARY = 8'b10111001;
		186 : TXTSNFTS_BINARY = 8'b10111010;
		187 : TXTSNFTS_BINARY = 8'b10111011;
		188 : TXTSNFTS_BINARY = 8'b10111100;
		189 : TXTSNFTS_BINARY = 8'b10111101;
		190 : TXTSNFTS_BINARY = 8'b10111110;
		191 : TXTSNFTS_BINARY = 8'b10111111;
		192 : TXTSNFTS_BINARY = 8'b11000000;
		193 : TXTSNFTS_BINARY = 8'b11000001;
		194 : TXTSNFTS_BINARY = 8'b11000010;
		195 : TXTSNFTS_BINARY = 8'b11000011;
		196 : TXTSNFTS_BINARY = 8'b11000100;
		197 : TXTSNFTS_BINARY = 8'b11000101;
		198 : TXTSNFTS_BINARY = 8'b11000110;
		199 : TXTSNFTS_BINARY = 8'b11000111;
		200 : TXTSNFTS_BINARY = 8'b11001000;
		201 : TXTSNFTS_BINARY = 8'b11001001;
		202 : TXTSNFTS_BINARY = 8'b11001010;
		203 : TXTSNFTS_BINARY = 8'b11001011;
		204 : TXTSNFTS_BINARY = 8'b11001100;
		205 : TXTSNFTS_BINARY = 8'b11001101;
		206 : TXTSNFTS_BINARY = 8'b11001110;
		207 : TXTSNFTS_BINARY = 8'b11001111;
		208 : TXTSNFTS_BINARY = 8'b11010000;
		209 : TXTSNFTS_BINARY = 8'b11010001;
		210 : TXTSNFTS_BINARY = 8'b11010010;
		211 : TXTSNFTS_BINARY = 8'b11010011;
		212 : TXTSNFTS_BINARY = 8'b11010100;
		213 : TXTSNFTS_BINARY = 8'b11010101;
		214 : TXTSNFTS_BINARY = 8'b11010110;
		215 : TXTSNFTS_BINARY = 8'b11010111;
		216 : TXTSNFTS_BINARY = 8'b11011000;
		217 : TXTSNFTS_BINARY = 8'b11011001;
		218 : TXTSNFTS_BINARY = 8'b11011010;
		219 : TXTSNFTS_BINARY = 8'b11011011;
		220 : TXTSNFTS_BINARY = 8'b11011100;
		221 : TXTSNFTS_BINARY = 8'b11011101;
		222 : TXTSNFTS_BINARY = 8'b11011110;
		223 : TXTSNFTS_BINARY = 8'b11011111;
		224 : TXTSNFTS_BINARY = 8'b11100000;
		225 : TXTSNFTS_BINARY = 8'b11100001;
		226 : TXTSNFTS_BINARY = 8'b11100010;
		227 : TXTSNFTS_BINARY = 8'b11100011;
		228 : TXTSNFTS_BINARY = 8'b11100100;
		229 : TXTSNFTS_BINARY = 8'b11100101;
		230 : TXTSNFTS_BINARY = 8'b11100110;
		231 : TXTSNFTS_BINARY = 8'b11100111;
		232 : TXTSNFTS_BINARY = 8'b11101000;
		233 : TXTSNFTS_BINARY = 8'b11101001;
		234 : TXTSNFTS_BINARY = 8'b11101010;
		235 : TXTSNFTS_BINARY = 8'b11101011;
		236 : TXTSNFTS_BINARY = 8'b11101100;
		237 : TXTSNFTS_BINARY = 8'b11101101;
		238 : TXTSNFTS_BINARY = 8'b11101110;
		239 : TXTSNFTS_BINARY = 8'b11101111;
		240 : TXTSNFTS_BINARY = 8'b11110000;
		241 : TXTSNFTS_BINARY = 8'b11110001;
		242 : TXTSNFTS_BINARY = 8'b11110010;
		243 : TXTSNFTS_BINARY = 8'b11110011;
		244 : TXTSNFTS_BINARY = 8'b11110100;
		245 : TXTSNFTS_BINARY = 8'b11110101;
		246 : TXTSNFTS_BINARY = 8'b11110110;
		247 : TXTSNFTS_BINARY = 8'b11110111;
		248 : TXTSNFTS_BINARY = 8'b11111000;
		249 : TXTSNFTS_BINARY = 8'b11111001;
		250 : TXTSNFTS_BINARY = 8'b11111010;
		251 : TXTSNFTS_BINARY = 8'b11111011;
		252 : TXTSNFTS_BINARY = 8'b11111100;
		253 : TXTSNFTS_BINARY = 8'b11111101;
		254 : TXTSNFTS_BINARY = 8'b11111110;
		255 : TXTSNFTS_BINARY = 8'b11111111;
		default : begin
			$display("Attribute Syntax Error : The Attribute TXTSNFTS on PCIE_INTERNAL_1_1 instance %m is set to %d.  Legal values for this attribute are 0 to 255.", TXTSNFTS);
			$finish;
		end
	endcase

	case (TXTSNFTSCOMCLK)
		0 : TXTSNFTSCOMCLK_BINARY = 8'b00000000;
		1 : TXTSNFTSCOMCLK_BINARY = 8'b00000001;
		2 : TXTSNFTSCOMCLK_BINARY = 8'b00000010;
		3 : TXTSNFTSCOMCLK_BINARY = 8'b00000011;
		4 : TXTSNFTSCOMCLK_BINARY = 8'b00000100;
		5 : TXTSNFTSCOMCLK_BINARY = 8'b00000101;
		6 : TXTSNFTSCOMCLK_BINARY = 8'b00000110;
		7 : TXTSNFTSCOMCLK_BINARY = 8'b00000111;
		8 : TXTSNFTSCOMCLK_BINARY = 8'b00001000;
		9 : TXTSNFTSCOMCLK_BINARY = 8'b00001001;
		10 : TXTSNFTSCOMCLK_BINARY = 8'b00001010;
		11 : TXTSNFTSCOMCLK_BINARY = 8'b00001011;
		12 : TXTSNFTSCOMCLK_BINARY = 8'b00001100;
		13 : TXTSNFTSCOMCLK_BINARY = 8'b00001101;
		14 : TXTSNFTSCOMCLK_BINARY = 8'b00001110;
		15 : TXTSNFTSCOMCLK_BINARY = 8'b00001111;
		16 : TXTSNFTSCOMCLK_BINARY = 8'b00010000;
		17 : TXTSNFTSCOMCLK_BINARY = 8'b00010001;
		18 : TXTSNFTSCOMCLK_BINARY = 8'b00010010;
		19 : TXTSNFTSCOMCLK_BINARY = 8'b00010011;
		20 : TXTSNFTSCOMCLK_BINARY = 8'b00010100;
		21 : TXTSNFTSCOMCLK_BINARY = 8'b00010101;
		22 : TXTSNFTSCOMCLK_BINARY = 8'b00010110;
		23 : TXTSNFTSCOMCLK_BINARY = 8'b00010111;
		24 : TXTSNFTSCOMCLK_BINARY = 8'b00011000;
		25 : TXTSNFTSCOMCLK_BINARY = 8'b00011001;
		26 : TXTSNFTSCOMCLK_BINARY = 8'b00011010;
		27 : TXTSNFTSCOMCLK_BINARY = 8'b00011011;
		28 : TXTSNFTSCOMCLK_BINARY = 8'b00011100;
		29 : TXTSNFTSCOMCLK_BINARY = 8'b00011101;
		30 : TXTSNFTSCOMCLK_BINARY = 8'b00011110;
		31 : TXTSNFTSCOMCLK_BINARY = 8'b00011111;
		32 : TXTSNFTSCOMCLK_BINARY = 8'b00100000;
		33 : TXTSNFTSCOMCLK_BINARY = 8'b00100001;
		34 : TXTSNFTSCOMCLK_BINARY = 8'b00100010;
		35 : TXTSNFTSCOMCLK_BINARY = 8'b00100011;
		36 : TXTSNFTSCOMCLK_BINARY = 8'b00100100;
		37 : TXTSNFTSCOMCLK_BINARY = 8'b00100101;
		38 : TXTSNFTSCOMCLK_BINARY = 8'b00100110;
		39 : TXTSNFTSCOMCLK_BINARY = 8'b00100111;
		40 : TXTSNFTSCOMCLK_BINARY = 8'b00101000;
		41 : TXTSNFTSCOMCLK_BINARY = 8'b00101001;
		42 : TXTSNFTSCOMCLK_BINARY = 8'b00101010;
		43 : TXTSNFTSCOMCLK_BINARY = 8'b00101011;
		44 : TXTSNFTSCOMCLK_BINARY = 8'b00101100;
		45 : TXTSNFTSCOMCLK_BINARY = 8'b00101101;
		46 : TXTSNFTSCOMCLK_BINARY = 8'b00101110;
		47 : TXTSNFTSCOMCLK_BINARY = 8'b00101111;
		48 : TXTSNFTSCOMCLK_BINARY = 8'b00110000;
		49 : TXTSNFTSCOMCLK_BINARY = 8'b00110001;
		50 : TXTSNFTSCOMCLK_BINARY = 8'b00110010;
		51 : TXTSNFTSCOMCLK_BINARY = 8'b00110011;
		52 : TXTSNFTSCOMCLK_BINARY = 8'b00110100;
		53 : TXTSNFTSCOMCLK_BINARY = 8'b00110101;
		54 : TXTSNFTSCOMCLK_BINARY = 8'b00110110;
		55 : TXTSNFTSCOMCLK_BINARY = 8'b00110111;
		56 : TXTSNFTSCOMCLK_BINARY = 8'b00111000;
		57 : TXTSNFTSCOMCLK_BINARY = 8'b00111001;
		58 : TXTSNFTSCOMCLK_BINARY = 8'b00111010;
		59 : TXTSNFTSCOMCLK_BINARY = 8'b00111011;
		60 : TXTSNFTSCOMCLK_BINARY = 8'b00111100;
		61 : TXTSNFTSCOMCLK_BINARY = 8'b00111101;
		62 : TXTSNFTSCOMCLK_BINARY = 8'b00111110;
		63 : TXTSNFTSCOMCLK_BINARY = 8'b00111111;
		64 : TXTSNFTSCOMCLK_BINARY = 8'b01000000;
		65 : TXTSNFTSCOMCLK_BINARY = 8'b01000001;
		66 : TXTSNFTSCOMCLK_BINARY = 8'b01000010;
		67 : TXTSNFTSCOMCLK_BINARY = 8'b01000011;
		68 : TXTSNFTSCOMCLK_BINARY = 8'b01000100;
		69 : TXTSNFTSCOMCLK_BINARY = 8'b01000101;
		70 : TXTSNFTSCOMCLK_BINARY = 8'b01000110;
		71 : TXTSNFTSCOMCLK_BINARY = 8'b01000111;
		72 : TXTSNFTSCOMCLK_BINARY = 8'b01001000;
		73 : TXTSNFTSCOMCLK_BINARY = 8'b01001001;
		74 : TXTSNFTSCOMCLK_BINARY = 8'b01001010;
		75 : TXTSNFTSCOMCLK_BINARY = 8'b01001011;
		76 : TXTSNFTSCOMCLK_BINARY = 8'b01001100;
		77 : TXTSNFTSCOMCLK_BINARY = 8'b01001101;
		78 : TXTSNFTSCOMCLK_BINARY = 8'b01001110;
		79 : TXTSNFTSCOMCLK_BINARY = 8'b01001111;
		80 : TXTSNFTSCOMCLK_BINARY = 8'b01010000;
		81 : TXTSNFTSCOMCLK_BINARY = 8'b01010001;
		82 : TXTSNFTSCOMCLK_BINARY = 8'b01010010;
		83 : TXTSNFTSCOMCLK_BINARY = 8'b01010011;
		84 : TXTSNFTSCOMCLK_BINARY = 8'b01010100;
		85 : TXTSNFTSCOMCLK_BINARY = 8'b01010101;
		86 : TXTSNFTSCOMCLK_BINARY = 8'b01010110;
		87 : TXTSNFTSCOMCLK_BINARY = 8'b01010111;
		88 : TXTSNFTSCOMCLK_BINARY = 8'b01011000;
		89 : TXTSNFTSCOMCLK_BINARY = 8'b01011001;
		90 : TXTSNFTSCOMCLK_BINARY = 8'b01011010;
		91 : TXTSNFTSCOMCLK_BINARY = 8'b01011011;
		92 : TXTSNFTSCOMCLK_BINARY = 8'b01011100;
		93 : TXTSNFTSCOMCLK_BINARY = 8'b01011101;
		94 : TXTSNFTSCOMCLK_BINARY = 8'b01011110;
		95 : TXTSNFTSCOMCLK_BINARY = 8'b01011111;
		96 : TXTSNFTSCOMCLK_BINARY = 8'b01100000;
		97 : TXTSNFTSCOMCLK_BINARY = 8'b01100001;
		98 : TXTSNFTSCOMCLK_BINARY = 8'b01100010;
		99 : TXTSNFTSCOMCLK_BINARY = 8'b01100011;
		100 : TXTSNFTSCOMCLK_BINARY = 8'b01100100;
		101 : TXTSNFTSCOMCLK_BINARY = 8'b01100101;
		102 : TXTSNFTSCOMCLK_BINARY = 8'b01100110;
		103 : TXTSNFTSCOMCLK_BINARY = 8'b01100111;
		104 : TXTSNFTSCOMCLK_BINARY = 8'b01101000;
		105 : TXTSNFTSCOMCLK_BINARY = 8'b01101001;
		106 : TXTSNFTSCOMCLK_BINARY = 8'b01101010;
		107 : TXTSNFTSCOMCLK_BINARY = 8'b01101011;
		108 : TXTSNFTSCOMCLK_BINARY = 8'b01101100;
		109 : TXTSNFTSCOMCLK_BINARY = 8'b01101101;
		110 : TXTSNFTSCOMCLK_BINARY = 8'b01101110;
		111 : TXTSNFTSCOMCLK_BINARY = 8'b01101111;
		112 : TXTSNFTSCOMCLK_BINARY = 8'b01110000;
		113 : TXTSNFTSCOMCLK_BINARY = 8'b01110001;
		114 : TXTSNFTSCOMCLK_BINARY = 8'b01110010;
		115 : TXTSNFTSCOMCLK_BINARY = 8'b01110011;
		116 : TXTSNFTSCOMCLK_BINARY = 8'b01110100;
		117 : TXTSNFTSCOMCLK_BINARY = 8'b01110101;
		118 : TXTSNFTSCOMCLK_BINARY = 8'b01110110;
		119 : TXTSNFTSCOMCLK_BINARY = 8'b01110111;
		120 : TXTSNFTSCOMCLK_BINARY = 8'b01111000;
		121 : TXTSNFTSCOMCLK_BINARY = 8'b01111001;
		122 : TXTSNFTSCOMCLK_BINARY = 8'b01111010;
		123 : TXTSNFTSCOMCLK_BINARY = 8'b01111011;
		124 : TXTSNFTSCOMCLK_BINARY = 8'b01111100;
		125 : TXTSNFTSCOMCLK_BINARY = 8'b01111101;
		126 : TXTSNFTSCOMCLK_BINARY = 8'b01111110;
		127 : TXTSNFTSCOMCLK_BINARY = 8'b01111111;
		128 : TXTSNFTSCOMCLK_BINARY = 8'b10000000;
		129 : TXTSNFTSCOMCLK_BINARY = 8'b10000001;
		130 : TXTSNFTSCOMCLK_BINARY = 8'b10000010;
		131 : TXTSNFTSCOMCLK_BINARY = 8'b10000011;
		132 : TXTSNFTSCOMCLK_BINARY = 8'b10000100;
		133 : TXTSNFTSCOMCLK_BINARY = 8'b10000101;
		134 : TXTSNFTSCOMCLK_BINARY = 8'b10000110;
		135 : TXTSNFTSCOMCLK_BINARY = 8'b10000111;
		136 : TXTSNFTSCOMCLK_BINARY = 8'b10001000;
		137 : TXTSNFTSCOMCLK_BINARY = 8'b10001001;
		138 : TXTSNFTSCOMCLK_BINARY = 8'b10001010;
		139 : TXTSNFTSCOMCLK_BINARY = 8'b10001011;
		140 : TXTSNFTSCOMCLK_BINARY = 8'b10001100;
		141 : TXTSNFTSCOMCLK_BINARY = 8'b10001101;
		142 : TXTSNFTSCOMCLK_BINARY = 8'b10001110;
		143 : TXTSNFTSCOMCLK_BINARY = 8'b10001111;
		144 : TXTSNFTSCOMCLK_BINARY = 8'b10010000;
		145 : TXTSNFTSCOMCLK_BINARY = 8'b10010001;
		146 : TXTSNFTSCOMCLK_BINARY = 8'b10010010;
		147 : TXTSNFTSCOMCLK_BINARY = 8'b10010011;
		148 : TXTSNFTSCOMCLK_BINARY = 8'b10010100;
		149 : TXTSNFTSCOMCLK_BINARY = 8'b10010101;
		150 : TXTSNFTSCOMCLK_BINARY = 8'b10010110;
		151 : TXTSNFTSCOMCLK_BINARY = 8'b10010111;
		152 : TXTSNFTSCOMCLK_BINARY = 8'b10011000;
		153 : TXTSNFTSCOMCLK_BINARY = 8'b10011001;
		154 : TXTSNFTSCOMCLK_BINARY = 8'b10011010;
		155 : TXTSNFTSCOMCLK_BINARY = 8'b10011011;
		156 : TXTSNFTSCOMCLK_BINARY = 8'b10011100;
		157 : TXTSNFTSCOMCLK_BINARY = 8'b10011101;
		158 : TXTSNFTSCOMCLK_BINARY = 8'b10011110;
		159 : TXTSNFTSCOMCLK_BINARY = 8'b10011111;
		160 : TXTSNFTSCOMCLK_BINARY = 8'b10100000;
		161 : TXTSNFTSCOMCLK_BINARY = 8'b10100001;
		162 : TXTSNFTSCOMCLK_BINARY = 8'b10100010;
		163 : TXTSNFTSCOMCLK_BINARY = 8'b10100011;
		164 : TXTSNFTSCOMCLK_BINARY = 8'b10100100;
		165 : TXTSNFTSCOMCLK_BINARY = 8'b10100101;
		166 : TXTSNFTSCOMCLK_BINARY = 8'b10100110;
		167 : TXTSNFTSCOMCLK_BINARY = 8'b10100111;
		168 : TXTSNFTSCOMCLK_BINARY = 8'b10101000;
		169 : TXTSNFTSCOMCLK_BINARY = 8'b10101001;
		170 : TXTSNFTSCOMCLK_BINARY = 8'b10101010;
		171 : TXTSNFTSCOMCLK_BINARY = 8'b10101011;
		172 : TXTSNFTSCOMCLK_BINARY = 8'b10101100;
		173 : TXTSNFTSCOMCLK_BINARY = 8'b10101101;
		174 : TXTSNFTSCOMCLK_BINARY = 8'b10101110;
		175 : TXTSNFTSCOMCLK_BINARY = 8'b10101111;
		176 : TXTSNFTSCOMCLK_BINARY = 8'b10110000;
		177 : TXTSNFTSCOMCLK_BINARY = 8'b10110001;
		178 : TXTSNFTSCOMCLK_BINARY = 8'b10110010;
		179 : TXTSNFTSCOMCLK_BINARY = 8'b10110011;
		180 : TXTSNFTSCOMCLK_BINARY = 8'b10110100;
		181 : TXTSNFTSCOMCLK_BINARY = 8'b10110101;
		182 : TXTSNFTSCOMCLK_BINARY = 8'b10110110;
		183 : TXTSNFTSCOMCLK_BINARY = 8'b10110111;
		184 : TXTSNFTSCOMCLK_BINARY = 8'b10111000;
		185 : TXTSNFTSCOMCLK_BINARY = 8'b10111001;
		186 : TXTSNFTSCOMCLK_BINARY = 8'b10111010;
		187 : TXTSNFTSCOMCLK_BINARY = 8'b10111011;
		188 : TXTSNFTSCOMCLK_BINARY = 8'b10111100;
		189 : TXTSNFTSCOMCLK_BINARY = 8'b10111101;
		190 : TXTSNFTSCOMCLK_BINARY = 8'b10111110;
		191 : TXTSNFTSCOMCLK_BINARY = 8'b10111111;
		192 : TXTSNFTSCOMCLK_BINARY = 8'b11000000;
		193 : TXTSNFTSCOMCLK_BINARY = 8'b11000001;
		194 : TXTSNFTSCOMCLK_BINARY = 8'b11000010;
		195 : TXTSNFTSCOMCLK_BINARY = 8'b11000011;
		196 : TXTSNFTSCOMCLK_BINARY = 8'b11000100;
		197 : TXTSNFTSCOMCLK_BINARY = 8'b11000101;
		198 : TXTSNFTSCOMCLK_BINARY = 8'b11000110;
		199 : TXTSNFTSCOMCLK_BINARY = 8'b11000111;
		200 : TXTSNFTSCOMCLK_BINARY = 8'b11001000;
		201 : TXTSNFTSCOMCLK_BINARY = 8'b11001001;
		202 : TXTSNFTSCOMCLK_BINARY = 8'b11001010;
		203 : TXTSNFTSCOMCLK_BINARY = 8'b11001011;
		204 : TXTSNFTSCOMCLK_BINARY = 8'b11001100;
		205 : TXTSNFTSCOMCLK_BINARY = 8'b11001101;
		206 : TXTSNFTSCOMCLK_BINARY = 8'b11001110;
		207 : TXTSNFTSCOMCLK_BINARY = 8'b11001111;
		208 : TXTSNFTSCOMCLK_BINARY = 8'b11010000;
		209 : TXTSNFTSCOMCLK_BINARY = 8'b11010001;
		210 : TXTSNFTSCOMCLK_BINARY = 8'b11010010;
		211 : TXTSNFTSCOMCLK_BINARY = 8'b11010011;
		212 : TXTSNFTSCOMCLK_BINARY = 8'b11010100;
		213 : TXTSNFTSCOMCLK_BINARY = 8'b11010101;
		214 : TXTSNFTSCOMCLK_BINARY = 8'b11010110;
		215 : TXTSNFTSCOMCLK_BINARY = 8'b11010111;
		216 : TXTSNFTSCOMCLK_BINARY = 8'b11011000;
		217 : TXTSNFTSCOMCLK_BINARY = 8'b11011001;
		218 : TXTSNFTSCOMCLK_BINARY = 8'b11011010;
		219 : TXTSNFTSCOMCLK_BINARY = 8'b11011011;
		220 : TXTSNFTSCOMCLK_BINARY = 8'b11011100;
		221 : TXTSNFTSCOMCLK_BINARY = 8'b11011101;
		222 : TXTSNFTSCOMCLK_BINARY = 8'b11011110;
		223 : TXTSNFTSCOMCLK_BINARY = 8'b11011111;
		224 : TXTSNFTSCOMCLK_BINARY = 8'b11100000;
		225 : TXTSNFTSCOMCLK_BINARY = 8'b11100001;
		226 : TXTSNFTSCOMCLK_BINARY = 8'b11100010;
		227 : TXTSNFTSCOMCLK_BINARY = 8'b11100011;
		228 : TXTSNFTSCOMCLK_BINARY = 8'b11100100;
		229 : TXTSNFTSCOMCLK_BINARY = 8'b11100101;
		230 : TXTSNFTSCOMCLK_BINARY = 8'b11100110;
		231 : TXTSNFTSCOMCLK_BINARY = 8'b11100111;
		232 : TXTSNFTSCOMCLK_BINARY = 8'b11101000;
		233 : TXTSNFTSCOMCLK_BINARY = 8'b11101001;
		234 : TXTSNFTSCOMCLK_BINARY = 8'b11101010;
		235 : TXTSNFTSCOMCLK_BINARY = 8'b11101011;
		236 : TXTSNFTSCOMCLK_BINARY = 8'b11101100;
		237 : TXTSNFTSCOMCLK_BINARY = 8'b11101101;
		238 : TXTSNFTSCOMCLK_BINARY = 8'b11101110;
		239 : TXTSNFTSCOMCLK_BINARY = 8'b11101111;
		240 : TXTSNFTSCOMCLK_BINARY = 8'b11110000;
		241 : TXTSNFTSCOMCLK_BINARY = 8'b11110001;
		242 : TXTSNFTSCOMCLK_BINARY = 8'b11110010;
		243 : TXTSNFTSCOMCLK_BINARY = 8'b11110011;
		244 : TXTSNFTSCOMCLK_BINARY = 8'b11110100;
		245 : TXTSNFTSCOMCLK_BINARY = 8'b11110101;
		246 : TXTSNFTSCOMCLK_BINARY = 8'b11110110;
		247 : TXTSNFTSCOMCLK_BINARY = 8'b11110111;
		248 : TXTSNFTSCOMCLK_BINARY = 8'b11111000;
		249 : TXTSNFTSCOMCLK_BINARY = 8'b11111001;
		250 : TXTSNFTSCOMCLK_BINARY = 8'b11111010;
		251 : TXTSNFTSCOMCLK_BINARY = 8'b11111011;
		252 : TXTSNFTSCOMCLK_BINARY = 8'b11111100;
		253 : TXTSNFTSCOMCLK_BINARY = 8'b11111101;
		254 : TXTSNFTSCOMCLK_BINARY = 8'b11111110;
		255 : TXTSNFTSCOMCLK_BINARY = 8'b11111111;
		default : begin
			$display("Attribute Syntax Error : The Attribute TXTSNFTSCOMCLK on PCIE_INTERNAL_1_1 instance %m is set to %d.  Legal values for this attribute are 0 to 255.", TXTSNFTSCOMCLK);
			$finish;
		end
	endcase

	case (RETRYRAMREADLATENCY)
		0 : RETRYRAMREADLATENCY_BINARY = 3'b000;
		1 : RETRYRAMREADLATENCY_BINARY = 3'b001;
		2 : RETRYRAMREADLATENCY_BINARY = 3'b010;
		3 : RETRYRAMREADLATENCY_BINARY = 3'b011;
		4 : RETRYRAMREADLATENCY_BINARY = 3'b100;
		5 : RETRYRAMREADLATENCY_BINARY = 3'b101;
		6 : RETRYRAMREADLATENCY_BINARY = 3'b110;
		7 : RETRYRAMREADLATENCY_BINARY = 3'b111;
		default : begin
			$display("Attribute Syntax Error : The Attribute RETRYRAMREADLATENCY on PCIE_INTERNAL_1_1 instance %m is set to %d.  Legal values for this attribute are 0 to 7.", RETRYRAMREADLATENCY);
			$finish;
		end
	endcase

	case (RETRYRAMWRITELATENCY)
		0 : RETRYRAMWRITELATENCY_BINARY = 3'b000;
		1 : RETRYRAMWRITELATENCY_BINARY = 3'b001;
		2 : RETRYRAMWRITELATENCY_BINARY = 3'b010;
		3 : RETRYRAMWRITELATENCY_BINARY = 3'b011;
		4 : RETRYRAMWRITELATENCY_BINARY = 3'b100;
		5 : RETRYRAMWRITELATENCY_BINARY = 3'b101;
		6 : RETRYRAMWRITELATENCY_BINARY = 3'b110;
		7 : RETRYRAMWRITELATENCY_BINARY = 3'b111;
		default : begin
			$display("Attribute Syntax Error : The Attribute RETRYRAMWRITELATENCY on PCIE_INTERNAL_1_1 instance %m is set to %d.  Legal values for this attribute are 0 to 7.", RETRYRAMWRITELATENCY);
			$finish;
		end
	endcase

	case (RETRYRAMWIDTH)
		0 : RETRYRAMWIDTH_BINARY = 1'b0;
		1 : RETRYRAMWIDTH_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute RETRYRAMWIDTH on PCIE_INTERNAL_1_1 instance %m is set to %d.  Legal values for this attribute are 0 to 1.", RETRYRAMWIDTH);
			$finish;
		end
	endcase

	case (RETRYWRITEPIPE)
		"FALSE" : RETRYWRITEPIPE_BINARY = 1'b0;
		"TRUE" : RETRYWRITEPIPE_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute RETRYWRITEPIPE on PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", RETRYWRITEPIPE);
			$finish;
		end
	endcase

	case (RETRYREADADDRPIPE)
		"FALSE" : RETRYREADADDRPIPE_BINARY = 1'b0;
		"TRUE" : RETRYREADADDRPIPE_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute RETRYREADADDRPIPE on PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", RETRYREADADDRPIPE);
			$finish;
		end
	endcase

	case (RETRYREADDATAPIPE)
		"FALSE" : RETRYREADDATAPIPE_BINARY = 1'b0;
		"TRUE" : RETRYREADDATAPIPE_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute RETRYREADDATAPIPE on PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", RETRYREADDATAPIPE);
			$finish;
		end
	endcase

	case (XLINKSUPPORTED)
		"FALSE" : XLINKSUPPORTED_BINARY = 1'b0;
		"TRUE" : XLINKSUPPORTED_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute XLINKSUPPORTED on PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", XLINKSUPPORTED);
			$finish;
		end
	endcase

	case (INFINITECOMPLETIONS)
		"FALSE" : INFINITECOMPLETIONS_BINARY = 1'b0;
		"TRUE" : INFINITECOMPLETIONS_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute INFINITECOMPLETIONS on PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", INFINITECOMPLETIONS);
			$finish;
		end
	endcase

	case (TLRAMREADLATENCY)
		0 : TLRAMREADLATENCY_BINARY = 3'b000;
		1 : TLRAMREADLATENCY_BINARY = 3'b001;
		2 : TLRAMREADLATENCY_BINARY = 3'b010;
		3 : TLRAMREADLATENCY_BINARY = 3'b011;
		4 : TLRAMREADLATENCY_BINARY = 3'b100;
		5 : TLRAMREADLATENCY_BINARY = 3'b101;
		6 : TLRAMREADLATENCY_BINARY = 3'b110;
		7 : TLRAMREADLATENCY_BINARY = 3'b111;
		default : begin
			$display("Attribute Syntax Error : The Attribute TLRAMREADLATENCY on PCIE_INTERNAL_1_1 instance %m is set to %d.  Legal values for this attribute are 0 to 7.", TLRAMREADLATENCY);
			$finish;
		end
	endcase

	case (TLRAMWRITELATENCY)
		0 : TLRAMWRITELATENCY_BINARY = 3'b000;
		1 : TLRAMWRITELATENCY_BINARY = 3'b001;
		2 : TLRAMWRITELATENCY_BINARY = 3'b010;
		3 : TLRAMWRITELATENCY_BINARY = 3'b011;
		4 : TLRAMWRITELATENCY_BINARY = 3'b100;
		5 : TLRAMWRITELATENCY_BINARY = 3'b101;
		6 : TLRAMWRITELATENCY_BINARY = 3'b110;
		7 : TLRAMWRITELATENCY_BINARY = 3'b111;
		default : begin
			$display("Attribute Syntax Error : The Attribute TLRAMWRITELATENCY on PCIE_INTERNAL_1_1 instance %m is set to %d.  Legal values for this attribute are 0 to 7.", TLRAMWRITELATENCY);
			$finish;
		end
	endcase

	case (TLRAMWIDTH)
		0 : TLRAMWIDTH_BINARY = 1'b0;
		1 : TLRAMWIDTH_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute TLRAMWIDTH on PCIE_INTERNAL_1_1 instance %m is set to %d.  Legal values for this attribute are 0 to 1.", TLRAMWIDTH);
			$finish;
		end
	endcase

	case (RAMSHARETXRX)
		"FALSE" : RAMSHARETXRX_BINARY = 1'b0;
		"TRUE" : RAMSHARETXRX_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute RAMSHARETXRX on PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", RAMSHARETXRX);
			$finish;
		end
	endcase

	case (L0SEXITLATENCY)
		0 : L0SEXITLATENCY_BINARY = 3'b000;
		1 : L0SEXITLATENCY_BINARY = 3'b001;
		2 : L0SEXITLATENCY_BINARY = 3'b010;
		3 : L0SEXITLATENCY_BINARY = 3'b011;
		4 : L0SEXITLATENCY_BINARY = 3'b100;
		5 : L0SEXITLATENCY_BINARY = 3'b101;
		6 : L0SEXITLATENCY_BINARY = 3'b110;
		7 : L0SEXITLATENCY_BINARY = 3'b111;
		default : begin
			$display("Attribute Syntax Error : The Attribute L0SEXITLATENCY on PCIE_INTERNAL_1_1 instance %m is set to %d.  Legal values for this attribute are 0 to 7.", L0SEXITLATENCY);
			$finish;
		end
	endcase

	case (L0SEXITLATENCYCOMCLK)
		0 : L0SEXITLATENCYCOMCLK_BINARY = 3'b000;
		1 : L0SEXITLATENCYCOMCLK_BINARY = 3'b001;
		2 : L0SEXITLATENCYCOMCLK_BINARY = 3'b010;
		3 : L0SEXITLATENCYCOMCLK_BINARY = 3'b011;
		4 : L0SEXITLATENCYCOMCLK_BINARY = 3'b100;
		5 : L0SEXITLATENCYCOMCLK_BINARY = 3'b101;
		6 : L0SEXITLATENCYCOMCLK_BINARY = 3'b110;
		7 : L0SEXITLATENCYCOMCLK_BINARY = 3'b111;
		default : begin
			$display("Attribute Syntax Error : The Attribute L0SEXITLATENCYCOMCLK on PCIE_INTERNAL_1_1 instance %m is set to %d.  Legal values for this attribute are 0 to 7.", L0SEXITLATENCYCOMCLK);
			$finish;
		end
	endcase

	case (L1EXITLATENCY)
		0 : L1EXITLATENCY_BINARY = 3'b000;
		1 : L1EXITLATENCY_BINARY = 3'b001;
		2 : L1EXITLATENCY_BINARY = 3'b010;
		3 : L1EXITLATENCY_BINARY = 3'b011;
		4 : L1EXITLATENCY_BINARY = 3'b100;
		5 : L1EXITLATENCY_BINARY = 3'b101;
		6 : L1EXITLATENCY_BINARY = 3'b110;
		7 : L1EXITLATENCY_BINARY = 3'b111;
		default : begin
			$display("Attribute Syntax Error : The Attribute L1EXITLATENCY on PCIE_INTERNAL_1_1 instance %m is set to %d.  Legal values for this attribute are 0 to 7.", L1EXITLATENCY);
			$finish;
		end
	endcase

	case (L1EXITLATENCYCOMCLK)
		0 : L1EXITLATENCYCOMCLK_BINARY = 3'b000;
		1 : L1EXITLATENCYCOMCLK_BINARY = 3'b001;
		2 : L1EXITLATENCYCOMCLK_BINARY = 3'b010;
		3 : L1EXITLATENCYCOMCLK_BINARY = 3'b011;
		4 : L1EXITLATENCYCOMCLK_BINARY = 3'b100;
		5 : L1EXITLATENCYCOMCLK_BINARY = 3'b101;
		6 : L1EXITLATENCYCOMCLK_BINARY = 3'b110;
		7 : L1EXITLATENCYCOMCLK_BINARY = 3'b111;
		default : begin
			$display("Attribute Syntax Error : The Attribute L1EXITLATENCYCOMCLK on PCIE_INTERNAL_1_1 instance %m is set to %d.  Legal values for this attribute are 0 to 7.", L1EXITLATENCYCOMCLK);
			$finish;
		end
	endcase

	case (DUALCORESLAVE)
		"FALSE" : DUALCORESLAVE_BINARY = 1'b0;
		"TRUE" : DUALCORESLAVE_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute DUALCORESLAVE on PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", DUALCORESLAVE);
			$finish;
		end
	endcase

	case (DUALCOREENABLE)
		"FALSE" : DUALCOREENABLE_BINARY = 1'b0;
		"TRUE" : DUALCOREENABLE_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute DUALCOREENABLE on PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", DUALCOREENABLE);
			$finish;
		end
	endcase

	case (DUALROLECFGCNTRLROOTEPN)
		0 : DUALROLECFGCNTRLROOTEPN_BINARY = 1'b0;
		1 : DUALROLECFGCNTRLROOTEPN_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute DUALROLECFGCNTRLROOTEPN on PCIE_INTERNAL_1_1 instance %m is set to %d.  Legal values for this attribute are 0 to 1.", DUALROLECFGCNTRLROOTEPN);
			$finish;
		end
	endcase

	case (RXREADADDRPIPE)
		"FALSE" : RXREADADDRPIPE_BINARY = 1'b0;
		"TRUE" : RXREADADDRPIPE_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute RXREADADDRPIPE on PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", RXREADADDRPIPE);
			$finish;
		end
	endcase

	case (RXREADDATAPIPE)
		"FALSE" : RXREADDATAPIPE_BINARY = 1'b0;
		"TRUE" : RXREADDATAPIPE_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute RXREADDATAPIPE on PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", RXREADDATAPIPE);
			$finish;
		end
	endcase

	case (TXWRITEPIPE)
		"FALSE" : TXWRITEPIPE_BINARY = 1'b0;
		"TRUE" : TXWRITEPIPE_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute TXWRITEPIPE on PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", TXWRITEPIPE);
			$finish;
		end
	endcase

	case (TXREADADDRPIPE)
		"FALSE" : TXREADADDRPIPE_BINARY = 1'b0;
		"TRUE" : TXREADADDRPIPE_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute TXREADADDRPIPE on PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", TXREADADDRPIPE);
			$finish;
		end
	endcase

	case (TXREADDATAPIPE)
		"FALSE" : TXREADDATAPIPE_BINARY = 1'b0;
		"TRUE" : TXREADDATAPIPE_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute TXREADDATAPIPE on PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", TXREADDATAPIPE);
			$finish;
		end
	endcase

	case (RXWRITEPIPE)
		"FALSE" : RXWRITEPIPE_BINARY = 1'b0;
		"TRUE" : RXWRITEPIPE_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute RXWRITEPIPE on PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", RXWRITEPIPE);
			$finish;
		end
	endcase

	case (LLKBYPASS)
		"FALSE" : LLKBYPASS_BINARY = 1'b0;
		"TRUE" : LLKBYPASS_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute LLKBYPASS on PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", LLKBYPASS);
			$finish;
		end
	endcase

	case (PCIEREVISION)
		0 : PCIEREVISION_BINARY = 1'b0;
		1 : PCIEREVISION_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute PCIEREVISION on PCIE_INTERNAL_1_1 instance %m is set to %d.  Legal values for this attribute are 0 to 1.", PCIEREVISION);
			$finish;
		end
	endcase

	case (SELECTDLLIF)
		"FALSE" : SELECTDLLIF_BINARY = 1'b0;
		"TRUE" : SELECTDLLIF_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute SELECTDLLIF on PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", SELECTDLLIF);
			$finish;
		end
	endcase

	case (SELECTASMODE)
		"FALSE" : SELECTASMODE_BINARY = 1'b0;
		"TRUE" : SELECTASMODE_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute SELECTASMODE on PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", SELECTASMODE);
			$finish;
		end
	endcase

	case (ISSWITCH)
		"FALSE" : ISSWITCH_BINARY = 1'b0;
		"TRUE" : ISSWITCH_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute ISSWITCH on PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", ISSWITCH);
			$finish;
		end
	endcase

	case (UPSTREAMFACING)
		"FALSE" : UPSTREAMFACING_BINARY = 1'b0;
		"TRUE" : UPSTREAMFACING_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute UPSTREAMFACING on PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", UPSTREAMFACING);
			$finish;
		end
	endcase

	case (SLOTIMPLEMENTED)
		"FALSE" : SLOTIMPLEMENTED_BINARY = 1'b0;
		"TRUE" : SLOTIMPLEMENTED_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute SLOTIMPLEMENTED on PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", SLOTIMPLEMENTED);
			$finish;
		end
	endcase

	case (BAR0EXIST)
		"FALSE" : BAR0EXIST_BINARY = 1'b0;
		"TRUE" : BAR0EXIST_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute BAR0EXIST on PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", BAR0EXIST);
			$finish;
		end
	endcase

	case (BAR1EXIST)
		"FALSE" : BAR1EXIST_BINARY = 1'b0;
		"TRUE" : BAR1EXIST_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute BAR1EXIST on PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", BAR1EXIST);
			$finish;
		end
	endcase

	case (BAR2EXIST)
		"FALSE" : BAR2EXIST_BINARY = 1'b0;
		"TRUE" : BAR2EXIST_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute BAR2EXIST on PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", BAR2EXIST);
			$finish;
		end
	endcase

	case (BAR3EXIST)
		"FALSE" : BAR3EXIST_BINARY = 1'b0;
		"TRUE" : BAR3EXIST_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute BAR3EXIST on PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", BAR3EXIST);
			$finish;
		end
	endcase

	case (BAR4EXIST)
		"FALSE" : BAR4EXIST_BINARY = 1'b0;
		"TRUE" : BAR4EXIST_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute BAR4EXIST on PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", BAR4EXIST);
			$finish;
		end
	endcase

	case (BAR5EXIST)
		"FALSE" : BAR5EXIST_BINARY = 1'b0;
		"TRUE" : BAR5EXIST_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute BAR5EXIST on PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", BAR5EXIST);
			$finish;
		end
	endcase

	case (BAR0ADDRWIDTH)
		0 : BAR0ADDRWIDTH_BINARY = 1'b0;
		1 : BAR0ADDRWIDTH_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute BAR0ADDRWIDTH on PCIE_INTERNAL_1_1 instance %m is set to %d.  Legal values for this attribute are 0 to 1.", BAR0ADDRWIDTH);
			$finish;
		end
	endcase

	case (BAR1ADDRWIDTH)
		0 : BAR1ADDRWIDTH_BINARY = 1'b0;
		1 : BAR1ADDRWIDTH_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute BAR1ADDRWIDTH on PCIE_INTERNAL_1_1 instance %m is set to %d.  Legal values for this attribute are 0 to 1.", BAR1ADDRWIDTH);
			$finish;
		end
	endcase

	case (BAR2ADDRWIDTH)
		0 : BAR2ADDRWIDTH_BINARY = 1'b0;
		1 : BAR2ADDRWIDTH_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute BAR2ADDRWIDTH on PCIE_INTERNAL_1_1 instance %m is set to %d.  Legal values for this attribute are 0 to 1.", BAR2ADDRWIDTH);
			$finish;
		end
	endcase

	case (BAR3ADDRWIDTH)
		0 : BAR3ADDRWIDTH_BINARY = 1'b0;
		1 : BAR3ADDRWIDTH_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute BAR3ADDRWIDTH on PCIE_INTERNAL_1_1 instance %m is set to %d.  Legal values for this attribute are 0 to 1.", BAR3ADDRWIDTH);
			$finish;
		end
	endcase

	case (BAR4ADDRWIDTH)
		0 : BAR4ADDRWIDTH_BINARY = 1'b0;
		1 : BAR4ADDRWIDTH_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute BAR4ADDRWIDTH on PCIE_INTERNAL_1_1 instance %m is set to %d.  Legal values for this attribute are 0 to 1.", BAR4ADDRWIDTH);
			$finish;
		end
	endcase

	case (BAR0PREFETCHABLE)
		"FALSE" : BAR0PREFETCHABLE_BINARY = 1'b0;
		"TRUE" : BAR0PREFETCHABLE_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute BAR0PREFETCHABLE on PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", BAR0PREFETCHABLE);
			$finish;
		end
	endcase

	case (BAR1PREFETCHABLE)
		"FALSE" : BAR1PREFETCHABLE_BINARY = 1'b0;
		"TRUE" : BAR1PREFETCHABLE_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute BAR1PREFETCHABLE on PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", BAR1PREFETCHABLE);
			$finish;
		end
	endcase

	case (BAR2PREFETCHABLE)
		"FALSE" : BAR2PREFETCHABLE_BINARY = 1'b0;
		"TRUE" : BAR2PREFETCHABLE_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute BAR2PREFETCHABLE on PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", BAR2PREFETCHABLE);
			$finish;
		end
	endcase

	case (BAR3PREFETCHABLE)
		"FALSE" : BAR3PREFETCHABLE_BINARY = 1'b0;
		"TRUE" : BAR3PREFETCHABLE_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute BAR3PREFETCHABLE on PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", BAR3PREFETCHABLE);
			$finish;
		end
	endcase

	case (BAR4PREFETCHABLE)
		"FALSE" : BAR4PREFETCHABLE_BINARY = 1'b0;
		"TRUE" : BAR4PREFETCHABLE_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute BAR4PREFETCHABLE on PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", BAR4PREFETCHABLE);
			$finish;
		end
	endcase

	case (BAR5PREFETCHABLE)
		"FALSE" : BAR5PREFETCHABLE_BINARY = 1'b0;
		"TRUE" : BAR5PREFETCHABLE_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute BAR5PREFETCHABLE on PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", BAR5PREFETCHABLE);
			$finish;
		end
	endcase

	case (BAR0IOMEMN)
		0 : BAR0IOMEMN_BINARY = 1'b0;
		1 : BAR0IOMEMN_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute BAR0IOMEMN on PCIE_INTERNAL_1_1 instance %m is set to %d.  Legal values for this attribute are 0 to 1.", BAR0IOMEMN);
			$finish;
		end
	endcase

	case (BAR1IOMEMN)
		0 : BAR1IOMEMN_BINARY = 1'b0;
		1 : BAR1IOMEMN_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute BAR1IOMEMN on PCIE_INTERNAL_1_1 instance %m is set to %d.  Legal values for this attribute are 0 to 1.", BAR1IOMEMN);
			$finish;
		end
	endcase

	case (BAR2IOMEMN)
		0 : BAR2IOMEMN_BINARY = 1'b0;
		1 : BAR2IOMEMN_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute BAR2IOMEMN on PCIE_INTERNAL_1_1 instance %m is set to %d.  Legal values for this attribute are 0 to 1.", BAR2IOMEMN);
			$finish;
		end
	endcase

	case (BAR3IOMEMN)
		0 : BAR3IOMEMN_BINARY = 1'b0;
		1 : BAR3IOMEMN_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute BAR3IOMEMN on PCIE_INTERNAL_1_1 instance %m is set to %d.  Legal values for this attribute are 0 to 1.", BAR3IOMEMN);
			$finish;
		end
	endcase

	case (BAR4IOMEMN)
		0 : BAR4IOMEMN_BINARY = 1'b0;
		1 : BAR4IOMEMN_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute BAR4IOMEMN on PCIE_INTERNAL_1_1 instance %m is set to %d.  Legal values for this attribute are 0 to 1.", BAR4IOMEMN);
			$finish;
		end
	endcase

	case (BAR5IOMEMN)
		0 : BAR5IOMEMN_BINARY = 1'b0;
		1 : BAR5IOMEMN_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute BAR5IOMEMN on PCIE_INTERNAL_1_1 instance %m is set to %d.  Legal values for this attribute are 0 to 1.", BAR5IOMEMN);
			$finish;
		end
	endcase

	case (XPMAXPAYLOAD)
		0 : XPMAXPAYLOAD_BINARY = 3'b000;
		1 : XPMAXPAYLOAD_BINARY = 3'b001;
		2 : XPMAXPAYLOAD_BINARY = 3'b010;
		3 : XPMAXPAYLOAD_BINARY = 3'b011;
		4 : XPMAXPAYLOAD_BINARY = 3'b100;
		5 : XPMAXPAYLOAD_BINARY = 3'b101;
		6 : XPMAXPAYLOAD_BINARY = 3'b110;
		7 : XPMAXPAYLOAD_BINARY = 3'b111;
		default : begin
			$display("Attribute Syntax Error : The Attribute XPMAXPAYLOAD on PCIE_INTERNAL_1_1 instance %m is set to %d.  Legal values for this attribute are 0 to 7.", XPMAXPAYLOAD);
			$finish;
		end
	endcase

	case (XPRCBCONTROL)
		0 : XPRCBCONTROL_BINARY = 1'b0;
		1 : XPRCBCONTROL_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute XPRCBCONTROL on PCIE_INTERNAL_1_1 instance %m is set to %d.  Legal values for this attribute are 0 to 1.", XPRCBCONTROL);
			$finish;
		end
	endcase

	case (LOWPRIORITYVCCOUNT)
		0 : LOWPRIORITYVCCOUNT_BINARY = 3'b000;
		1 : LOWPRIORITYVCCOUNT_BINARY = 3'b001;
		2 : LOWPRIORITYVCCOUNT_BINARY = 3'b010;
		3 : LOWPRIORITYVCCOUNT_BINARY = 3'b011;
		4 : LOWPRIORITYVCCOUNT_BINARY = 3'b100;
		5 : LOWPRIORITYVCCOUNT_BINARY = 3'b101;
		6 : LOWPRIORITYVCCOUNT_BINARY = 3'b110;
		7 : LOWPRIORITYVCCOUNT_BINARY = 3'b111;
		default : begin
			$display("Attribute Syntax Error : The Attribute LOWPRIORITYVCCOUNT on PCIE_INTERNAL_1_1 instance %m is set to %d.  Legal values for this attribute are 0 to 7.", LOWPRIORITYVCCOUNT);
			$finish;
		end
	endcase

	case (PMCAPABILITYDSI)
		"FALSE" : PMCAPABILITYDSI_BINARY = 1'b0;
		"TRUE" : PMCAPABILITYDSI_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute PMCAPABILITYDSI on PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", PMCAPABILITYDSI);
			$finish;
		end
	endcase

	case (PMCAPABILITYD1SUPPORT)
		"FALSE" : PMCAPABILITYD1SUPPORT_BINARY = 1'b0;
		"TRUE" : PMCAPABILITYD1SUPPORT_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute PMCAPABILITYD1SUPPORT on PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", PMCAPABILITYD1SUPPORT);
			$finish;
		end
	endcase

	case (PMCAPABILITYD2SUPPORT)
		"FALSE" : PMCAPABILITYD2SUPPORT_BINARY = 1'b0;
		"TRUE" : PMCAPABILITYD2SUPPORT_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute PMCAPABILITYD2SUPPORT on PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", PMCAPABILITYD2SUPPORT);
			$finish;
		end
	endcase

	case (PMDATASCALE0)
		0 : PMDATASCALE0_BINARY = 2'b00;
		1 : PMDATASCALE0_BINARY = 2'b01;
		2 : PMDATASCALE0_BINARY = 2'b10;
		3 : PMDATASCALE0_BINARY = 2'b11;
		default : begin
			$display("Attribute Syntax Error : The Attribute PMDATASCALE0 on PCIE_INTERNAL_1_1 instance %m is set to %d.  Legal values for this attribute are 0 to 3.", PMDATASCALE0);
			$finish;
		end
	endcase

	case (PMDATASCALE1)
		0 : PMDATASCALE1_BINARY = 2'b00;
		1 : PMDATASCALE1_BINARY = 2'b01;
		2 : PMDATASCALE1_BINARY = 2'b10;
		3 : PMDATASCALE1_BINARY = 2'b11;
		default : begin
			$display("Attribute Syntax Error : The Attribute PMDATASCALE1 on PCIE_INTERNAL_1_1 instance %m is set to %d.  Legal values for this attribute are 0 to 3.", PMDATASCALE1);
			$finish;
		end
	endcase

	case (PMDATASCALE2)
		0 : PMDATASCALE2_BINARY = 2'b00;
		1 : PMDATASCALE2_BINARY = 2'b01;
		2 : PMDATASCALE2_BINARY = 2'b10;
		3 : PMDATASCALE2_BINARY = 2'b11;
		default : begin
			$display("Attribute Syntax Error : The Attribute PMDATASCALE2 on PCIE_INTERNAL_1_1 instance %m is set to %d.  Legal values for this attribute are 0 to 3.", PMDATASCALE2);
			$finish;
		end
	endcase

	case (PMDATASCALE3)
		0 : PMDATASCALE3_BINARY = 2'b00;
		1 : PMDATASCALE3_BINARY = 2'b01;
		2 : PMDATASCALE3_BINARY = 2'b10;
		3 : PMDATASCALE3_BINARY = 2'b11;
		default : begin
			$display("Attribute Syntax Error : The Attribute PMDATASCALE3 on PCIE_INTERNAL_1_1 instance %m is set to %d.  Legal values for this attribute are 0 to 3.", PMDATASCALE3);
			$finish;
		end
	endcase

	case (PMDATASCALE4)
		0 : PMDATASCALE4_BINARY = 2'b00;
		1 : PMDATASCALE4_BINARY = 2'b01;
		2 : PMDATASCALE4_BINARY = 2'b10;
		3 : PMDATASCALE4_BINARY = 2'b11;
		default : begin
			$display("Attribute Syntax Error : The Attribute PMDATASCALE4 on PCIE_INTERNAL_1_1 instance %m is set to %d.  Legal values for this attribute are 0 to 3.", PMDATASCALE4);
			$finish;
		end
	endcase

	case (PMDATASCALE5)
		0 : PMDATASCALE5_BINARY = 2'b00;
		1 : PMDATASCALE5_BINARY = 2'b01;
		2 : PMDATASCALE5_BINARY = 2'b10;
		3 : PMDATASCALE5_BINARY = 2'b11;
		default : begin
			$display("Attribute Syntax Error : The Attribute PMDATASCALE5 on PCIE_INTERNAL_1_1 instance %m is set to %d.  Legal values for this attribute are 0 to 3.", PMDATASCALE5);
			$finish;
		end
	endcase

	case (PMDATASCALE6)
		0 : PMDATASCALE6_BINARY = 2'b00;
		1 : PMDATASCALE6_BINARY = 2'b01;
		2 : PMDATASCALE6_BINARY = 2'b10;
		3 : PMDATASCALE6_BINARY = 2'b11;
		default : begin
			$display("Attribute Syntax Error : The Attribute PMDATASCALE6 on PCIE_INTERNAL_1_1 instance %m is set to %d.  Legal values for this attribute are 0 to 3.", PMDATASCALE6);
			$finish;
		end
	endcase

	case (PMDATASCALE7)
		0 : PMDATASCALE7_BINARY = 2'b00;
		1 : PMDATASCALE7_BINARY = 2'b01;
		2 : PMDATASCALE7_BINARY = 2'b10;
		3 : PMDATASCALE7_BINARY = 2'b11;
		default : begin
			$display("Attribute Syntax Error : The Attribute PMDATASCALE7 on PCIE_INTERNAL_1_1 instance %m is set to %d.  Legal values for this attribute are 0 to 3.", PMDATASCALE7);
			$finish;
		end
	endcase

	case (PMDATASCALE8)
		0 : PMDATASCALE8_BINARY = 2'b00;
		1 : PMDATASCALE8_BINARY = 2'b01;
		2 : PMDATASCALE8_BINARY = 2'b10;
		3 : PMDATASCALE8_BINARY = 2'b11;
		default : begin
			$display("Attribute Syntax Error : The Attribute PMDATASCALE8 on PCIE_INTERNAL_1_1 instance %m is set to %d.  Legal values for this attribute are 0 to 3.", PMDATASCALE8);
			$finish;
		end
	endcase

	case (PCIECAPABILITYSLOTIMPL)
		"FALSE" : PCIECAPABILITYSLOTIMPL_BINARY = 1'b0;
		"TRUE" : PCIECAPABILITYSLOTIMPL_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute PCIECAPABILITYSLOTIMPL on PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", PCIECAPABILITYSLOTIMPL);
			$finish;
		end
	endcase

	case (LINKSTATUSSLOTCLOCKCONFIG)
		"FALSE" : LINKSTATUSSLOTCLOCKCONFIG_BINARY = 1'b0;
		"TRUE" : LINKSTATUSSLOTCLOCKCONFIG_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute LINKSTATUSSLOTCLOCKCONFIG on PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", LINKSTATUSSLOTCLOCKCONFIG);
			$finish;
		end
	endcase

	case (SLOTCAPABILITYATTBUTTONPRESENT)
		"FALSE" : SLOTCAPABILITYATTBUTTONPRESENT_BINARY = 1'b0;
		"TRUE" : SLOTCAPABILITYATTBUTTONPRESENT_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute SLOTCAPABILITYATTBUTTONPRESENT on PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", SLOTCAPABILITYATTBUTTONPRESENT);
			$finish;
		end
	endcase

	case (SLOTCAPABILITYPOWERCONTROLLERPRESENT)
		"FALSE" : SLOTCAPABILITYPOWERCONTROLLERPRESENT_BINARY = 1'b0;
		"TRUE" : SLOTCAPABILITYPOWERCONTROLLERPRESENT_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute SLOTCAPABILITYPOWERCONTROLLERPRESENT on PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", SLOTCAPABILITYPOWERCONTROLLERPRESENT);
			$finish;
		end
	endcase

	case (SLOTCAPABILITYMSLSENSORPRESENT)
		"FALSE" : SLOTCAPABILITYMSLSENSORPRESENT_BINARY = 1'b0;
		"TRUE" : SLOTCAPABILITYMSLSENSORPRESENT_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute SLOTCAPABILITYMSLSENSORPRESENT on PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", SLOTCAPABILITYMSLSENSORPRESENT);
			$finish;
		end
	endcase

	case (SLOTCAPABILITYATTINDICATORPRESENT)
		"FALSE" : SLOTCAPABILITYATTINDICATORPRESENT_BINARY = 1'b0;
		"TRUE" : SLOTCAPABILITYATTINDICATORPRESENT_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute SLOTCAPABILITYATTINDICATORPRESENT on PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", SLOTCAPABILITYATTINDICATORPRESENT);
			$finish;
		end
	endcase

	case (SLOTCAPABILITYPOWERINDICATORPRESENT)
		"FALSE" : SLOTCAPABILITYPOWERINDICATORPRESENT_BINARY = 1'b0;
		"TRUE" : SLOTCAPABILITYPOWERINDICATORPRESENT_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute SLOTCAPABILITYPOWERINDICATORPRESENT on PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", SLOTCAPABILITYPOWERINDICATORPRESENT);
			$finish;
		end
	endcase

	case (SLOTCAPABILITYHOTPLUGSURPRISE)
		"FALSE" : SLOTCAPABILITYHOTPLUGSURPRISE_BINARY = 1'b0;
		"TRUE" : SLOTCAPABILITYHOTPLUGSURPRISE_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute SLOTCAPABILITYHOTPLUGSURPRISE on PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", SLOTCAPABILITYHOTPLUGSURPRISE);
			$finish;
		end
	endcase

	case (SLOTCAPABILITYHOTPLUGCAPABLE)
		"FALSE" : SLOTCAPABILITYHOTPLUGCAPABLE_BINARY = 1'b0;
		"TRUE" : SLOTCAPABILITYHOTPLUGCAPABLE_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute SLOTCAPABILITYHOTPLUGCAPABLE on PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", SLOTCAPABILITYHOTPLUGCAPABLE);
			$finish;
		end
	endcase

	case (AERCAPABILITYECRCGENCAPABLE)
		"FALSE" : AERCAPABILITYECRCGENCAPABLE_BINARY = 1'b0;
		"TRUE" : AERCAPABILITYECRCGENCAPABLE_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute AERCAPABILITYECRCGENCAPABLE on PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", AERCAPABILITYECRCGENCAPABLE);
			$finish;
		end
	endcase

	case (AERCAPABILITYECRCCHECKCAPABLE)
		"FALSE" : AERCAPABILITYECRCCHECKCAPABLE_BINARY = 1'b0;
		"TRUE" : AERCAPABILITYECRCCHECKCAPABLE_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute AERCAPABILITYECRCCHECKCAPABLE on PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", AERCAPABILITYECRCCHECKCAPABLE);
			$finish;
		end
	endcase

	case (PBCAPABILITYSYSTEMALLOCATED)
		"FALSE" : PBCAPABILITYSYSTEMALLOCATED_BINARY = 1'b0;
		"TRUE" : PBCAPABILITYSYSTEMALLOCATED_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute PBCAPABILITYSYSTEMALLOCATED on PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", PBCAPABILITYSYSTEMALLOCATED);
			$finish;
		end
	endcase

	case (RESETMODE)
		"FALSE" : RESETMODE_BINARY = 1'b0;
		"TRUE" : RESETMODE_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute RESETMODE on PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", RESETMODE);
			$finish;
		end
	endcase

	case (CLKDIVIDED)
		"FALSE" : CLKDIVIDED_BINARY = 1'b0;
		"TRUE" : CLKDIVIDED_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute CLKDIVIDED on PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", CLKDIVIDED);
			$finish;
		end
	endcase

end

wire BUSMASTERENABLE_delay;
wire CRMDOHOTRESETN_delay;
wire CRMPWRSOFTRESETN_delay;
wire CRMRXHOTRESETN_delay;
wire DLLTXPMDLLPOUTSTANDING_delay;
wire INTERRUPTDISABLE_delay;
wire IOSPACEENABLE_delay;
wire L0ASAUTONOMOUSINITCOMPLETED_delay;
wire L0CFGLOOPBACKACK_delay;
wire L0CORRERRMSGRCVD_delay;
wire L0DLLASTXSTATE_delay;
wire L0DLLRXACKOUTSTANDING_delay;
wire L0DLLTXNONFCOUTSTANDING_delay;
wire L0DLLTXOUTSTANDING_delay;
wire L0FATALERRMSGRCVD_delay;
wire L0FIRSTCFGWRITEOCCURRED_delay;
wire L0FWDCORRERROUT_delay;
wire L0FWDFATALERROUT_delay;
wire L0FWDNONFATALERROUT_delay;
wire L0MACENTEREDL0_delay;
wire L0MACLINKTRAINING_delay;
wire L0MACLINKUP_delay;
wire L0MACNEWSTATEACK_delay;
wire L0MACRXL0SSTATE_delay;
wire L0MACUPSTREAMDOWNSTREAM_delay;
wire L0MSIENABLE0_delay;
wire L0NONFATALERRMSGRCVD_delay;
wire L0PMEACK_delay;
wire L0PMEEN_delay;
wire L0PMEREQOUT_delay;
wire L0POWERCONTROLLERCONTROL_delay;
wire L0PWRINHIBITTRANSFERS_delay;
wire L0PWRL1STATE_delay;
wire L0PWRL23READYDEVICE_delay;
wire L0PWRL23READYSTATE_delay;
wire L0PWRTURNOFFREQ_delay;
wire L0PWRTXL0SSTATE_delay;
wire L0RECEIVEDASSERTINTALEGACYINT_delay;
wire L0RECEIVEDASSERTINTBLEGACYINT_delay;
wire L0RECEIVEDASSERTINTCLEGACYINT_delay;
wire L0RECEIVEDASSERTINTDLEGACYINT_delay;
wire L0RECEIVEDDEASSERTINTALEGACYINT_delay;
wire L0RECEIVEDDEASSERTINTBLEGACYINT_delay;
wire L0RECEIVEDDEASSERTINTCLEGACYINT_delay;
wire L0RECEIVEDDEASSERTINTDLEGACYINT_delay;
wire L0RXBEACON_delay;
wire L0RXDLLPM_delay;
wire L0RXDLLSBFCUPDATE_delay;
wire L0RXDLLTLPECRCOK_delay;
wire L0STATSCFGOTHERRECEIVED_delay;
wire L0STATSCFGOTHERTRANSMITTED_delay;
wire L0STATSCFGRECEIVED_delay;
wire L0STATSCFGTRANSMITTED_delay;
wire L0STATSDLLPRECEIVED_delay;
wire L0STATSDLLPTRANSMITTED_delay;
wire L0STATSOSRECEIVED_delay;
wire L0STATSOSTRANSMITTED_delay;
wire L0STATSTLPRECEIVED_delay;
wire L0STATSTLPTRANSMITTED_delay;
wire L0TOGGLEELECTROMECHANICALINTERLOCK_delay;
wire L0TXDLLPMUPDATED_delay;
wire L0TXDLLSBFCUPDATED_delay;
wire L0UNLOCKRECEIVED_delay;
wire LLKRX4DWHEADERN_delay;
wire LLKRXCHCONFIGAVAILABLEN_delay;
wire LLKRXCHCONFIGPARTIALN_delay;
wire LLKRXECRCBADN_delay;
wire LLKRXEOFN_delay;
wire LLKRXEOPN_delay;
wire LLKRXSOFN_delay;
wire LLKRXSOPN_delay;
wire LLKRXSRCDSCN_delay;
wire LLKRXSRCLASTREQN_delay;
wire LLKRXSRCRDYN_delay;
wire LLKTXCONFIGREADYN_delay;
wire LLKTXDSTRDYN_delay;
wire MEMSPACEENABLE_delay;
wire MIMDLLBREN_delay;
wire MIMDLLBWEN_delay;
wire MIMRXBREN_delay;
wire MIMRXBWEN_delay;
wire MIMTXBREN_delay;
wire MIMTXBWEN_delay;
wire PARITYERRORRESPONSE_delay;
wire PIPEDESKEWLANESL0_delay;
wire PIPEDESKEWLANESL1_delay;
wire PIPEDESKEWLANESL2_delay;
wire PIPEDESKEWLANESL3_delay;
wire PIPEDESKEWLANESL4_delay;
wire PIPEDESKEWLANESL5_delay;
wire PIPEDESKEWLANESL6_delay;
wire PIPEDESKEWLANESL7_delay;
wire PIPERESETL0_delay;
wire PIPERESETL1_delay;
wire PIPERESETL2_delay;
wire PIPERESETL3_delay;
wire PIPERESETL4_delay;
wire PIPERESETL5_delay;
wire PIPERESETL6_delay;
wire PIPERESETL7_delay;
wire PIPERXPOLARITYL0_delay;
wire PIPERXPOLARITYL1_delay;
wire PIPERXPOLARITYL2_delay;
wire PIPERXPOLARITYL3_delay;
wire PIPERXPOLARITYL4_delay;
wire PIPERXPOLARITYL5_delay;
wire PIPERXPOLARITYL6_delay;
wire PIPERXPOLARITYL7_delay;
wire PIPETXCOMPLIANCEL0_delay;
wire PIPETXCOMPLIANCEL1_delay;
wire PIPETXCOMPLIANCEL2_delay;
wire PIPETXCOMPLIANCEL3_delay;
wire PIPETXCOMPLIANCEL4_delay;
wire PIPETXCOMPLIANCEL5_delay;
wire PIPETXCOMPLIANCEL6_delay;
wire PIPETXCOMPLIANCEL7_delay;
wire PIPETXDATAKL0_delay;
wire PIPETXDATAKL1_delay;
wire PIPETXDATAKL2_delay;
wire PIPETXDATAKL3_delay;
wire PIPETXDATAKL4_delay;
wire PIPETXDATAKL5_delay;
wire PIPETXDATAKL6_delay;
wire PIPETXDATAKL7_delay;
wire PIPETXDETECTRXLOOPBACKL0_delay;
wire PIPETXDETECTRXLOOPBACKL1_delay;
wire PIPETXDETECTRXLOOPBACKL2_delay;
wire PIPETXDETECTRXLOOPBACKL3_delay;
wire PIPETXDETECTRXLOOPBACKL4_delay;
wire PIPETXDETECTRXLOOPBACKL5_delay;
wire PIPETXDETECTRXLOOPBACKL6_delay;
wire PIPETXDETECTRXLOOPBACKL7_delay;
wire PIPETXELECIDLEL0_delay;
wire PIPETXELECIDLEL1_delay;
wire PIPETXELECIDLEL2_delay;
wire PIPETXELECIDLEL3_delay;
wire PIPETXELECIDLEL4_delay;
wire PIPETXELECIDLEL5_delay;
wire PIPETXELECIDLEL6_delay;
wire PIPETXELECIDLEL7_delay;
wire SERRENABLE_delay;
wire URREPORTINGENABLE_delay;
wire [11:0] MGMTSTATSCREDIT_delay;
wire [11:0] MIMDLLBRADD_delay;
wire [11:0] MIMDLLBWADD_delay;
wire [12:0] L0COMPLETERID_delay;
wire [12:0] MIMRXBRADD_delay;
wire [12:0] MIMRXBWADD_delay;
wire [12:0] MIMTXBRADD_delay;
wire [12:0] MIMTXBWADD_delay;
wire [15:0] L0ERRMSGREQID_delay;
wire [15:0] LLKRXPREFERREDTYPE_delay;
wire [16:0] MGMTPSO_delay;
wire [18:0] L0RXDLLSBFCDATA_delay;
wire [19:0] L0RXDLLFCNPOSTBYPCRED_delay;
wire [1:0] L0ATTENTIONINDICATORCONTROL_delay;
wire [1:0] L0DLLASRXSTATE_delay;
wire [1:0] L0POWERINDICATORCONTROL_delay;
wire [1:0] L0PWRSTATE0_delay;
wire [1:0] L0RXDLLTLPEND_delay;
wire [1:0] L0RXMACLINKERROR_delay;
wire [1:0] LLKRXVALIDN_delay;
wire [1:0] PIPEPOWERDOWNL0_delay;
wire [1:0] PIPEPOWERDOWNL1_delay;
wire [1:0] PIPEPOWERDOWNL2_delay;
wire [1:0] PIPEPOWERDOWNL3_delay;
wire [1:0] PIPEPOWERDOWNL4_delay;
wire [1:0] PIPEPOWERDOWNL5_delay;
wire [1:0] PIPEPOWERDOWNL6_delay;
wire [1:0] PIPEPOWERDOWNL7_delay;
wire [23:0] L0RXDLLFCCMPLMCCRED_delay;
wire [23:0] L0RXDLLFCPOSTORDCRED_delay;
wire [2:0] L0MCFOUND_delay;
wire [2:0] L0MULTIMSGEN0_delay;
wire [2:0] L0RXDLLPMTYPE_delay;
wire [2:0] L0TRANSFORMEDVC_delay;
wire [2:0] MAXPAYLOADSIZE_delay;
wire [2:0] MAXREADREQUESTSIZE_delay;
wire [31:0] MGMTRDATA_delay;
wire [3:0] L0LTSSMSTATE_delay;
wire [3:0] L0MACNEGOTIATEDLINKWIDTH_delay;
wire [3:0] L0UCBYPFOUND_delay;
wire [3:0] L0UCORDFOUND_delay;
wire [63:0] LLKRXDATA_delay;
wire [63:0] MIMDLLBWDATA_delay;
wire [63:0] MIMRXBWDATA_delay;
wire [63:0] MIMTXBWDATA_delay;
wire [6:0] L0DLLERRORVECTOR_delay;
wire [7:0] L0DLLVCSTATUS_delay;
wire [7:0] L0DLUPDOWN_delay;
wire [7:0] L0RXDLLFCCMPLMCUPDATE_delay;
wire [7:0] L0RXDLLFCNPOSTBYPUPDATE_delay;
wire [7:0] L0RXDLLFCPOSTORDUPDATE_delay;
wire [7:0] L0TXDLLFCCMPLMCUPDATED_delay;
wire [7:0] L0TXDLLFCNPOSTBYPUPDATED_delay;
wire [7:0] L0TXDLLFCPOSTORDUPDATED_delay;
wire [7:0] LLKRXCHCOMPLETIONAVAILABLEN_delay;
wire [7:0] LLKRXCHCOMPLETIONPARTIALN_delay;
wire [7:0] LLKRXCHNONPOSTEDAVAILABLEN_delay;
wire [7:0] LLKRXCHNONPOSTEDPARTIALN_delay;
wire [7:0] LLKRXCHPOSTEDAVAILABLEN_delay;
wire [7:0] LLKRXCHPOSTEDPARTIALN_delay;
wire [7:0] LLKTCSTATUS_delay;
wire [7:0] LLKTXCHCOMPLETIONREADYN_delay;
wire [7:0] LLKTXCHNONPOSTEDREADYN_delay;
wire [7:0] LLKTXCHPOSTEDREADYN_delay;
wire [7:0] PIPETXDATAL0_delay;
wire [7:0] PIPETXDATAL1_delay;
wire [7:0] PIPETXDATAL2_delay;
wire [7:0] PIPETXDATAL3_delay;
wire [7:0] PIPETXDATAL4_delay;
wire [7:0] PIPETXDATAL5_delay;
wire [7:0] PIPETXDATAL6_delay;
wire [7:0] PIPETXDATAL7_delay;
wire [9:0] LLKTXCHANSPACE_delay;

wire AUXPOWER_delay;
wire COMPLIANCEAVOID_delay;
wire CRMCFGBRIDGEHOTRESET_delay;
wire CRMCORECLKDLO_delay;
wire CRMCORECLKRXO_delay;
wire CRMCORECLKTXO_delay;
wire CRMCORECLK_delay;
wire CRMLINKRSTN_delay;
wire CRMMACRSTN_delay;
wire CRMMGMTRSTN_delay;
wire CRMNVRSTN_delay;
wire CRMTXHOTRESETN_delay;
wire CRMURSTN_delay;
wire CRMUSERCFGRSTN_delay;
wire CRMUSERCLKRXO_delay;
wire CRMUSERCLKTXO_delay;
wire CRMUSERCLK_delay;
wire CROSSLINKSEED_delay;
wire L0ALLDOWNPORTSINL1_delay;
wire L0ALLDOWNRXPORTSINL0S_delay;
wire L0ASE_delay;
wire L0ATTENTIONBUTTONPRESSED_delay;
wire L0CFGASSPANTREEOWNEDSTATE_delay;
wire L0CFGDISABLESCRAMBLE_delay;
wire L0CFGEXTENDEDSYNC_delay;
wire L0CFGL0SENTRYENABLE_delay;
wire L0CFGL0SENTRYSUP_delay;
wire L0CFGLINKDISABLE_delay;
wire L0CFGLOOPBACKMASTER_delay;
wire L0DLLHOLDLINKUP_delay;
wire L0ELECTROMECHANICALINTERLOCKENGAGED_delay;
wire L0FWDASSERTINTALEGACYINT_delay;
wire L0FWDASSERTINTBLEGACYINT_delay;
wire L0FWDASSERTINTCLEGACYINT_delay;
wire L0FWDASSERTINTDLEGACYINT_delay;
wire L0FWDCORRERRIN_delay;
wire L0FWDDEASSERTINTALEGACYINT_delay;
wire L0FWDDEASSERTINTBLEGACYINT_delay;
wire L0FWDDEASSERTINTCLEGACYINT_delay;
wire L0FWDDEASSERTINTDLEGACYINT_delay;
wire L0FWDFATALERRIN_delay;
wire L0FWDNONFATALERRIN_delay;
wire L0LEGACYINTFUNCT0_delay;
wire L0MRLSENSORCLOSEDN_delay;
wire L0PMEREQIN_delay;
wire L0POWERFAULTDETECTED_delay;
wire L0PRESENCEDETECTSLOTEMPTYN_delay;
wire L0PWRNEWSTATEREQ_delay;
wire L0ROOTTURNOFFREQ_delay;
wire L0SENDUNLOCKMESSAGE_delay;
wire L0SETCOMPLETERABORTERROR_delay;
wire L0SETCOMPLETIONTIMEOUTCORRERROR_delay;
wire L0SETCOMPLETIONTIMEOUTUNCORRERROR_delay;
wire L0SETDETECTEDCORRERROR_delay;
wire L0SETDETECTEDFATALERROR_delay;
wire L0SETDETECTEDNONFATALERROR_delay;
wire L0SETLINKDETECTEDPARITYERROR_delay;
wire L0SETLINKMASTERDATAPARITY_delay;
wire L0SETLINKRECEIVEDMASTERABORT_delay;
wire L0SETLINKRECEIVEDTARGETABORT_delay;
wire L0SETLINKSIGNALLEDTARGETABORT_delay;
wire L0SETLINKSYSTEMERROR_delay;
wire L0SETUNEXPECTEDCOMPLETIONCORRERROR_delay;
wire L0SETUNEXPECTEDCOMPLETIONUNCORRERROR_delay;
wire L0SETUNSUPPORTEDREQUESTNONPOSTEDERROR_delay;
wire L0SETUNSUPPORTEDREQUESTOTHERERROR_delay;
wire L0SETUSERDETECTEDPARITYERROR_delay;
wire L0SETUSERMASTERDATAPARITY_delay;
wire L0SETUSERRECEIVEDMASTERABORT_delay;
wire L0SETUSERRECEIVEDTARGETABORT_delay;
wire L0SETUSERSIGNALLEDTARGETABORT_delay;
wire L0SETUSERSYSTEMERROR_delay;
wire L0TLASFCCREDSTARVATION_delay;
wire L0TLLINKRETRAIN_delay;
wire L0TRANSACTIONSPENDING_delay;
wire L0TXBEACON_delay;
wire L0TXCFGPM_delay;
wire L0TXTLSBFCUPDATE_delay;
wire L0TXTLTLPEDB_delay;
wire L0TXTLTLPREQEND_delay;
wire L0TXTLTLPREQ_delay;
wire L0TXTLTLPWIDTH_delay;
wire L0UPSTREAMRXPORTINL0S_delay;
wire L0VC0PREVIEWEXPAND_delay;
wire L0WAKEN_delay;
wire LLKRXDSTCONTREQN_delay;
wire LLKRXDSTREQN_delay;
wire LLKTX4DWHEADERN_delay;
wire LLKTXCOMPLETEN_delay;
wire LLKTXCREATEECRCN_delay;
wire LLKTXEOFN_delay;
wire LLKTXEOPN_delay;
wire LLKTXSOFN_delay;
wire LLKTXSOPN_delay;
wire LLKTXSRCDSCN_delay;
wire LLKTXSRCRDYN_delay;
wire MAINPOWER_delay;
wire MGMTRDEN_delay;
wire MGMTWREN_delay;
wire PIPEPHYSTATUSL0_delay;
wire PIPEPHYSTATUSL1_delay;
wire PIPEPHYSTATUSL2_delay;
wire PIPEPHYSTATUSL3_delay;
wire PIPEPHYSTATUSL4_delay;
wire PIPEPHYSTATUSL5_delay;
wire PIPEPHYSTATUSL6_delay;
wire PIPEPHYSTATUSL7_delay;
wire PIPERXCHANISALIGNEDL0_delay;
wire PIPERXCHANISALIGNEDL1_delay;
wire PIPERXCHANISALIGNEDL2_delay;
wire PIPERXCHANISALIGNEDL3_delay;
wire PIPERXCHANISALIGNEDL4_delay;
wire PIPERXCHANISALIGNEDL5_delay;
wire PIPERXCHANISALIGNEDL6_delay;
wire PIPERXCHANISALIGNEDL7_delay;
wire PIPERXDATAKL0_delay;
wire PIPERXDATAKL1_delay;
wire PIPERXDATAKL2_delay;
wire PIPERXDATAKL3_delay;
wire PIPERXDATAKL4_delay;
wire PIPERXDATAKL5_delay;
wire PIPERXDATAKL6_delay;
wire PIPERXDATAKL7_delay;
wire PIPERXELECIDLEL0_delay;
wire PIPERXELECIDLEL1_delay;
wire PIPERXELECIDLEL2_delay;
wire PIPERXELECIDLEL3_delay;
wire PIPERXELECIDLEL4_delay;
wire PIPERXELECIDLEL5_delay;
wire PIPERXELECIDLEL6_delay;
wire PIPERXELECIDLEL7_delay;
wire PIPERXVALIDL0_delay;
wire PIPERXVALIDL1_delay;
wire PIPERXVALIDL2_delay;
wire PIPERXVALIDL3_delay;
wire PIPERXVALIDL4_delay;
wire PIPERXVALIDL5_delay;
wire PIPERXVALIDL6_delay;
wire PIPERXVALIDL7_delay;
wire [10:0] MGMTADDR_delay;
wire [11:0] L0ACKNAKTIMERADJUSTMENT_delay;
wire [11:0] L0REPLAYTIMERADJUSTMENT_delay;
wire [127:0] L0PACKETHEADERFROMUSER_delay;
wire [159:0] L0TXTLFCCMPLMCCRED_delay;
wire [159:0] L0TXTLFCPOSTORDCRED_delay;
wire [15:0] L0TXTLFCCMPLMCUPDATE_delay;
wire [15:0] L0TXTLFCNPOSTBYPUPDATE_delay;
wire [15:0] L0TXTLFCPOSTORDUPDATE_delay;
wire [18:0] L0TXTLSBFCDATA_delay;
wire [191:0] L0TXTLFCNPOSTBYPCRED_delay;
wire [1:0] L0PWRNEXTLINKSTATE_delay;
wire [1:0] L0TXTLTLPENABLE_delay;
wire [1:0] L0TXTLTLPEND_delay;
wire [1:0] LLKRXCHFIFO_delay;
wire [1:0] LLKTXCHFIFO_delay;
wire [1:0] LLKTXENABLEN_delay;
wire [23:0] L0CFGVCID_delay;
wire [2:0] L0ASTURNPOOLBITSCONSUMED_delay;
wire [2:0] L0CFGL0SEXITLAT_delay;
wire [2:0] L0CFGNEGOTIATEDMAXP_delay;
wire [2:0] L0TXCFGPMTYPE_delay;
wire [2:0] LLKRXCHTC_delay;
wire [2:0] LLKTXCHTC_delay;
wire [2:0] PIPERXSTATUSL0_delay;
wire [2:0] PIPERXSTATUSL1_delay;
wire [2:0] PIPERXSTATUSL2_delay;
wire [2:0] PIPERXSTATUSL3_delay;
wire [2:0] PIPERXSTATUSL4_delay;
wire [2:0] PIPERXSTATUSL5_delay;
wire [2:0] PIPERXSTATUSL6_delay;
wire [2:0] PIPERXSTATUSL7_delay;
wire [31:0] MGMTWDATA_delay;
wire [3:0] L0CFGASSTATECHANGECMD_delay;
wire [3:0] L0MSIREQUEST0_delay;
wire [3:0] L0TXTLTLPLATENCY_delay;
wire [3:0] MGMTBWREN_delay;
wire [5:0] CFGNEGOTIATEDLINKWIDTH_delay;
wire [63:0] L0TXTLTLPDATA_delay;
wire [63:0] LLKTXDATA_delay;
wire [63:0] MIMDLLBRDATA_delay;
wire [63:0] MIMRXBRDATA_delay;
wire [63:0] MIMTXBRDATA_delay;
wire [6:0] MGMTSTATSCREDITSEL_delay;
wire [7:0] L0ASPORTCOUNT_delay;
wire [7:0] L0CFGVCENABLE_delay;
wire [7:0] L0PORTNUMBER_delay;
wire [7:0] L0RXTLTLPNONINITIALIZEDVC_delay;
wire [7:0] PIPERXDATAL0_delay;
wire [7:0] PIPERXDATAL1_delay;
wire [7:0] PIPERXDATAL2_delay;
wire [7:0] PIPERXDATAL3_delay;
wire [7:0] PIPERXDATAL4_delay;
wire [7:0] PIPERXDATAL5_delay;
wire [7:0] PIPERXDATAL6_delay;
wire [7:0] PIPERXDATAL7_delay;


assign #(out_delay) BUSMASTERENABLE = BUSMASTERENABLE_delay;
assign #(out_delay) CRMDOHOTRESETN = CRMDOHOTRESETN_delay;
assign #(out_delay) CRMPWRSOFTRESETN = CRMPWRSOFTRESETN_delay;
assign #(out_delay) CRMRXHOTRESETN = CRMRXHOTRESETN_delay;
assign #(out_delay) DLLTXPMDLLPOUTSTANDING = DLLTXPMDLLPOUTSTANDING_delay;
assign #(out_delay) INTERRUPTDISABLE = INTERRUPTDISABLE_delay;
assign #(out_delay) IOSPACEENABLE = IOSPACEENABLE_delay;
assign #(out_delay) L0ASAUTONOMOUSINITCOMPLETED = L0ASAUTONOMOUSINITCOMPLETED_delay;
assign #(out_delay) L0ATTENTIONINDICATORCONTROL = L0ATTENTIONINDICATORCONTROL_delay;
assign #(out_delay) L0CFGLOOPBACKACK = L0CFGLOOPBACKACK_delay;
assign #(out_delay) L0COMPLETERID = L0COMPLETERID_delay;
assign #(out_delay) L0CORRERRMSGRCVD = L0CORRERRMSGRCVD_delay;
assign #(out_delay) L0DLLASRXSTATE = L0DLLASRXSTATE_delay;
assign #(out_delay) L0DLLASTXSTATE = L0DLLASTXSTATE_delay;
assign #(out_delay) L0DLLERRORVECTOR = L0DLLERRORVECTOR_delay;
assign #(out_delay) L0DLLRXACKOUTSTANDING = L0DLLRXACKOUTSTANDING_delay;
assign #(out_delay) L0DLLTXNONFCOUTSTANDING = L0DLLTXNONFCOUTSTANDING_delay;
assign #(out_delay) L0DLLTXOUTSTANDING = L0DLLTXOUTSTANDING_delay;
assign #(out_delay) L0DLLVCSTATUS = L0DLLVCSTATUS_delay;
assign #(out_delay) L0DLUPDOWN = L0DLUPDOWN_delay;
assign #(out_delay) L0ERRMSGREQID = L0ERRMSGREQID_delay;
assign #(out_delay) L0FATALERRMSGRCVD = L0FATALERRMSGRCVD_delay;
assign #(out_delay) L0FIRSTCFGWRITEOCCURRED = L0FIRSTCFGWRITEOCCURRED_delay;
assign #(out_delay) L0FWDCORRERROUT = L0FWDCORRERROUT_delay;
assign #(out_delay) L0FWDFATALERROUT = L0FWDFATALERROUT_delay;
assign #(out_delay) L0FWDNONFATALERROUT = L0FWDNONFATALERROUT_delay;
assign #(out_delay) L0LTSSMSTATE = L0LTSSMSTATE_delay;
assign #(out_delay) L0MACENTEREDL0 = L0MACENTEREDL0_delay;
assign #(out_delay) L0MACLINKTRAINING = L0MACLINKTRAINING_delay;
assign #(out_delay) L0MACLINKUP = L0MACLINKUP_delay;
assign #(out_delay) L0MACNEGOTIATEDLINKWIDTH = L0MACNEGOTIATEDLINKWIDTH_delay;
assign #(out_delay) L0MACNEWSTATEACK = L0MACNEWSTATEACK_delay;
assign #(out_delay) L0MACRXL0SSTATE = L0MACRXL0SSTATE_delay;
assign #(out_delay) L0MACUPSTREAMDOWNSTREAM = L0MACUPSTREAMDOWNSTREAM_delay;
assign #(out_delay) L0MCFOUND = L0MCFOUND_delay;
assign #(out_delay) L0MSIENABLE0 = L0MSIENABLE0_delay;
assign #(out_delay) L0MULTIMSGEN0 = L0MULTIMSGEN0_delay;
assign #(out_delay) L0NONFATALERRMSGRCVD = L0NONFATALERRMSGRCVD_delay;
assign #(out_delay) L0PMEACK = L0PMEACK_delay;
assign #(out_delay) L0PMEEN = L0PMEEN_delay;
assign #(out_delay) L0PMEREQOUT = L0PMEREQOUT_delay;
assign #(out_delay) L0POWERCONTROLLERCONTROL = L0POWERCONTROLLERCONTROL_delay;
assign #(out_delay) L0POWERINDICATORCONTROL = L0POWERINDICATORCONTROL_delay;
assign #(out_delay) L0PWRINHIBITTRANSFERS = L0PWRINHIBITTRANSFERS_delay;
assign #(out_delay) L0PWRL1STATE = L0PWRL1STATE_delay;
assign #(out_delay) L0PWRL23READYDEVICE = L0PWRL23READYDEVICE_delay;
assign #(out_delay) L0PWRL23READYSTATE = L0PWRL23READYSTATE_delay;
assign #(out_delay) L0PWRSTATE0 = L0PWRSTATE0_delay;
assign #(out_delay) L0PWRTURNOFFREQ = L0PWRTURNOFFREQ_delay;
assign #(out_delay) L0PWRTXL0SSTATE = L0PWRTXL0SSTATE_delay;
assign #(out_delay) L0RECEIVEDASSERTINTALEGACYINT = L0RECEIVEDASSERTINTALEGACYINT_delay;
assign #(out_delay) L0RECEIVEDASSERTINTBLEGACYINT = L0RECEIVEDASSERTINTBLEGACYINT_delay;
assign #(out_delay) L0RECEIVEDASSERTINTCLEGACYINT = L0RECEIVEDASSERTINTCLEGACYINT_delay;
assign #(out_delay) L0RECEIVEDASSERTINTDLEGACYINT = L0RECEIVEDASSERTINTDLEGACYINT_delay;
assign #(out_delay) L0RECEIVEDDEASSERTINTALEGACYINT = L0RECEIVEDDEASSERTINTALEGACYINT_delay;
assign #(out_delay) L0RECEIVEDDEASSERTINTBLEGACYINT = L0RECEIVEDDEASSERTINTBLEGACYINT_delay;
assign #(out_delay) L0RECEIVEDDEASSERTINTCLEGACYINT = L0RECEIVEDDEASSERTINTCLEGACYINT_delay;
assign #(out_delay) L0RECEIVEDDEASSERTINTDLEGACYINT = L0RECEIVEDDEASSERTINTDLEGACYINT_delay;
assign #(out_delay) L0RXBEACON = L0RXBEACON_delay;
assign #(out_delay) L0RXDLLFCCMPLMCCRED = L0RXDLLFCCMPLMCCRED_delay;
assign #(out_delay) L0RXDLLFCCMPLMCUPDATE = L0RXDLLFCCMPLMCUPDATE_delay;
assign #(out_delay) L0RXDLLFCNPOSTBYPCRED = L0RXDLLFCNPOSTBYPCRED_delay;
assign #(out_delay) L0RXDLLFCNPOSTBYPUPDATE = L0RXDLLFCNPOSTBYPUPDATE_delay;
assign #(out_delay) L0RXDLLFCPOSTORDCRED = L0RXDLLFCPOSTORDCRED_delay;
assign #(out_delay) L0RXDLLFCPOSTORDUPDATE = L0RXDLLFCPOSTORDUPDATE_delay;
assign #(out_delay) L0RXDLLPM = L0RXDLLPM_delay;
assign #(out_delay) L0RXDLLPMTYPE = L0RXDLLPMTYPE_delay;
assign #(out_delay) L0RXDLLSBFCDATA = L0RXDLLSBFCDATA_delay;
assign #(out_delay) L0RXDLLSBFCUPDATE = L0RXDLLSBFCUPDATE_delay;
assign #(out_delay) L0RXDLLTLPECRCOK = L0RXDLLTLPECRCOK_delay;
assign #(out_delay) L0RXDLLTLPEND = L0RXDLLTLPEND_delay;
assign #(out_delay) L0RXMACLINKERROR = L0RXMACLINKERROR_delay;
assign #(out_delay) L0STATSCFGOTHERRECEIVED = L0STATSCFGOTHERRECEIVED_delay;
assign #(out_delay) L0STATSCFGOTHERTRANSMITTED = L0STATSCFGOTHERTRANSMITTED_delay;
assign #(out_delay) L0STATSCFGRECEIVED = L0STATSCFGRECEIVED_delay;
assign #(out_delay) L0STATSCFGTRANSMITTED = L0STATSCFGTRANSMITTED_delay;
assign #(out_delay) L0STATSDLLPRECEIVED = L0STATSDLLPRECEIVED_delay;
assign #(out_delay) L0STATSDLLPTRANSMITTED = L0STATSDLLPTRANSMITTED_delay;
assign #(out_delay) L0STATSOSRECEIVED = L0STATSOSRECEIVED_delay;
assign #(out_delay) L0STATSOSTRANSMITTED = L0STATSOSTRANSMITTED_delay;
assign #(out_delay) L0STATSTLPRECEIVED = L0STATSTLPRECEIVED_delay;
assign #(out_delay) L0STATSTLPTRANSMITTED = L0STATSTLPTRANSMITTED_delay;
assign #(out_delay) L0TOGGLEELECTROMECHANICALINTERLOCK = L0TOGGLEELECTROMECHANICALINTERLOCK_delay;
assign #(out_delay) L0TRANSFORMEDVC = L0TRANSFORMEDVC_delay;
assign #(out_delay) L0TXDLLFCCMPLMCUPDATED = L0TXDLLFCCMPLMCUPDATED_delay;
assign #(out_delay) L0TXDLLFCNPOSTBYPUPDATED = L0TXDLLFCNPOSTBYPUPDATED_delay;
assign #(out_delay) L0TXDLLFCPOSTORDUPDATED = L0TXDLLFCPOSTORDUPDATED_delay;
assign #(out_delay) L0TXDLLPMUPDATED = L0TXDLLPMUPDATED_delay;
assign #(out_delay) L0TXDLLSBFCUPDATED = L0TXDLLSBFCUPDATED_delay;
assign #(out_delay) L0UCBYPFOUND = L0UCBYPFOUND_delay;
assign #(out_delay) L0UCORDFOUND = L0UCORDFOUND_delay;
assign #(out_delay) L0UNLOCKRECEIVED = L0UNLOCKRECEIVED_delay;
assign #(out_delay) LLKRX4DWHEADERN = LLKRX4DWHEADERN_delay;
assign #(out_delay) LLKRXCHCOMPLETIONAVAILABLEN = LLKRXCHCOMPLETIONAVAILABLEN_delay;
assign #(out_delay) LLKRXCHCOMPLETIONPARTIALN = LLKRXCHCOMPLETIONPARTIALN_delay;
assign #(out_delay) LLKRXCHCONFIGAVAILABLEN = LLKRXCHCONFIGAVAILABLEN_delay;
assign #(out_delay) LLKRXCHCONFIGPARTIALN = LLKRXCHCONFIGPARTIALN_delay;
assign #(out_delay) LLKRXCHNONPOSTEDAVAILABLEN = LLKRXCHNONPOSTEDAVAILABLEN_delay;
assign #(out_delay) LLKRXCHNONPOSTEDPARTIALN = LLKRXCHNONPOSTEDPARTIALN_delay;
assign #(out_delay) LLKRXCHPOSTEDAVAILABLEN = LLKRXCHPOSTEDAVAILABLEN_delay;
assign #(out_delay) LLKRXCHPOSTEDPARTIALN = LLKRXCHPOSTEDPARTIALN_delay;
assign #(out_delay) LLKRXDATA = LLKRXDATA_delay;
assign #(out_delay) LLKRXECRCBADN = LLKRXECRCBADN_delay;
assign #(out_delay) LLKRXEOFN = LLKRXEOFN_delay;
assign #(out_delay) LLKRXEOPN = LLKRXEOPN_delay;
assign #(out_delay) LLKRXPREFERREDTYPE = LLKRXPREFERREDTYPE_delay;
assign #(out_delay) LLKRXSOFN = LLKRXSOFN_delay;
assign #(out_delay) LLKRXSOPN = LLKRXSOPN_delay;
assign #(out_delay) LLKRXSRCDSCN = LLKRXSRCDSCN_delay;
assign #(out_delay) LLKRXSRCLASTREQN = LLKRXSRCLASTREQN_delay;
assign #(out_delay) LLKRXSRCRDYN = LLKRXSRCRDYN_delay;
assign #(out_delay) LLKRXVALIDN = LLKRXVALIDN_delay;
assign #(out_delay) LLKTCSTATUS = LLKTCSTATUS_delay;
assign #(out_delay) LLKTXCHANSPACE = LLKTXCHANSPACE_delay;
assign #(out_delay) LLKTXCHCOMPLETIONREADYN = LLKTXCHCOMPLETIONREADYN_delay;
assign #(out_delay) LLKTXCHNONPOSTEDREADYN = LLKTXCHNONPOSTEDREADYN_delay;
assign #(out_delay) LLKTXCHPOSTEDREADYN = LLKTXCHPOSTEDREADYN_delay;
assign #(out_delay) LLKTXCONFIGREADYN = LLKTXCONFIGREADYN_delay;
assign #(out_delay) LLKTXDSTRDYN = LLKTXDSTRDYN_delay;
assign #(out_delay) MAXPAYLOADSIZE = MAXPAYLOADSIZE_delay;
assign #(out_delay) MAXREADREQUESTSIZE = MAXREADREQUESTSIZE_delay;
assign #(out_delay) MEMSPACEENABLE = MEMSPACEENABLE_delay;
assign #(out_delay) MGMTPSO = MGMTPSO_delay;
assign #(out_delay) MGMTRDATA = MGMTRDATA_delay;
assign #(out_delay) MGMTSTATSCREDIT = MGMTSTATSCREDIT_delay;
assign #(out_delay) MIMDLLBRADD = MIMDLLBRADD_delay;
assign #(out_delay) MIMDLLBREN = MIMDLLBREN_delay;
assign #(out_delay) MIMDLLBWADD = MIMDLLBWADD_delay;
assign #(out_delay) MIMDLLBWDATA = MIMDLLBWDATA_delay;
assign #(out_delay) MIMDLLBWEN = MIMDLLBWEN_delay;
assign #(out_delay) MIMRXBRADD = MIMRXBRADD_delay;
assign #(out_delay) MIMRXBREN = MIMRXBREN_delay;
assign #(out_delay) MIMRXBWADD = MIMRXBWADD_delay;
assign #(out_delay) MIMRXBWDATA = MIMRXBWDATA_delay;
assign #(out_delay) MIMRXBWEN = MIMRXBWEN_delay;
assign #(out_delay) MIMTXBRADD = MIMTXBRADD_delay;
assign #(out_delay) MIMTXBREN = MIMTXBREN_delay;
assign #(out_delay) MIMTXBWADD = MIMTXBWADD_delay;
assign #(out_delay) MIMTXBWDATA = MIMTXBWDATA_delay;
assign #(out_delay) MIMTXBWEN = MIMTXBWEN_delay;
assign #(out_delay) PARITYERRORRESPONSE = PARITYERRORRESPONSE_delay;
assign #(out_delay) PIPEDESKEWLANESL0 = PIPEDESKEWLANESL0_delay;
assign #(out_delay) PIPEDESKEWLANESL1 = PIPEDESKEWLANESL1_delay;
assign #(out_delay) PIPEDESKEWLANESL2 = PIPEDESKEWLANESL2_delay;
assign #(out_delay) PIPEDESKEWLANESL3 = PIPEDESKEWLANESL3_delay;
assign #(out_delay) PIPEDESKEWLANESL4 = PIPEDESKEWLANESL4_delay;
assign #(out_delay) PIPEDESKEWLANESL5 = PIPEDESKEWLANESL5_delay;
assign #(out_delay) PIPEDESKEWLANESL6 = PIPEDESKEWLANESL6_delay;
assign #(out_delay) PIPEDESKEWLANESL7 = PIPEDESKEWLANESL7_delay;
assign #(out_delay) PIPEPOWERDOWNL0 = PIPEPOWERDOWNL0_delay;
assign #(out_delay) PIPEPOWERDOWNL1 = PIPEPOWERDOWNL1_delay;
assign #(out_delay) PIPEPOWERDOWNL2 = PIPEPOWERDOWNL2_delay;
assign #(out_delay) PIPEPOWERDOWNL3 = PIPEPOWERDOWNL3_delay;
assign #(out_delay) PIPEPOWERDOWNL4 = PIPEPOWERDOWNL4_delay;
assign #(out_delay) PIPEPOWERDOWNL5 = PIPEPOWERDOWNL5_delay;
assign #(out_delay) PIPEPOWERDOWNL6 = PIPEPOWERDOWNL6_delay;
assign #(out_delay) PIPEPOWERDOWNL7 = PIPEPOWERDOWNL7_delay;
assign #(out_delay) PIPERESETL0 = PIPERESETL0_delay;
assign #(out_delay) PIPERESETL1 = PIPERESETL1_delay;
assign #(out_delay) PIPERESETL2 = PIPERESETL2_delay;
assign #(out_delay) PIPERESETL3 = PIPERESETL3_delay;
assign #(out_delay) PIPERESETL4 = PIPERESETL4_delay;
assign #(out_delay) PIPERESETL5 = PIPERESETL5_delay;
assign #(out_delay) PIPERESETL6 = PIPERESETL6_delay;
assign #(out_delay) PIPERESETL7 = PIPERESETL7_delay;
assign #(out_delay) PIPERXPOLARITYL0 = PIPERXPOLARITYL0_delay;
assign #(out_delay) PIPERXPOLARITYL1 = PIPERXPOLARITYL1_delay;
assign #(out_delay) PIPERXPOLARITYL2 = PIPERXPOLARITYL2_delay;
assign #(out_delay) PIPERXPOLARITYL3 = PIPERXPOLARITYL3_delay;
assign #(out_delay) PIPERXPOLARITYL4 = PIPERXPOLARITYL4_delay;
assign #(out_delay) PIPERXPOLARITYL5 = PIPERXPOLARITYL5_delay;
assign #(out_delay) PIPERXPOLARITYL6 = PIPERXPOLARITYL6_delay;
assign #(out_delay) PIPERXPOLARITYL7 = PIPERXPOLARITYL7_delay;
assign #(out_delay) PIPETXCOMPLIANCEL0 = PIPETXCOMPLIANCEL0_delay;
assign #(out_delay) PIPETXCOMPLIANCEL1 = PIPETXCOMPLIANCEL1_delay;
assign #(out_delay) PIPETXCOMPLIANCEL2 = PIPETXCOMPLIANCEL2_delay;
assign #(out_delay) PIPETXCOMPLIANCEL3 = PIPETXCOMPLIANCEL3_delay;
assign #(out_delay) PIPETXCOMPLIANCEL4 = PIPETXCOMPLIANCEL4_delay;
assign #(out_delay) PIPETXCOMPLIANCEL5 = PIPETXCOMPLIANCEL5_delay;
assign #(out_delay) PIPETXCOMPLIANCEL6 = PIPETXCOMPLIANCEL6_delay;
assign #(out_delay) PIPETXCOMPLIANCEL7 = PIPETXCOMPLIANCEL7_delay;
assign #(out_delay) PIPETXDATAKL0 = PIPETXDATAKL0_delay;
assign #(out_delay) PIPETXDATAKL1 = PIPETXDATAKL1_delay;
assign #(out_delay) PIPETXDATAKL2 = PIPETXDATAKL2_delay;
assign #(out_delay) PIPETXDATAKL3 = PIPETXDATAKL3_delay;
assign #(out_delay) PIPETXDATAKL4 = PIPETXDATAKL4_delay;
assign #(out_delay) PIPETXDATAKL5 = PIPETXDATAKL5_delay;
assign #(out_delay) PIPETXDATAKL6 = PIPETXDATAKL6_delay;
assign #(out_delay) PIPETXDATAKL7 = PIPETXDATAKL7_delay;
assign #(out_delay) PIPETXDATAL0 = PIPETXDATAL0_delay;
assign #(out_delay) PIPETXDATAL1 = PIPETXDATAL1_delay;
assign #(out_delay) PIPETXDATAL2 = PIPETXDATAL2_delay;
assign #(out_delay) PIPETXDATAL3 = PIPETXDATAL3_delay;
assign #(out_delay) PIPETXDATAL4 = PIPETXDATAL4_delay;
assign #(out_delay) PIPETXDATAL5 = PIPETXDATAL5_delay;
assign #(out_delay) PIPETXDATAL6 = PIPETXDATAL6_delay;
assign #(out_delay) PIPETXDATAL7 = PIPETXDATAL7_delay;
assign #(out_delay) PIPETXDETECTRXLOOPBACKL0 = PIPETXDETECTRXLOOPBACKL0_delay;
assign #(out_delay) PIPETXDETECTRXLOOPBACKL1 = PIPETXDETECTRXLOOPBACKL1_delay;
assign #(out_delay) PIPETXDETECTRXLOOPBACKL2 = PIPETXDETECTRXLOOPBACKL2_delay;
assign #(out_delay) PIPETXDETECTRXLOOPBACKL3 = PIPETXDETECTRXLOOPBACKL3_delay;
assign #(out_delay) PIPETXDETECTRXLOOPBACKL4 = PIPETXDETECTRXLOOPBACKL4_delay;
assign #(out_delay) PIPETXDETECTRXLOOPBACKL5 = PIPETXDETECTRXLOOPBACKL5_delay;
assign #(out_delay) PIPETXDETECTRXLOOPBACKL6 = PIPETXDETECTRXLOOPBACKL6_delay;
assign #(out_delay) PIPETXDETECTRXLOOPBACKL7 = PIPETXDETECTRXLOOPBACKL7_delay;
assign #(out_delay) PIPETXELECIDLEL0 = PIPETXELECIDLEL0_delay;
assign #(out_delay) PIPETXELECIDLEL1 = PIPETXELECIDLEL1_delay;
assign #(out_delay) PIPETXELECIDLEL2 = PIPETXELECIDLEL2_delay;
assign #(out_delay) PIPETXELECIDLEL3 = PIPETXELECIDLEL3_delay;
assign #(out_delay) PIPETXELECIDLEL4 = PIPETXELECIDLEL4_delay;
assign #(out_delay) PIPETXELECIDLEL5 = PIPETXELECIDLEL5_delay;
assign #(out_delay) PIPETXELECIDLEL6 = PIPETXELECIDLEL6_delay;
assign #(out_delay) PIPETXELECIDLEL7 = PIPETXELECIDLEL7_delay;
assign #(out_delay) SERRENABLE = SERRENABLE_delay;
assign #(out_delay) URREPORTINGENABLE = URREPORTINGENABLE_delay;

assign #(CLK_DELAY) CRMCORECLKDLO_delay = CRMCORECLKDLO;
assign #(CLK_DELAY) CRMCORECLKRXO_delay = CRMCORECLKRXO;
assign #(CLK_DELAY) CRMCORECLKTXO_delay = CRMCORECLKTXO;
assign #(CLK_DELAY) CRMCORECLK_delay = CRMCORECLK;
assign #(CLK_DELAY) CRMUSERCLKRXO_delay = CRMUSERCLKRXO;
assign #(CLK_DELAY) CRMUSERCLKTXO_delay = CRMUSERCLKTXO;
assign #(CLK_DELAY) CRMUSERCLK_delay = CRMUSERCLK;

assign #(in_delay) AUXPOWER_delay = AUXPOWER;
assign #(in_delay) CFGNEGOTIATEDLINKWIDTH_delay = CFGNEGOTIATEDLINKWIDTH;
assign #(in_delay) COMPLIANCEAVOID_delay = COMPLIANCEAVOID;
assign #(in_delay) CRMCFGBRIDGEHOTRESET_delay = CRMCFGBRIDGEHOTRESET;
assign #(in_delay) CRMLINKRSTN_delay = CRMLINKRSTN;
assign #(in_delay) CRMMACRSTN_delay = CRMMACRSTN;
assign #(in_delay) CRMMGMTRSTN_delay = CRMMGMTRSTN;
assign #(in_delay) CRMNVRSTN_delay = CRMNVRSTN;
assign #(in_delay) CRMTXHOTRESETN_delay = CRMTXHOTRESETN;
assign #(in_delay) CRMURSTN_delay = CRMURSTN;
assign #(in_delay) CRMUSERCFGRSTN_delay = CRMUSERCFGRSTN;
assign #(in_delay) CROSSLINKSEED_delay = CROSSLINKSEED;
assign #(in_delay) L0ACKNAKTIMERADJUSTMENT_delay = L0ACKNAKTIMERADJUSTMENT;
assign #(in_delay) L0ALLDOWNPORTSINL1_delay = L0ALLDOWNPORTSINL1;
assign #(in_delay) L0ALLDOWNRXPORTSINL0S_delay = L0ALLDOWNRXPORTSINL0S;
assign #(in_delay) L0ASE_delay = L0ASE;
assign #(in_delay) L0ASPORTCOUNT_delay = L0ASPORTCOUNT;
assign #(in_delay) L0ASTURNPOOLBITSCONSUMED_delay = L0ASTURNPOOLBITSCONSUMED;
assign #(in_delay) L0ATTENTIONBUTTONPRESSED_delay = L0ATTENTIONBUTTONPRESSED;
assign #(in_delay) L0CFGASSPANTREEOWNEDSTATE_delay = L0CFGASSPANTREEOWNEDSTATE;
assign #(in_delay) L0CFGASSTATECHANGECMD_delay = L0CFGASSTATECHANGECMD;
assign #(in_delay) L0CFGDISABLESCRAMBLE_delay = L0CFGDISABLESCRAMBLE;
assign #(in_delay) L0CFGEXTENDEDSYNC_delay = L0CFGEXTENDEDSYNC;
assign #(in_delay) L0CFGL0SENTRYENABLE_delay = L0CFGL0SENTRYENABLE;
assign #(in_delay) L0CFGL0SENTRYSUP_delay = L0CFGL0SENTRYSUP;
assign #(in_delay) L0CFGL0SEXITLAT_delay = L0CFGL0SEXITLAT;
assign #(in_delay) L0CFGLINKDISABLE_delay = L0CFGLINKDISABLE;
assign #(in_delay) L0CFGLOOPBACKMASTER_delay = L0CFGLOOPBACKMASTER;
assign #(in_delay) L0CFGNEGOTIATEDMAXP_delay = L0CFGNEGOTIATEDMAXP;
assign #(in_delay) L0CFGVCENABLE_delay = L0CFGVCENABLE;
assign #(in_delay) L0CFGVCID_delay = L0CFGVCID;
assign #(in_delay) L0DLLHOLDLINKUP_delay = L0DLLHOLDLINKUP;
assign #(in_delay) L0ELECTROMECHANICALINTERLOCKENGAGED_delay = L0ELECTROMECHANICALINTERLOCKENGAGED;
assign #(in_delay) L0FWDASSERTINTALEGACYINT_delay = L0FWDASSERTINTALEGACYINT;
assign #(in_delay) L0FWDASSERTINTBLEGACYINT_delay = L0FWDASSERTINTBLEGACYINT;
assign #(in_delay) L0FWDASSERTINTCLEGACYINT_delay = L0FWDASSERTINTCLEGACYINT;
assign #(in_delay) L0FWDASSERTINTDLEGACYINT_delay = L0FWDASSERTINTDLEGACYINT;
assign #(in_delay) L0FWDCORRERRIN_delay = L0FWDCORRERRIN;
assign #(in_delay) L0FWDDEASSERTINTALEGACYINT_delay = L0FWDDEASSERTINTALEGACYINT;
assign #(in_delay) L0FWDDEASSERTINTBLEGACYINT_delay = L0FWDDEASSERTINTBLEGACYINT;
assign #(in_delay) L0FWDDEASSERTINTCLEGACYINT_delay = L0FWDDEASSERTINTCLEGACYINT;
assign #(in_delay) L0FWDDEASSERTINTDLEGACYINT_delay = L0FWDDEASSERTINTDLEGACYINT;
assign #(in_delay) L0FWDFATALERRIN_delay = L0FWDFATALERRIN;
assign #(in_delay) L0FWDNONFATALERRIN_delay = L0FWDNONFATALERRIN;
assign #(in_delay) L0LEGACYINTFUNCT0_delay = L0LEGACYINTFUNCT0;
assign #(in_delay) L0MRLSENSORCLOSEDN_delay = L0MRLSENSORCLOSEDN;
assign #(in_delay) L0MSIREQUEST0_delay = L0MSIREQUEST0;
assign #(in_delay) L0PACKETHEADERFROMUSER_delay = L0PACKETHEADERFROMUSER;
assign #(in_delay) L0PMEREQIN_delay = L0PMEREQIN;
assign #(in_delay) L0PORTNUMBER_delay = L0PORTNUMBER;
assign #(in_delay) L0POWERFAULTDETECTED_delay = L0POWERFAULTDETECTED;
assign #(in_delay) L0PRESENCEDETECTSLOTEMPTYN_delay = L0PRESENCEDETECTSLOTEMPTYN;
assign #(in_delay) L0PWRNEWSTATEREQ_delay = L0PWRNEWSTATEREQ;
assign #(in_delay) L0PWRNEXTLINKSTATE_delay = L0PWRNEXTLINKSTATE;
assign #(in_delay) L0REPLAYTIMERADJUSTMENT_delay = L0REPLAYTIMERADJUSTMENT;
assign #(in_delay) L0ROOTTURNOFFREQ_delay = L0ROOTTURNOFFREQ;
assign #(in_delay) L0RXTLTLPNONINITIALIZEDVC_delay = L0RXTLTLPNONINITIALIZEDVC;
assign #(in_delay) L0SENDUNLOCKMESSAGE_delay = L0SENDUNLOCKMESSAGE;
assign #(in_delay) L0SETCOMPLETERABORTERROR_delay = L0SETCOMPLETERABORTERROR;
assign #(in_delay) L0SETCOMPLETIONTIMEOUTCORRERROR_delay = L0SETCOMPLETIONTIMEOUTCORRERROR;
assign #(in_delay) L0SETCOMPLETIONTIMEOUTUNCORRERROR_delay = L0SETCOMPLETIONTIMEOUTUNCORRERROR;
assign #(in_delay) L0SETDETECTEDCORRERROR_delay = L0SETDETECTEDCORRERROR;
assign #(in_delay) L0SETDETECTEDFATALERROR_delay = L0SETDETECTEDFATALERROR;
assign #(in_delay) L0SETDETECTEDNONFATALERROR_delay = L0SETDETECTEDNONFATALERROR;
assign #(in_delay) L0SETLINKDETECTEDPARITYERROR_delay = L0SETLINKDETECTEDPARITYERROR;
assign #(in_delay) L0SETLINKMASTERDATAPARITY_delay = L0SETLINKMASTERDATAPARITY;
assign #(in_delay) L0SETLINKRECEIVEDMASTERABORT_delay = L0SETLINKRECEIVEDMASTERABORT;
assign #(in_delay) L0SETLINKRECEIVEDTARGETABORT_delay = L0SETLINKRECEIVEDTARGETABORT;
assign #(in_delay) L0SETLINKSIGNALLEDTARGETABORT_delay = L0SETLINKSIGNALLEDTARGETABORT;
assign #(in_delay) L0SETLINKSYSTEMERROR_delay = L0SETLINKSYSTEMERROR;
assign #(in_delay) L0SETUNEXPECTEDCOMPLETIONCORRERROR_delay = L0SETUNEXPECTEDCOMPLETIONCORRERROR;
assign #(in_delay) L0SETUNEXPECTEDCOMPLETIONUNCORRERROR_delay = L0SETUNEXPECTEDCOMPLETIONUNCORRERROR;
assign #(in_delay) L0SETUNSUPPORTEDREQUESTNONPOSTEDERROR_delay = L0SETUNSUPPORTEDREQUESTNONPOSTEDERROR;
assign #(in_delay) L0SETUNSUPPORTEDREQUESTOTHERERROR_delay = L0SETUNSUPPORTEDREQUESTOTHERERROR;
assign #(in_delay) L0SETUSERDETECTEDPARITYERROR_delay = L0SETUSERDETECTEDPARITYERROR;
assign #(in_delay) L0SETUSERMASTERDATAPARITY_delay = L0SETUSERMASTERDATAPARITY;
assign #(in_delay) L0SETUSERRECEIVEDMASTERABORT_delay = L0SETUSERRECEIVEDMASTERABORT;
assign #(in_delay) L0SETUSERRECEIVEDTARGETABORT_delay = L0SETUSERRECEIVEDTARGETABORT;
assign #(in_delay) L0SETUSERSIGNALLEDTARGETABORT_delay = L0SETUSERSIGNALLEDTARGETABORT;
assign #(in_delay) L0SETUSERSYSTEMERROR_delay = L0SETUSERSYSTEMERROR;
assign #(in_delay) L0TLASFCCREDSTARVATION_delay = L0TLASFCCREDSTARVATION;
assign #(in_delay) L0TLLINKRETRAIN_delay = L0TLLINKRETRAIN;
assign #(in_delay) L0TRANSACTIONSPENDING_delay = L0TRANSACTIONSPENDING;
assign #(in_delay) L0TXBEACON_delay = L0TXBEACON;
assign #(in_delay) L0TXCFGPMTYPE_delay = L0TXCFGPMTYPE;
assign #(in_delay) L0TXCFGPM_delay = L0TXCFGPM;
assign #(in_delay) L0TXTLFCCMPLMCCRED_delay = L0TXTLFCCMPLMCCRED;
assign #(in_delay) L0TXTLFCCMPLMCUPDATE_delay = L0TXTLFCCMPLMCUPDATE;
assign #(in_delay) L0TXTLFCNPOSTBYPCRED_delay = L0TXTLFCNPOSTBYPCRED;
assign #(in_delay) L0TXTLFCNPOSTBYPUPDATE_delay = L0TXTLFCNPOSTBYPUPDATE;
assign #(in_delay) L0TXTLFCPOSTORDCRED_delay = L0TXTLFCPOSTORDCRED;
assign #(in_delay) L0TXTLFCPOSTORDUPDATE_delay = L0TXTLFCPOSTORDUPDATE;
assign #(in_delay) L0TXTLSBFCDATA_delay = L0TXTLSBFCDATA;
assign #(in_delay) L0TXTLSBFCUPDATE_delay = L0TXTLSBFCUPDATE;
assign #(in_delay) L0TXTLTLPDATA_delay = L0TXTLTLPDATA;
assign #(in_delay) L0TXTLTLPEDB_delay = L0TXTLTLPEDB;
assign #(in_delay) L0TXTLTLPENABLE_delay = L0TXTLTLPENABLE;
assign #(in_delay) L0TXTLTLPEND_delay = L0TXTLTLPEND;
assign #(in_delay) L0TXTLTLPLATENCY_delay = L0TXTLTLPLATENCY;
assign #(in_delay) L0TXTLTLPREQEND_delay = L0TXTLTLPREQEND;
assign #(in_delay) L0TXTLTLPREQ_delay = L0TXTLTLPREQ;
assign #(in_delay) L0TXTLTLPWIDTH_delay = L0TXTLTLPWIDTH;
assign #(in_delay) L0UPSTREAMRXPORTINL0S_delay = L0UPSTREAMRXPORTINL0S;
assign #(in_delay) L0VC0PREVIEWEXPAND_delay = L0VC0PREVIEWEXPAND;
assign #(in_delay) L0WAKEN_delay = L0WAKEN;
assign #(in_delay) LLKRXCHFIFO_delay = LLKRXCHFIFO;
assign #(in_delay) LLKRXCHTC_delay = LLKRXCHTC;
assign #(in_delay) LLKRXDSTCONTREQN_delay = LLKRXDSTCONTREQN;
assign #(in_delay) LLKRXDSTREQN_delay = LLKRXDSTREQN;
assign #(in_delay) LLKTX4DWHEADERN_delay = LLKTX4DWHEADERN;
assign #(in_delay) LLKTXCHFIFO_delay = LLKTXCHFIFO;
assign #(in_delay) LLKTXCHTC_delay = LLKTXCHTC;
assign #(in_delay) LLKTXCOMPLETEN_delay = LLKTXCOMPLETEN;
assign #(in_delay) LLKTXCREATEECRCN_delay = LLKTXCREATEECRCN;
assign #(in_delay) LLKTXDATA_delay = LLKTXDATA;
assign #(in_delay) LLKTXENABLEN_delay = LLKTXENABLEN;
assign #(in_delay) LLKTXEOFN_delay = LLKTXEOFN;
assign #(in_delay) LLKTXEOPN_delay = LLKTXEOPN;
assign #(in_delay) LLKTXSOFN_delay = LLKTXSOFN;
assign #(in_delay) LLKTXSOPN_delay = LLKTXSOPN;
assign #(in_delay) LLKTXSRCDSCN_delay = LLKTXSRCDSCN;
assign #(in_delay) LLKTXSRCRDYN_delay = LLKTXSRCRDYN;
assign #(in_delay) MAINPOWER_delay = MAINPOWER;
assign #(in_delay) MGMTADDR_delay = MGMTADDR;
assign #(in_delay) MGMTBWREN_delay = MGMTBWREN;
assign #(in_delay) MGMTRDEN_delay = MGMTRDEN;
assign #(in_delay) MGMTSTATSCREDITSEL_delay = MGMTSTATSCREDITSEL;
assign #(in_delay) MGMTWDATA_delay = MGMTWDATA;
assign #(in_delay) MGMTWREN_delay = MGMTWREN;
assign #(in_delay) MIMDLLBRDATA_delay = MIMDLLBRDATA;
assign #(in_delay) MIMRXBRDATA_delay = MIMRXBRDATA;
assign #(in_delay) MIMTXBRDATA_delay = MIMTXBRDATA;
assign #(in_delay) PIPEPHYSTATUSL0_delay = PIPEPHYSTATUSL0;
assign #(in_delay) PIPEPHYSTATUSL1_delay = PIPEPHYSTATUSL1;
assign #(in_delay) PIPEPHYSTATUSL2_delay = PIPEPHYSTATUSL2;
assign #(in_delay) PIPEPHYSTATUSL3_delay = PIPEPHYSTATUSL3;
assign #(in_delay) PIPEPHYSTATUSL4_delay = PIPEPHYSTATUSL4;
assign #(in_delay) PIPEPHYSTATUSL5_delay = PIPEPHYSTATUSL5;
assign #(in_delay) PIPEPHYSTATUSL6_delay = PIPEPHYSTATUSL6;
assign #(in_delay) PIPEPHYSTATUSL7_delay = PIPEPHYSTATUSL7;
assign #(in_delay) PIPERXCHANISALIGNEDL0_delay = PIPERXCHANISALIGNEDL0;
assign #(in_delay) PIPERXCHANISALIGNEDL1_delay = PIPERXCHANISALIGNEDL1;
assign #(in_delay) PIPERXCHANISALIGNEDL2_delay = PIPERXCHANISALIGNEDL2;
assign #(in_delay) PIPERXCHANISALIGNEDL3_delay = PIPERXCHANISALIGNEDL3;
assign #(in_delay) PIPERXCHANISALIGNEDL4_delay = PIPERXCHANISALIGNEDL4;
assign #(in_delay) PIPERXCHANISALIGNEDL5_delay = PIPERXCHANISALIGNEDL5;
assign #(in_delay) PIPERXCHANISALIGNEDL6_delay = PIPERXCHANISALIGNEDL6;
assign #(in_delay) PIPERXCHANISALIGNEDL7_delay = PIPERXCHANISALIGNEDL7;
assign #(in_delay) PIPERXDATAKL0_delay = PIPERXDATAKL0;
assign #(in_delay) PIPERXDATAKL1_delay = PIPERXDATAKL1;
assign #(in_delay) PIPERXDATAKL2_delay = PIPERXDATAKL2;
assign #(in_delay) PIPERXDATAKL3_delay = PIPERXDATAKL3;
assign #(in_delay) PIPERXDATAKL4_delay = PIPERXDATAKL4;
assign #(in_delay) PIPERXDATAKL5_delay = PIPERXDATAKL5;
assign #(in_delay) PIPERXDATAKL6_delay = PIPERXDATAKL6;
assign #(in_delay) PIPERXDATAKL7_delay = PIPERXDATAKL7;
assign #(in_delay) PIPERXDATAL0_delay = PIPERXDATAL0;
assign #(in_delay) PIPERXDATAL1_delay = PIPERXDATAL1;
assign #(in_delay) PIPERXDATAL2_delay = PIPERXDATAL2;
assign #(in_delay) PIPERXDATAL3_delay = PIPERXDATAL3;
assign #(in_delay) PIPERXDATAL4_delay = PIPERXDATAL4;
assign #(in_delay) PIPERXDATAL5_delay = PIPERXDATAL5;
assign #(in_delay) PIPERXDATAL6_delay = PIPERXDATAL6;
assign #(in_delay) PIPERXDATAL7_delay = PIPERXDATAL7;
assign #(in_delay) PIPERXELECIDLEL0_delay = PIPERXELECIDLEL0;
assign #(in_delay) PIPERXELECIDLEL1_delay = PIPERXELECIDLEL1;
assign #(in_delay) PIPERXELECIDLEL2_delay = PIPERXELECIDLEL2;
assign #(in_delay) PIPERXELECIDLEL3_delay = PIPERXELECIDLEL3;
assign #(in_delay) PIPERXELECIDLEL4_delay = PIPERXELECIDLEL4;
assign #(in_delay) PIPERXELECIDLEL5_delay = PIPERXELECIDLEL5;
assign #(in_delay) PIPERXELECIDLEL6_delay = PIPERXELECIDLEL6;
assign #(in_delay) PIPERXELECIDLEL7_delay = PIPERXELECIDLEL7;
assign #(in_delay) PIPERXSTATUSL0_delay = PIPERXSTATUSL0;
assign #(in_delay) PIPERXSTATUSL1_delay = PIPERXSTATUSL1;
assign #(in_delay) PIPERXSTATUSL2_delay = PIPERXSTATUSL2;
assign #(in_delay) PIPERXSTATUSL3_delay = PIPERXSTATUSL3;
assign #(in_delay) PIPERXSTATUSL4_delay = PIPERXSTATUSL4;
assign #(in_delay) PIPERXSTATUSL5_delay = PIPERXSTATUSL5;
assign #(in_delay) PIPERXSTATUSL6_delay = PIPERXSTATUSL6;
assign #(in_delay) PIPERXSTATUSL7_delay = PIPERXSTATUSL7;
assign #(in_delay) PIPERXVALIDL0_delay = PIPERXVALIDL0;
assign #(in_delay) PIPERXVALIDL1_delay = PIPERXVALIDL1;
assign #(in_delay) PIPERXVALIDL2_delay = PIPERXVALIDL2;
assign #(in_delay) PIPERXVALIDL3_delay = PIPERXVALIDL3;
assign #(in_delay) PIPERXVALIDL4_delay = PIPERXVALIDL4;
assign #(in_delay) PIPERXVALIDL5_delay = PIPERXVALIDL5;
assign #(in_delay) PIPERXVALIDL6_delay = PIPERXVALIDL6;
assign #(in_delay) PIPERXVALIDL7_delay = PIPERXVALIDL7;

PCIE_INTERNAL_1_1_SWIFT pcie_internal_1_1_swift_1 (
	.MCACTIVELANESIN (ACTIVELANESIN),
	.MCAERBASEPTR (AERBASEPTR),
	.MCAERCAPABILITYECRCCHECKCAPABLE (AERCAPABILITYECRCCHECKCAPABLE_BINARY),
	.MCAERCAPABILITYECRCGENCAPABLE (AERCAPABILITYECRCGENCAPABLE_BINARY),
	.MCAERCAPABILITYNEXTPTR (AERCAPABILITYNEXTPTR),
	.MCBAR0ADDRWIDTH (BAR0ADDRWIDTH_BINARY),
	.MCBAR0EXIST (BAR0EXIST_BINARY),
	.MCBAR0IOMEMN (BAR0IOMEMN_BINARY),
	.MCBAR0MASKWIDTH (BAR0MASKWIDTH),
	.MCBAR0PREFETCHABLE (BAR0PREFETCHABLE_BINARY),
	.MCBAR1ADDRWIDTH (BAR1ADDRWIDTH_BINARY),
	.MCBAR1EXIST (BAR1EXIST_BINARY),
	.MCBAR1IOMEMN (BAR1IOMEMN_BINARY),
	.MCBAR1MASKWIDTH (BAR1MASKWIDTH),
	.MCBAR1PREFETCHABLE (BAR1PREFETCHABLE_BINARY),
	.MCBAR2ADDRWIDTH (BAR2ADDRWIDTH_BINARY),
	.MCBAR2EXIST (BAR2EXIST_BINARY),
	.MCBAR2IOMEMN (BAR2IOMEMN_BINARY),
	.MCBAR2MASKWIDTH (BAR2MASKWIDTH),
	.MCBAR2PREFETCHABLE (BAR2PREFETCHABLE_BINARY),
	.MCBAR3ADDRWIDTH (BAR3ADDRWIDTH_BINARY),
	.MCBAR3EXIST (BAR3EXIST_BINARY),
	.MCBAR3IOMEMN (BAR3IOMEMN_BINARY),
	.MCBAR3MASKWIDTH (BAR3MASKWIDTH),
	.MCBAR3PREFETCHABLE (BAR3PREFETCHABLE_BINARY),
	.MCBAR4ADDRWIDTH (BAR4ADDRWIDTH_BINARY),
	.MCBAR4EXIST (BAR4EXIST_BINARY),
	.MCBAR4IOMEMN (BAR4IOMEMN_BINARY),
	.MCBAR4MASKWIDTH (BAR4MASKWIDTH),
	.MCBAR4PREFETCHABLE (BAR4PREFETCHABLE_BINARY),
	.MCBAR5ADDRWIDTH (1'b0),
	.MCBAR5EXIST (BAR5EXIST_BINARY),
	.MCBAR5IOMEMN (BAR5IOMEMN_BINARY),
	.MCBAR5MASKWIDTH (BAR5MASKWIDTH),
	.MCBAR5PREFETCHABLE (BAR5PREFETCHABLE_BINARY),
	.MCCAPABILITIESPOINTER (CAPABILITIESPOINTER),
	.MCCARDBUSCISPOINTER (CARDBUSCISPOINTER),
	.MCCLASSCODE (CLASSCODE),
	.MCCONFIGROUTING (CONFIGROUTING),
	.MCDEVICECAPABILITYENDPOINTL0SLATENCY (DEVICECAPABILITYENDPOINTL0SLATENCY),
	.MCDEVICECAPABILITYENDPOINTL1LATENCY (DEVICECAPABILITYENDPOINTL1LATENCY),
	.MCDEVICEID (DEVICEID),
	.MCDEVICESERIALNUMBER (DEVICESERIALNUMBER),
	.MCDSNBASEPTR (DSNBASEPTR),
	.MCDSNCAPABILITYNEXTPTR (DSNCAPABILITYNEXTPTR),
	.MCDUALCOREENABLE (DUALCOREENABLE_BINARY),
	.MCDUALCORESLAVE (DUALCORESLAVE_BINARY),
	.MCDUALROLECFGCNTRLROOTEPN (DUALROLECFGCNTRLROOTEPN_BINARY),
	.MCEXTCFGCAPPTR (EXTCFGCAPPTR),
	.MCEXTCFGXPCAPPTR (EXTCFGXPCAPPTR),
	.MCHEADERTYPE (HEADERTYPE),
	.MCINFINITECOMPLETIONS (INFINITECOMPLETIONS_BINARY),
	.MCINTERRUPTPIN (INTERRUPTPIN),
	.MCISSWITCH (ISSWITCH_BINARY),
	.MCL0SEXITLATENCY (L0SEXITLATENCY_BINARY),
	.MCL0SEXITLATENCYCOMCLK (L0SEXITLATENCYCOMCLK_BINARY),
	.MCL1EXITLATENCY (L1EXITLATENCY_BINARY),
	.MCL1EXITLATENCYCOMCLK (L1EXITLATENCYCOMCLK_BINARY),
	.MCLINKCAPABILITYASPMSUPPORT (LINKCAPABILITYASPMSUPPORT),
	.MCLINKCAPABILITYMAXLINKWIDTH (LINKCAPABILITYMAXLINKWIDTH),
	.MCLINKSTATUSSLOTCLOCKCONFIG (LINKSTATUSSLOTCLOCKCONFIG_BINARY),
	.MCLLKBYPASS (LLKBYPASS_BINARY),
	.MCLOWPRIORITYVCCOUNT (LOWPRIORITYVCCOUNT_BINARY),
	.MCMSIBASEPTR (MSIBASEPTR),
	.MCMSICAPABILITYMULTIMSGCAP (MSICAPABILITYMULTIMSGCAP),
	.MCMSICAPABILITYNEXTPTR (MSICAPABILITYNEXTPTR),
	.MCPBBASEPTR (PBBASEPTR),
	.MCPBCAPABILITYDW0BASEPOWER (PBCAPABILITYDW0BASEPOWER),
	.MCPBCAPABILITYDW0DATASCALE (PBCAPABILITYDW0DATASCALE),
	.MCPBCAPABILITYDW0PMSTATE (PBCAPABILITYDW0PMSTATE),
	.MCPBCAPABILITYDW0PMSUBSTATE (PBCAPABILITYDW0PMSUBSTATE),
	.MCPBCAPABILITYDW0POWERRAIL (PBCAPABILITYDW0POWERRAIL),
	.MCPBCAPABILITYDW0TYPE (PBCAPABILITYDW0TYPE),
	.MCPBCAPABILITYDW1BASEPOWER (PBCAPABILITYDW1BASEPOWER),
	.MCPBCAPABILITYDW1DATASCALE (PBCAPABILITYDW1DATASCALE),
	.MCPBCAPABILITYDW1PMSTATE (PBCAPABILITYDW1PMSTATE),
	.MCPBCAPABILITYDW1PMSUBSTATE (PBCAPABILITYDW1PMSUBSTATE),
	.MCPBCAPABILITYDW1POWERRAIL (PBCAPABILITYDW1POWERRAIL),
	.MCPBCAPABILITYDW1TYPE (PBCAPABILITYDW1TYPE),
	.MCPBCAPABILITYDW2BASEPOWER (PBCAPABILITYDW2BASEPOWER),
	.MCPBCAPABILITYDW2DATASCALE (PBCAPABILITYDW2DATASCALE),
	.MCPBCAPABILITYDW2PMSTATE (PBCAPABILITYDW2PMSTATE),
	.MCPBCAPABILITYDW2PMSUBSTATE (PBCAPABILITYDW2PMSUBSTATE),
	.MCPBCAPABILITYDW2POWERRAIL (PBCAPABILITYDW2POWERRAIL),
	.MCPBCAPABILITYDW2TYPE (PBCAPABILITYDW2TYPE),
	.MCPBCAPABILITYDW3BASEPOWER (PBCAPABILITYDW3BASEPOWER),
	.MCPBCAPABILITYDW3DATASCALE (PBCAPABILITYDW3DATASCALE),
	.MCPBCAPABILITYDW3PMSTATE (PBCAPABILITYDW3PMSTATE),
	.MCPBCAPABILITYDW3PMSUBSTATE (PBCAPABILITYDW3PMSUBSTATE),
	.MCPBCAPABILITYDW3POWERRAIL (PBCAPABILITYDW3POWERRAIL),
	.MCPBCAPABILITYDW3TYPE (PBCAPABILITYDW3TYPE),
	.MCPBCAPABILITYNEXTPTR (PBCAPABILITYNEXTPTR),
	.MCPBCAPABILITYSYSTEMALLOCATED (PBCAPABILITYSYSTEMALLOCATED_BINARY),
	.MCPCIECAPABILITYINTMSGNUM (PCIECAPABILITYINTMSGNUM),
	.MCPCIECAPABILITYNEXTPTR (PCIECAPABILITYNEXTPTR),
	.MCPCIECAPABILITYSLOTIMPL (PCIECAPABILITYSLOTIMPL_BINARY),
	.MCPCIEREVISION (PCIEREVISION_BINARY),
	.MCPMBASEPTR (PMBASEPTR),
	.MCPMCAPABILITYAUXCURRENT (PMCAPABILITYAUXCURRENT),
	.MCPMCAPABILITYD1SUPPORT (PMCAPABILITYD1SUPPORT_BINARY),
	.MCPMCAPABILITYD2SUPPORT (PMCAPABILITYD2SUPPORT_BINARY),
	.MCPMCAPABILITYDSI (PMCAPABILITYDSI_BINARY),
	.MCPMCAPABILITYNEXTPTR (PMCAPABILITYNEXTPTR),
	.MCPMCAPABILITYPMESUPPORT (PMCAPABILITYPMESUPPORT),
	.MCPMDATA0 (PMDATA0),
	.MCPMDATA1 (PMDATA1),
	.MCPMDATA2 (PMDATA2),
	.MCPMDATA3 (PMDATA3),
	.MCPMDATA4 (PMDATA4),
	.MCPMDATA5 (PMDATA5),
	.MCPMDATA6 (PMDATA6),
	.MCPMDATA7 (PMDATA7),
	.MCPMDATA8 (PMDATA8),
	.MCPMDATASCALE0 (PMDATASCALE0_BINARY),
	.MCPMDATASCALE1 (PMDATASCALE1_BINARY),
	.MCPMDATASCALE2 (PMDATASCALE2_BINARY),
	.MCPMDATASCALE3 (PMDATASCALE3_BINARY),
	.MCPMDATASCALE4 (PMDATASCALE4_BINARY),
	.MCPMDATASCALE5 (PMDATASCALE5_BINARY),
	.MCPMDATASCALE6 (PMDATASCALE6_BINARY),
	.MCPMDATASCALE7 (PMDATASCALE7_BINARY),
	.MCPMDATASCALE8 (PMDATASCALE8_BINARY),
	.MCPMSTATUSCONTROLDATASCALE (PMSTATUSCONTROLDATASCALE),
	.MCPORTVCCAPABILITYEXTENDEDVCCOUNT (PORTVCCAPABILITYEXTENDEDVCCOUNT),
	.MCPORTVCCAPABILITYVCARBCAP (PORTVCCAPABILITYVCARBCAP),
	.MCPORTVCCAPABILITYVCARBTABLEOFFSET (PORTVCCAPABILITYVCARBTABLEOFFSET),
	.MCRAMSHARETXRX (RAMSHARETXRX_BINARY),
	.MCRESETMODE (RESETMODE_BINARY),
	.MCRETRYRAMREADLATENCY (RETRYRAMREADLATENCY_BINARY),
	.MCRETRYRAMSIZE (RETRYRAMSIZE),
	.MCRETRYRAMWIDTH (RETRYRAMWIDTH_BINARY),
	.MCRETRYRAMWRITELATENCY (RETRYRAMWRITELATENCY_BINARY),
	.MCRETRYREADADDRPIPE (RETRYREADADDRPIPE_BINARY),
	.MCRETRYREADDATAPIPE (RETRYREADDATAPIPE_BINARY),
	.MCRETRYWRITEPIPE (RETRYWRITEPIPE_BINARY),
	.MCREVISIONID (REVISIONID),
	.MCRXREADADDRPIPE (RXREADADDRPIPE_BINARY),
	.MCRXREADDATAPIPE (RXREADDATAPIPE_BINARY),
	.MCRXWRITEPIPE (RXWRITEPIPE_BINARY),
	.MCSELECTASMODE (SELECTASMODE_BINARY),
	.MCSELECTDLLIF (SELECTDLLIF_BINARY),
	.MCSLOTCAPABILITYATTBUTTONPRESENT (SLOTCAPABILITYATTBUTTONPRESENT_BINARY),
	.MCSLOTCAPABILITYATTINDICATORPRESENT (SLOTCAPABILITYATTINDICATORPRESENT_BINARY),
	.MCSLOTCAPABILITYHOTPLUGCAPABLE (SLOTCAPABILITYHOTPLUGCAPABLE_BINARY),
	.MCSLOTCAPABILITYHOTPLUGSURPRISE (SLOTCAPABILITYHOTPLUGSURPRISE_BINARY),
	.MCSLOTCAPABILITYMSLSENSORPRESENT (SLOTCAPABILITYMSLSENSORPRESENT_BINARY),
	.MCSLOTCAPABILITYPHYSICALSLOTNUM (SLOTCAPABILITYPHYSICALSLOTNUM),
	.MCSLOTCAPABILITYPOWERCONTROLLERPRESENT (SLOTCAPABILITYPOWERCONTROLLERPRESENT_BINARY),
	.MCSLOTCAPABILITYPOWERINDICATORPRESENT (SLOTCAPABILITYPOWERINDICATORPRESENT_BINARY),
	.MCSLOTCAPABILITYSLOTPOWERLIMITSCALE (SLOTCAPABILITYSLOTPOWERLIMITSCALE),
	.MCSLOTCAPABILITYSLOTPOWERLIMITVALUE (SLOTCAPABILITYSLOTPOWERLIMITVALUE),
	.MCSLOTIMPLEMENTED (SLOTIMPLEMENTED_BINARY),
	.MCSUBSYSTEMID (SUBSYSTEMID),
	.MCSUBSYSTEMVENDORID (SUBSYSTEMVENDORID),
	.MCTLRAMREADLATENCY (TLRAMREADLATENCY_BINARY),
	.MCTLRAMWIDTH (TLRAMWIDTH_BINARY),
	.MCTLRAMWRITELATENCY (TLRAMWRITELATENCY_BINARY),
	.MCTXREADADDRPIPE (TXREADADDRPIPE_BINARY),
	.MCTXREADDATAPIPE (TXREADDATAPIPE_BINARY),
	.MCTXTSNFTS (TXTSNFTS_BINARY),
	.MCTXTSNFTSCOMCLK (TXTSNFTSCOMCLK_BINARY),
	.MCTXWRITEPIPE (TXWRITEPIPE_BINARY),
	.MCUPSTREAMFACING (UPSTREAMFACING_BINARY),
	.MCVC0RXFIFOBASEC (VC0RXFIFOBASEC),
	.MCVC0RXFIFOBASENP (VC0RXFIFOBASENP),
	.MCVC0RXFIFOBASEP (VC0RXFIFOBASEP),
	.MCVC0RXFIFOLIMITC (VC0RXFIFOLIMITC),
	.MCVC0RXFIFOLIMITNP (VC0RXFIFOLIMITNP),
	.MCVC0RXFIFOLIMITP (VC0RXFIFOLIMITP),
	.MCVC0TOTALCREDITSCD (VC0TOTALCREDITSCD),
	.MCVC0TOTALCREDITSCH (VC0TOTALCREDITSCH),
	.MCVC0TOTALCREDITSNPH (VC0TOTALCREDITSNPH),
	.MCVC0TOTALCREDITSPD (VC0TOTALCREDITSPD),
	.MCVC0TOTALCREDITSPH (VC0TOTALCREDITSPH),
	.MCVC0TXFIFOBASEC (VC0TXFIFOBASEC),
	.MCVC0TXFIFOBASENP (VC0TXFIFOBASENP),
	.MCVC0TXFIFOBASEP (VC0TXFIFOBASEP),
	.MCVC0TXFIFOLIMITC (VC0TXFIFOLIMITC),
	.MCVC0TXFIFOLIMITNP (VC0TXFIFOLIMITNP),
	.MCVC0TXFIFOLIMITP (VC0TXFIFOLIMITP),
	.MCVC1RXFIFOBASEC (VC1RXFIFOBASEC),
	.MCVC1RXFIFOBASENP (VC1RXFIFOBASENP),
	.MCVC1RXFIFOBASEP (VC1RXFIFOBASEP),
	.MCVC1RXFIFOLIMITC (VC1RXFIFOLIMITC),
	.MCVC1RXFIFOLIMITNP (VC1RXFIFOLIMITNP),
	.MCVC1RXFIFOLIMITP (VC1RXFIFOLIMITP),
	.MCVC1TOTALCREDITSCD (VC1TOTALCREDITSCD),
	.MCVC1TOTALCREDITSCH (VC1TOTALCREDITSCH),
	.MCVC1TOTALCREDITSNPH (VC1TOTALCREDITSNPH),
	.MCVC1TOTALCREDITSPD (VC1TOTALCREDITSPD),
	.MCVC1TOTALCREDITSPH (VC1TOTALCREDITSPH),
	.MCVC1TXFIFOBASEC (VC1TXFIFOBASEC),
	.MCVC1TXFIFOBASENP (VC1TXFIFOBASENP),
	.MCVC1TXFIFOBASEP (VC1TXFIFOBASEP),
	.MCVC1TXFIFOLIMITC (VC1TXFIFOLIMITC),
	.MCVC1TXFIFOLIMITNP (VC1TXFIFOLIMITNP),
	.MCVC1TXFIFOLIMITP (VC1TXFIFOLIMITP),
	.MCVCBASEPTR (VCBASEPTR),
	.MCVCCAPABILITYNEXTPTR (VCCAPABILITYNEXTPTR),
	.MCVENDORID (VENDORID),
	.MCXLINKSUPPORTED (XLINKSUPPORTED_BINARY),
	.MCXPBASEPTR (XPBASEPTR),
	.MCXPDEVICEPORTTYPE (XPDEVICEPORTTYPE),
	.MCXPMAXPAYLOAD (XPMAXPAYLOAD_BINARY),
	.MCXPRCBCONTROL (XPRCBCONTROL_BINARY),

	.BUSMASTERENABLE (BUSMASTERENABLE_delay),
	.CRMDOHOTRESETN (CRMDOHOTRESETN_delay),
	.CRMPWRSOFTRESETN (CRMPWRSOFTRESETN_delay),
	.CRMRXHOTRESETN (CRMRXHOTRESETN_delay),
	.DLLTXPMDLLPOUTSTANDING (DLLTXPMDLLPOUTSTANDING_delay),
	.INTERRUPTDISABLE (INTERRUPTDISABLE_delay),
	.IOSPACEENABLE (IOSPACEENABLE_delay),
	.L0ASAUTONOMOUSINITCOMPLETED (L0ASAUTONOMOUSINITCOMPLETED_delay),
	.L0ATTENTIONINDICATORCONTROL (L0ATTENTIONINDICATORCONTROL_delay),
	.L0CFGLOOPBACKACK (L0CFGLOOPBACKACK_delay),
	.L0COMPLETERID (L0COMPLETERID_delay),
	.L0CORRERRMSGRCVD (L0CORRERRMSGRCVD_delay),
	.L0DLLASRXSTATE (L0DLLASRXSTATE_delay),
	.L0DLLASTXSTATE (L0DLLASTXSTATE_delay),
	.L0DLLERRORVECTOR (L0DLLERRORVECTOR_delay),
	.L0DLLRXACKOUTSTANDING (L0DLLRXACKOUTSTANDING_delay),
	.L0DLLTXNONFCOUTSTANDING (L0DLLTXNONFCOUTSTANDING_delay),
	.L0DLLTXOUTSTANDING (L0DLLTXOUTSTANDING_delay),
	.L0DLLVCSTATUS (L0DLLVCSTATUS_delay),
	.L0DLUPDOWN (L0DLUPDOWN_delay),
	.L0ERRMSGREQID (L0ERRMSGREQID_delay),
	.L0FATALERRMSGRCVD (L0FATALERRMSGRCVD_delay),
	.L0FIRSTCFGWRITEOCCURRED (L0FIRSTCFGWRITEOCCURRED_delay),
	.L0FWDCORRERROUT (L0FWDCORRERROUT_delay),
	.L0FWDFATALERROUT (L0FWDFATALERROUT_delay),
	.L0FWDNONFATALERROUT (L0FWDNONFATALERROUT_delay),
	.L0LTSSMSTATE (L0LTSSMSTATE_delay),
	.L0MACENTEREDL0 (L0MACENTEREDL0_delay),
	.L0MACLINKTRAINING (L0MACLINKTRAINING_delay),
	.L0MACLINKUP (L0MACLINKUP_delay),
	.L0MACNEGOTIATEDLINKWIDTH (L0MACNEGOTIATEDLINKWIDTH_delay),
	.L0MACNEWSTATEACK (L0MACNEWSTATEACK_delay),
	.L0MACRXL0SSTATE (L0MACRXL0SSTATE_delay),
	.L0MACUPSTREAMDOWNSTREAM (L0MACUPSTREAMDOWNSTREAM_delay),
	.L0MCFOUND (L0MCFOUND_delay),
	.L0MSIENABLE0 (L0MSIENABLE0_delay),
	.L0MULTIMSGEN0 (L0MULTIMSGEN0_delay),
	.L0NONFATALERRMSGRCVD (L0NONFATALERRMSGRCVD_delay),
	.L0PMEACK (L0PMEACK_delay),
	.L0PMEEN (L0PMEEN_delay),
	.L0PMEREQOUT (L0PMEREQOUT_delay),
	.L0POWERCONTROLLERCONTROL (L0POWERCONTROLLERCONTROL_delay),
	.L0POWERINDICATORCONTROL (L0POWERINDICATORCONTROL_delay),
	.L0PWRINHIBITTRANSFERS (L0PWRINHIBITTRANSFERS_delay),
	.L0PWRL1STATE (L0PWRL1STATE_delay),
	.L0PWRL23READYDEVICE (L0PWRL23READYDEVICE_delay),
	.L0PWRL23READYSTATE (L0PWRL23READYSTATE_delay),
	.L0PWRSTATE0 (L0PWRSTATE0_delay),
	.L0PWRTURNOFFREQ (L0PWRTURNOFFREQ_delay),
	.L0PWRTXL0SSTATE (L0PWRTXL0SSTATE_delay),
	.L0RECEIVEDASSERTINTALEGACYINT (L0RECEIVEDASSERTINTALEGACYINT_delay),
	.L0RECEIVEDASSERTINTBLEGACYINT (L0RECEIVEDASSERTINTBLEGACYINT_delay),
	.L0RECEIVEDASSERTINTCLEGACYINT (L0RECEIVEDASSERTINTCLEGACYINT_delay),
	.L0RECEIVEDASSERTINTDLEGACYINT (L0RECEIVEDASSERTINTDLEGACYINT_delay),
	.L0RECEIVEDDEASSERTINTALEGACYINT (L0RECEIVEDDEASSERTINTALEGACYINT_delay),
	.L0RECEIVEDDEASSERTINTBLEGACYINT (L0RECEIVEDDEASSERTINTBLEGACYINT_delay),
	.L0RECEIVEDDEASSERTINTCLEGACYINT (L0RECEIVEDDEASSERTINTCLEGACYINT_delay),
	.L0RECEIVEDDEASSERTINTDLEGACYINT (L0RECEIVEDDEASSERTINTDLEGACYINT_delay),
	.L0RXBEACON (L0RXBEACON_delay),
	.L0RXDLLFCCMPLMCCRED (L0RXDLLFCCMPLMCCRED_delay),
	.L0RXDLLFCCMPLMCUPDATE (L0RXDLLFCCMPLMCUPDATE_delay),
	.L0RXDLLFCNPOSTBYPCRED (L0RXDLLFCNPOSTBYPCRED_delay),
	.L0RXDLLFCNPOSTBYPUPDATE (L0RXDLLFCNPOSTBYPUPDATE_delay),
	.L0RXDLLFCPOSTORDCRED (L0RXDLLFCPOSTORDCRED_delay),
	.L0RXDLLFCPOSTORDUPDATE (L0RXDLLFCPOSTORDUPDATE_delay),
	.L0RXDLLPM (L0RXDLLPM_delay),
	.L0RXDLLPMTYPE (L0RXDLLPMTYPE_delay),
	.L0RXDLLSBFCDATA (L0RXDLLSBFCDATA_delay),
	.L0RXDLLSBFCUPDATE (L0RXDLLSBFCUPDATE_delay),
	.L0RXDLLTLPECRCOK (L0RXDLLTLPECRCOK_delay),
	.L0RXDLLTLPEND (L0RXDLLTLPEND_delay),
	.L0RXMACLINKERROR (L0RXMACLINKERROR_delay),
	.L0STATSCFGOTHERRECEIVED (L0STATSCFGOTHERRECEIVED_delay),
	.L0STATSCFGOTHERTRANSMITTED (L0STATSCFGOTHERTRANSMITTED_delay),
	.L0STATSCFGRECEIVED (L0STATSCFGRECEIVED_delay),
	.L0STATSCFGTRANSMITTED (L0STATSCFGTRANSMITTED_delay),
	.L0STATSDLLPRECEIVED (L0STATSDLLPRECEIVED_delay),
	.L0STATSDLLPTRANSMITTED (L0STATSDLLPTRANSMITTED_delay),
	.L0STATSOSRECEIVED (L0STATSOSRECEIVED_delay),
	.L0STATSOSTRANSMITTED (L0STATSOSTRANSMITTED_delay),
	.L0STATSTLPRECEIVED (L0STATSTLPRECEIVED_delay),
	.L0STATSTLPTRANSMITTED (L0STATSTLPTRANSMITTED_delay),
	.L0TOGGLEELECTROMECHANICALINTERLOCK (L0TOGGLEELECTROMECHANICALINTERLOCK_delay),
	.L0TRANSFORMEDVC (L0TRANSFORMEDVC_delay),
	.L0TXDLLFCCMPLMCUPDATED (L0TXDLLFCCMPLMCUPDATED_delay),
	.L0TXDLLFCNPOSTBYPUPDATED (L0TXDLLFCNPOSTBYPUPDATED_delay),
	.L0TXDLLFCPOSTORDUPDATED (L0TXDLLFCPOSTORDUPDATED_delay),
	.L0TXDLLPMUPDATED (L0TXDLLPMUPDATED_delay),
	.L0TXDLLSBFCUPDATED (L0TXDLLSBFCUPDATED_delay),
	.L0UCBYPFOUND (L0UCBYPFOUND_delay),
	.L0UCORDFOUND (L0UCORDFOUND_delay),
	.L0UNLOCKRECEIVED (L0UNLOCKRECEIVED_delay),
	.LLKRX4DWHEADERN (LLKRX4DWHEADERN_delay),
	.LLKRXCHCOMPLETIONAVAILABLEN (LLKRXCHCOMPLETIONAVAILABLEN_delay),
	.LLKRXCHCOMPLETIONPARTIALN (LLKRXCHCOMPLETIONPARTIALN_delay),
	.LLKRXCHCONFIGAVAILABLEN (LLKRXCHCONFIGAVAILABLEN_delay),
	.LLKRXCHCONFIGPARTIALN (LLKRXCHCONFIGPARTIALN_delay),
	.LLKRXCHNONPOSTEDAVAILABLEN (LLKRXCHNONPOSTEDAVAILABLEN_delay),
	.LLKRXCHNONPOSTEDPARTIALN (LLKRXCHNONPOSTEDPARTIALN_delay),
	.LLKRXCHPOSTEDAVAILABLEN (LLKRXCHPOSTEDAVAILABLEN_delay),
	.LLKRXCHPOSTEDPARTIALN (LLKRXCHPOSTEDPARTIALN_delay),
	.LLKRXDATA (LLKRXDATA_delay),
	.LLKRXECRCBADN (LLKRXECRCBADN_delay),
	.LLKRXEOFN (LLKRXEOFN_delay),
	.LLKRXEOPN (LLKRXEOPN_delay),
	.LLKRXPREFERREDTYPE (LLKRXPREFERREDTYPE_delay),
	.LLKRXSOFN (LLKRXSOFN_delay),
	.LLKRXSOPN (LLKRXSOPN_delay),
	.LLKRXSRCDSCN (LLKRXSRCDSCN_delay),
	.LLKRXSRCLASTREQN (LLKRXSRCLASTREQN_delay),
	.LLKRXSRCRDYN (LLKRXSRCRDYN_delay),
	.LLKRXVALIDN (LLKRXVALIDN_delay),
	.LLKTCSTATUS (LLKTCSTATUS_delay),
	.LLKTXCHANSPACE (LLKTXCHANSPACE_delay),
	.LLKTXCHCOMPLETIONREADYN (LLKTXCHCOMPLETIONREADYN_delay),
	.LLKTXCHNONPOSTEDREADYN (LLKTXCHNONPOSTEDREADYN_delay),
	.LLKTXCHPOSTEDREADYN (LLKTXCHPOSTEDREADYN_delay),
	.LLKTXCONFIGREADYN (LLKTXCONFIGREADYN_delay),
	.LLKTXDSTRDYN (LLKTXDSTRDYN_delay),
	.MAXPAYLOADSIZE (MAXPAYLOADSIZE_delay),
	.MAXREADREQUESTSIZE (MAXREADREQUESTSIZE_delay),
	.MEMSPACEENABLE (MEMSPACEENABLE_delay),
	.MGMTPSO (MGMTPSO_delay),
	.MGMTRDATA (MGMTRDATA_delay),
	.MGMTSTATSCREDIT (MGMTSTATSCREDIT_delay),
	.MIMDLLBRADD (MIMDLLBRADD_delay),
	.MIMDLLBREN (MIMDLLBREN_delay),
	.MIMDLLBWADD (MIMDLLBWADD_delay),
	.MIMDLLBWDATA (MIMDLLBWDATA_delay),
	.MIMDLLBWEN (MIMDLLBWEN_delay),
	.MIMRXBRADD (MIMRXBRADD_delay),
	.MIMRXBREN (MIMRXBREN_delay),
	.MIMRXBWADD (MIMRXBWADD_delay),
	.MIMRXBWDATA (MIMRXBWDATA_delay),
	.MIMRXBWEN (MIMRXBWEN_delay),
	.MIMTXBRADD (MIMTXBRADD_delay),
	.MIMTXBREN (MIMTXBREN_delay),
	.MIMTXBWADD (MIMTXBWADD_delay),
	.MIMTXBWDATA (MIMTXBWDATA_delay),
	.MIMTXBWEN (MIMTXBWEN_delay),
	.PARITYERRORRESPONSE (PARITYERRORRESPONSE_delay),
	.PIPEDESKEWLANESL0 (PIPEDESKEWLANESL0_delay),
	.PIPEDESKEWLANESL1 (PIPEDESKEWLANESL1_delay),
	.PIPEDESKEWLANESL2 (PIPEDESKEWLANESL2_delay),
	.PIPEDESKEWLANESL3 (PIPEDESKEWLANESL3_delay),
	.PIPEDESKEWLANESL4 (PIPEDESKEWLANESL4_delay),
	.PIPEDESKEWLANESL5 (PIPEDESKEWLANESL5_delay),
	.PIPEDESKEWLANESL6 (PIPEDESKEWLANESL6_delay),
	.PIPEDESKEWLANESL7 (PIPEDESKEWLANESL7_delay),
	.PIPEPOWERDOWNL0 (PIPEPOWERDOWNL0_delay),
	.PIPEPOWERDOWNL1 (PIPEPOWERDOWNL1_delay),
	.PIPEPOWERDOWNL2 (PIPEPOWERDOWNL2_delay),
	.PIPEPOWERDOWNL3 (PIPEPOWERDOWNL3_delay),
	.PIPEPOWERDOWNL4 (PIPEPOWERDOWNL4_delay),
	.PIPEPOWERDOWNL5 (PIPEPOWERDOWNL5_delay),
	.PIPEPOWERDOWNL6 (PIPEPOWERDOWNL6_delay),
	.PIPEPOWERDOWNL7 (PIPEPOWERDOWNL7_delay),
	.PIPERESETL0 (PIPERESETL0_delay),
	.PIPERESETL1 (PIPERESETL1_delay),
	.PIPERESETL2 (PIPERESETL2_delay),
	.PIPERESETL3 (PIPERESETL3_delay),
	.PIPERESETL4 (PIPERESETL4_delay),
	.PIPERESETL5 (PIPERESETL5_delay),
	.PIPERESETL6 (PIPERESETL6_delay),
	.PIPERESETL7 (PIPERESETL7_delay),
	.PIPERXPOLARITYL0 (PIPERXPOLARITYL0_delay),
	.PIPERXPOLARITYL1 (PIPERXPOLARITYL1_delay),
	.PIPERXPOLARITYL2 (PIPERXPOLARITYL2_delay),
	.PIPERXPOLARITYL3 (PIPERXPOLARITYL3_delay),
	.PIPERXPOLARITYL4 (PIPERXPOLARITYL4_delay),
	.PIPERXPOLARITYL5 (PIPERXPOLARITYL5_delay),
	.PIPERXPOLARITYL6 (PIPERXPOLARITYL6_delay),
	.PIPERXPOLARITYL7 (PIPERXPOLARITYL7_delay),
	.PIPETXCOMPLIANCEL0 (PIPETXCOMPLIANCEL0_delay),
	.PIPETXCOMPLIANCEL1 (PIPETXCOMPLIANCEL1_delay),
	.PIPETXCOMPLIANCEL2 (PIPETXCOMPLIANCEL2_delay),
	.PIPETXCOMPLIANCEL3 (PIPETXCOMPLIANCEL3_delay),
	.PIPETXCOMPLIANCEL4 (PIPETXCOMPLIANCEL4_delay),
	.PIPETXCOMPLIANCEL5 (PIPETXCOMPLIANCEL5_delay),
	.PIPETXCOMPLIANCEL6 (PIPETXCOMPLIANCEL6_delay),
	.PIPETXCOMPLIANCEL7 (PIPETXCOMPLIANCEL7_delay),
	.PIPETXDATAKL0 (PIPETXDATAKL0_delay),
	.PIPETXDATAKL1 (PIPETXDATAKL1_delay),
	.PIPETXDATAKL2 (PIPETXDATAKL2_delay),
	.PIPETXDATAKL3 (PIPETXDATAKL3_delay),
	.PIPETXDATAKL4 (PIPETXDATAKL4_delay),
	.PIPETXDATAKL5 (PIPETXDATAKL5_delay),
	.PIPETXDATAKL6 (PIPETXDATAKL6_delay),
	.PIPETXDATAKL7 (PIPETXDATAKL7_delay),
	.PIPETXDATAL0 (PIPETXDATAL0_delay),
	.PIPETXDATAL1 (PIPETXDATAL1_delay),
	.PIPETXDATAL2 (PIPETXDATAL2_delay),
	.PIPETXDATAL3 (PIPETXDATAL3_delay),
	.PIPETXDATAL4 (PIPETXDATAL4_delay),
	.PIPETXDATAL5 (PIPETXDATAL5_delay),
	.PIPETXDATAL6 (PIPETXDATAL6_delay),
	.PIPETXDATAL7 (PIPETXDATAL7_delay),
	.PIPETXDETECTRXLOOPBACKL0 (PIPETXDETECTRXLOOPBACKL0_delay),
	.PIPETXDETECTRXLOOPBACKL1 (PIPETXDETECTRXLOOPBACKL1_delay),
	.PIPETXDETECTRXLOOPBACKL2 (PIPETXDETECTRXLOOPBACKL2_delay),
	.PIPETXDETECTRXLOOPBACKL3 (PIPETXDETECTRXLOOPBACKL3_delay),
	.PIPETXDETECTRXLOOPBACKL4 (PIPETXDETECTRXLOOPBACKL4_delay),
	.PIPETXDETECTRXLOOPBACKL5 (PIPETXDETECTRXLOOPBACKL5_delay),
	.PIPETXDETECTRXLOOPBACKL6 (PIPETXDETECTRXLOOPBACKL6_delay),
	.PIPETXDETECTRXLOOPBACKL7 (PIPETXDETECTRXLOOPBACKL7_delay),
	.PIPETXELECIDLEL0 (PIPETXELECIDLEL0_delay),
	.PIPETXELECIDLEL1 (PIPETXELECIDLEL1_delay),
	.PIPETXELECIDLEL2 (PIPETXELECIDLEL2_delay),
	.PIPETXELECIDLEL3 (PIPETXELECIDLEL3_delay),
	.PIPETXELECIDLEL4 (PIPETXELECIDLEL4_delay),
	.PIPETXELECIDLEL5 (PIPETXELECIDLEL5_delay),
	.PIPETXELECIDLEL6 (PIPETXELECIDLEL6_delay),
	.PIPETXELECIDLEL7 (PIPETXELECIDLEL7_delay),
	.SERRENABLE (SERRENABLE_delay),
	.URREPORTINGENABLE (URREPORTINGENABLE_delay),

	.AUXPOWER (AUXPOWER_delay),
	.CFGNEGOTIATEDLINKWIDTH (CFGNEGOTIATEDLINKWIDTH_delay),
	.COMPLIANCEAVOID (COMPLIANCEAVOID_delay),
	.CRMCFGBRIDGEHOTRESET (CRMCFGBRIDGEHOTRESET_delay),
	.CRMCORECLK (CRMCORECLK_delay),
	.CRMCORECLKDLO (CRMCORECLKDLO_delay),
	.CRMCORECLKRXO (CRMCORECLKRXO_delay),
	.CRMCORECLKTXO (CRMCORECLKTXO_delay),
	.CRMLINKRSTN (CRMLINKRSTN_delay),
	.CRMMACRSTN (CRMMACRSTN_delay),
	.CRMMGMTRSTN (CRMMGMTRSTN_delay),
	.CRMNVRSTN (CRMNVRSTN_delay),
	.CRMTXHOTRESETN (CRMTXHOTRESETN_delay),
	.CRMURSTN (CRMURSTN_delay),
	.CRMUSERCFGRSTN (CRMUSERCFGRSTN_delay),
	.CRMUSERCLK (CRMUSERCLK_delay),
	.CRMUSERCLKRXO (CRMUSERCLKRXO_delay),
	.CRMUSERCLKTXO (CRMUSERCLKTXO_delay),
	.CROSSLINKSEED (CROSSLINKSEED_delay),
	.L0ACKNAKTIMERADJUSTMENT (L0ACKNAKTIMERADJUSTMENT_delay),
	.L0ALLDOWNPORTSINL1 (L0ALLDOWNPORTSINL1_delay),
	.L0ALLDOWNRXPORTSINL0S (L0ALLDOWNRXPORTSINL0S_delay),
	.L0ASE (L0ASE_delay),
	.L0ASPORTCOUNT (L0ASPORTCOUNT_delay),
	.L0ASTURNPOOLBITSCONSUMED (L0ASTURNPOOLBITSCONSUMED_delay),
	.L0ATTENTIONBUTTONPRESSED (L0ATTENTIONBUTTONPRESSED_delay),
	.L0CFGASSPANTREEOWNEDSTATE (L0CFGASSPANTREEOWNEDSTATE_delay),
	.L0CFGASSTATECHANGECMD (L0CFGASSTATECHANGECMD_delay),
	.L0CFGDISABLESCRAMBLE (L0CFGDISABLESCRAMBLE_delay),
	.L0CFGEXTENDEDSYNC (L0CFGEXTENDEDSYNC_delay),
	.L0CFGL0SENTRYENABLE (L0CFGL0SENTRYENABLE_delay),
	.L0CFGL0SENTRYSUP (L0CFGL0SENTRYSUP_delay),
	.L0CFGL0SEXITLAT (L0CFGL0SEXITLAT_delay),
	.L0CFGLINKDISABLE (L0CFGLINKDISABLE_delay),
	.L0CFGLOOPBACKMASTER (L0CFGLOOPBACKMASTER_delay),
	.L0CFGNEGOTIATEDMAXP (L0CFGNEGOTIATEDMAXP_delay),
	.L0CFGVCENABLE (L0CFGVCENABLE_delay),
	.L0CFGVCID (L0CFGVCID_delay),
	.L0DLLHOLDLINKUP (L0DLLHOLDLINKUP_delay),
	.L0ELECTROMECHANICALINTERLOCKENGAGED (L0ELECTROMECHANICALINTERLOCKENGAGED_delay),
	.L0FWDASSERTINTALEGACYINT (L0FWDASSERTINTALEGACYINT_delay),
	.L0FWDASSERTINTBLEGACYINT (L0FWDASSERTINTBLEGACYINT_delay),
	.L0FWDASSERTINTCLEGACYINT (L0FWDASSERTINTCLEGACYINT_delay),
	.L0FWDASSERTINTDLEGACYINT (L0FWDASSERTINTDLEGACYINT_delay),
	.L0FWDCORRERRIN (L0FWDCORRERRIN_delay),
	.L0FWDDEASSERTINTALEGACYINT (L0FWDDEASSERTINTALEGACYINT_delay),
	.L0FWDDEASSERTINTBLEGACYINT (L0FWDDEASSERTINTBLEGACYINT_delay),
	.L0FWDDEASSERTINTCLEGACYINT (L0FWDDEASSERTINTCLEGACYINT_delay),
	.L0FWDDEASSERTINTDLEGACYINT (L0FWDDEASSERTINTDLEGACYINT_delay),
	.L0FWDFATALERRIN (L0FWDFATALERRIN_delay),
	.L0FWDNONFATALERRIN (L0FWDNONFATALERRIN_delay),
	.L0LEGACYINTFUNCT0 (L0LEGACYINTFUNCT0_delay),
	.L0MRLSENSORCLOSEDN (L0MRLSENSORCLOSEDN_delay),
	.L0MSIREQUEST0 (L0MSIREQUEST0_delay),
	.L0PACKETHEADERFROMUSER (L0PACKETHEADERFROMUSER_delay),
	.L0PMEREQIN (L0PMEREQIN_delay),
	.L0PORTNUMBER (L0PORTNUMBER_delay),
	.L0POWERFAULTDETECTED (L0POWERFAULTDETECTED_delay),
	.L0PRESENCEDETECTSLOTEMPTYN (L0PRESENCEDETECTSLOTEMPTYN_delay),
	.L0PWRNEWSTATEREQ (L0PWRNEWSTATEREQ_delay),
	.L0PWRNEXTLINKSTATE (L0PWRNEXTLINKSTATE_delay),
	.L0REPLAYTIMERADJUSTMENT (L0REPLAYTIMERADJUSTMENT_delay),
	.L0ROOTTURNOFFREQ (L0ROOTTURNOFFREQ_delay),
	.L0RXTLTLPNONINITIALIZEDVC (L0RXTLTLPNONINITIALIZEDVC_delay),
	.L0SENDUNLOCKMESSAGE (L0SENDUNLOCKMESSAGE_delay),
	.L0SETCOMPLETERABORTERROR (L0SETCOMPLETERABORTERROR_delay),
	.L0SETCOMPLETIONTIMEOUTCORRERROR (L0SETCOMPLETIONTIMEOUTCORRERROR_delay),
	.L0SETCOMPLETIONTIMEOUTUNCORRERROR (L0SETCOMPLETIONTIMEOUTUNCORRERROR_delay),
	.L0SETDETECTEDCORRERROR (L0SETDETECTEDCORRERROR_delay),
	.L0SETDETECTEDFATALERROR (L0SETDETECTEDFATALERROR_delay),
	.L0SETDETECTEDNONFATALERROR (L0SETDETECTEDNONFATALERROR_delay),
	.L0SETLINKDETECTEDPARITYERROR (L0SETLINKDETECTEDPARITYERROR_delay),
	.L0SETLINKMASTERDATAPARITY (L0SETLINKMASTERDATAPARITY_delay),
	.L0SETLINKRECEIVEDMASTERABORT (L0SETLINKRECEIVEDMASTERABORT_delay),
	.L0SETLINKRECEIVEDTARGETABORT (L0SETLINKRECEIVEDTARGETABORT_delay),
	.L0SETLINKSIGNALLEDTARGETABORT (L0SETLINKSIGNALLEDTARGETABORT_delay),
	.L0SETLINKSYSTEMERROR (L0SETLINKSYSTEMERROR_delay),
	.L0SETUNEXPECTEDCOMPLETIONCORRERROR (L0SETUNEXPECTEDCOMPLETIONCORRERROR_delay),
	.L0SETUNEXPECTEDCOMPLETIONUNCORRERROR (L0SETUNEXPECTEDCOMPLETIONUNCORRERROR_delay),
	.L0SETUNSUPPORTEDREQUESTNONPOSTEDERROR (L0SETUNSUPPORTEDREQUESTNONPOSTEDERROR_delay),
	.L0SETUNSUPPORTEDREQUESTOTHERERROR (L0SETUNSUPPORTEDREQUESTOTHERERROR_delay),
	.L0SETUSERDETECTEDPARITYERROR (L0SETUSERDETECTEDPARITYERROR_delay),
	.L0SETUSERMASTERDATAPARITY (L0SETUSERMASTERDATAPARITY_delay),
	.L0SETUSERRECEIVEDMASTERABORT (L0SETUSERRECEIVEDMASTERABORT_delay),
	.L0SETUSERRECEIVEDTARGETABORT (L0SETUSERRECEIVEDTARGETABORT_delay),
	.L0SETUSERSIGNALLEDTARGETABORT (L0SETUSERSIGNALLEDTARGETABORT_delay),
	.L0SETUSERSYSTEMERROR (L0SETUSERSYSTEMERROR_delay),
	.L0TLASFCCREDSTARVATION (L0TLASFCCREDSTARVATION_delay),
	.L0TLLINKRETRAIN (L0TLLINKRETRAIN_delay),
	.L0TRANSACTIONSPENDING (L0TRANSACTIONSPENDING_delay),
	.L0TXBEACON (L0TXBEACON_delay),
	.L0TXCFGPM (L0TXCFGPM_delay),
	.L0TXCFGPMTYPE (L0TXCFGPMTYPE_delay),
	.L0TXTLFCCMPLMCCRED (L0TXTLFCCMPLMCCRED_delay),
	.L0TXTLFCCMPLMCUPDATE (L0TXTLFCCMPLMCUPDATE_delay),
	.L0TXTLFCNPOSTBYPCRED (L0TXTLFCNPOSTBYPCRED_delay),
	.L0TXTLFCNPOSTBYPUPDATE (L0TXTLFCNPOSTBYPUPDATE_delay),
	.L0TXTLFCPOSTORDCRED (L0TXTLFCPOSTORDCRED_delay),
	.L0TXTLFCPOSTORDUPDATE (L0TXTLFCPOSTORDUPDATE_delay),
	.L0TXTLSBFCDATA (L0TXTLSBFCDATA_delay),
	.L0TXTLSBFCUPDATE (L0TXTLSBFCUPDATE_delay),
	.L0TXTLTLPDATA (L0TXTLTLPDATA_delay),
	.L0TXTLTLPEDB (L0TXTLTLPEDB_delay),
	.L0TXTLTLPENABLE (L0TXTLTLPENABLE_delay),
	.L0TXTLTLPEND (L0TXTLTLPEND_delay),
	.L0TXTLTLPLATENCY (L0TXTLTLPLATENCY_delay),
	.L0TXTLTLPREQ (L0TXTLTLPREQ_delay),
	.L0TXTLTLPREQEND (L0TXTLTLPREQEND_delay),
	.L0TXTLTLPWIDTH (L0TXTLTLPWIDTH_delay),
	.L0UPSTREAMRXPORTINL0S (L0UPSTREAMRXPORTINL0S_delay),
	.L0VC0PREVIEWEXPAND (L0VC0PREVIEWEXPAND_delay),
	.L0WAKEN (L0WAKEN_delay),
	.LLKRXCHFIFO (LLKRXCHFIFO_delay),
	.LLKRXCHTC (LLKRXCHTC_delay),
	.LLKRXDSTCONTREQN (LLKRXDSTCONTREQN_delay),
	.LLKRXDSTREQN (LLKRXDSTREQN_delay),
	.LLKTX4DWHEADERN (LLKTX4DWHEADERN_delay),
	.LLKTXCHFIFO (LLKTXCHFIFO_delay),
	.LLKTXCHTC (LLKTXCHTC_delay),
	.LLKTXCOMPLETEN (LLKTXCOMPLETEN_delay),
	.LLKTXCREATEECRCN (LLKTXCREATEECRCN_delay),
	.LLKTXDATA (LLKTXDATA_delay),
	.LLKTXENABLEN (LLKTXENABLEN_delay),
	.LLKTXEOFN (LLKTXEOFN_delay),
	.LLKTXEOPN (LLKTXEOPN_delay),
	.LLKTXSOFN (LLKTXSOFN_delay),
	.LLKTXSOPN (LLKTXSOPN_delay),
	.LLKTXSRCDSCN (LLKTXSRCDSCN_delay),
	.LLKTXSRCRDYN (LLKTXSRCRDYN_delay),
	.MAINPOWER (MAINPOWER_delay),
	.MGMTADDR (MGMTADDR_delay),
	.MGMTBWREN (MGMTBWREN_delay),
	.MGMTRDEN (MGMTRDEN_delay),
	.MGMTSTATSCREDITSEL (MGMTSTATSCREDITSEL_delay),
	.MGMTWDATA (MGMTWDATA_delay),
	.MGMTWREN (MGMTWREN_delay),
	.MIMDLLBRDATA (MIMDLLBRDATA_delay),
	.MIMRXBRDATA (MIMRXBRDATA_delay),
	.MIMTXBRDATA (MIMTXBRDATA_delay),
	.PIPEPHYSTATUSL0 (PIPEPHYSTATUSL0_delay),
	.PIPEPHYSTATUSL1 (PIPEPHYSTATUSL1_delay),
	.PIPEPHYSTATUSL2 (PIPEPHYSTATUSL2_delay),
	.PIPEPHYSTATUSL3 (PIPEPHYSTATUSL3_delay),
	.PIPEPHYSTATUSL4 (PIPEPHYSTATUSL4_delay),
	.PIPEPHYSTATUSL5 (PIPEPHYSTATUSL5_delay),
	.PIPEPHYSTATUSL6 (PIPEPHYSTATUSL6_delay),
	.PIPEPHYSTATUSL7 (PIPEPHYSTATUSL7_delay),
	.PIPERXCHANISALIGNEDL0 (PIPERXCHANISALIGNEDL0_delay),
	.PIPERXCHANISALIGNEDL1 (PIPERXCHANISALIGNEDL1_delay),
	.PIPERXCHANISALIGNEDL2 (PIPERXCHANISALIGNEDL2_delay),
	.PIPERXCHANISALIGNEDL3 (PIPERXCHANISALIGNEDL3_delay),
	.PIPERXCHANISALIGNEDL4 (PIPERXCHANISALIGNEDL4_delay),
	.PIPERXCHANISALIGNEDL5 (PIPERXCHANISALIGNEDL5_delay),
	.PIPERXCHANISALIGNEDL6 (PIPERXCHANISALIGNEDL6_delay),
	.PIPERXCHANISALIGNEDL7 (PIPERXCHANISALIGNEDL7_delay),
	.PIPERXDATAKL0 (PIPERXDATAKL0_delay),
	.PIPERXDATAKL1 (PIPERXDATAKL1_delay),
	.PIPERXDATAKL2 (PIPERXDATAKL2_delay),
	.PIPERXDATAKL3 (PIPERXDATAKL3_delay),
	.PIPERXDATAKL4 (PIPERXDATAKL4_delay),
	.PIPERXDATAKL5 (PIPERXDATAKL5_delay),
	.PIPERXDATAKL6 (PIPERXDATAKL6_delay),
	.PIPERXDATAKL7 (PIPERXDATAKL7_delay),
	.PIPERXDATAL0 (PIPERXDATAL0_delay),
	.PIPERXDATAL1 (PIPERXDATAL1_delay),
	.PIPERXDATAL2 (PIPERXDATAL2_delay),
	.PIPERXDATAL3 (PIPERXDATAL3_delay),
	.PIPERXDATAL4 (PIPERXDATAL4_delay),
	.PIPERXDATAL5 (PIPERXDATAL5_delay),
	.PIPERXDATAL6 (PIPERXDATAL6_delay),
	.PIPERXDATAL7 (PIPERXDATAL7_delay),
	.PIPERXELECIDLEL0 (PIPERXELECIDLEL0_delay),
	.PIPERXELECIDLEL1 (PIPERXELECIDLEL1_delay),
	.PIPERXELECIDLEL2 (PIPERXELECIDLEL2_delay),
	.PIPERXELECIDLEL3 (PIPERXELECIDLEL3_delay),
	.PIPERXELECIDLEL4 (PIPERXELECIDLEL4_delay),
	.PIPERXELECIDLEL5 (PIPERXELECIDLEL5_delay),
	.PIPERXELECIDLEL6 (PIPERXELECIDLEL6_delay),
	.PIPERXELECIDLEL7 (PIPERXELECIDLEL7_delay),
	.PIPERXSTATUSL0 (PIPERXSTATUSL0_delay),
	.PIPERXSTATUSL1 (PIPERXSTATUSL1_delay),
	.PIPERXSTATUSL2 (PIPERXSTATUSL2_delay),
	.PIPERXSTATUSL3 (PIPERXSTATUSL3_delay),
	.PIPERXSTATUSL4 (PIPERXSTATUSL4_delay),
	.PIPERXSTATUSL5 (PIPERXSTATUSL5_delay),
	.PIPERXSTATUSL6 (PIPERXSTATUSL6_delay),
	.PIPERXSTATUSL7 (PIPERXSTATUSL7_delay),
	.PIPERXVALIDL0 (PIPERXVALIDL0_delay),
	.PIPERXVALIDL1 (PIPERXVALIDL1_delay),
	.PIPERXVALIDL2 (PIPERXVALIDL2_delay),
	.PIPERXVALIDL3 (PIPERXVALIDL3_delay),
	.PIPERXVALIDL4 (PIPERXVALIDL4_delay),
	.PIPERXVALIDL5 (PIPERXVALIDL5_delay),
	.PIPERXVALIDL6 (PIPERXVALIDL6_delay),
	.PIPERXVALIDL7 (PIPERXVALIDL7_delay),

	.GSR(GSR)
);

specify
	(CRMCORECLK => BUSMASTERENABLE) = (100, 100);
	(CRMCORECLK => CRMDOHOTRESETN) = (100, 100);
	(CRMCORECLK => CRMPWRSOFTRESETN) = (100, 100);
	(CRMCORECLK => CRMRXHOTRESETN) = (100, 100);
	(CRMCORECLK => DLLTXPMDLLPOUTSTANDING) = (100, 100);
	(CRMCORECLK => INTERRUPTDISABLE) = (100, 100);
	(CRMCORECLK => IOSPACEENABLE) = (100, 100);
	(CRMCORECLK => L0ASAUTONOMOUSINITCOMPLETED) = (100, 100);
	(CRMCORECLK => L0ATTENTIONINDICATORCONTROL) = (100, 100);
	(CRMCORECLK => L0CFGLOOPBACKACK) = (100, 100);
	(CRMCORECLK => L0COMPLETERID) = (100, 100);
	(CRMCORECLK => L0CORRERRMSGRCVD) = (100, 100);
	(CRMCORECLK => L0DLLASRXSTATE) = (100, 100);
	(CRMCORECLK => L0DLLASTXSTATE) = (100, 100);
	(CRMCORECLK => L0DLLERRORVECTOR) = (100, 100);
	(CRMCORECLK => L0DLLRXACKOUTSTANDING) = (100, 100);
	(CRMCORECLK => L0DLLTXNONFCOUTSTANDING) = (100, 100);
	(CRMCORECLK => L0DLLTXOUTSTANDING) = (100, 100);
	(CRMCORECLK => L0DLLVCSTATUS) = (100, 100);
	(CRMCORECLK => L0DLUPDOWN) = (100, 100);
	(CRMCORECLK => L0ERRMSGREQID) = (100, 100);
	(CRMCORECLK => L0FATALERRMSGRCVD) = (100, 100);
	(CRMCORECLK => L0FIRSTCFGWRITEOCCURRED) = (100, 100);
	(CRMCORECLK => L0FWDCORRERROUT) = (100, 100);
	(CRMCORECLK => L0FWDFATALERROUT) = (100, 100);
	(CRMCORECLK => L0FWDNONFATALERROUT) = (100, 100);
	(CRMCORECLK => L0LTSSMSTATE) = (100, 100);
	(CRMCORECLK => L0MACENTEREDL0) = (100, 100);
	(CRMCORECLK => L0MACLINKTRAINING) = (100, 100);
	(CRMCORECLK => L0MACLINKUP) = (100, 100);
	(CRMCORECLK => L0MACNEGOTIATEDLINKWIDTH) = (100, 100);
	(CRMCORECLK => L0MACNEWSTATEACK) = (100, 100);
	(CRMCORECLK => L0MACRXL0SSTATE) = (100, 100);
	(CRMCORECLK => L0MACUPSTREAMDOWNSTREAM) = (100, 100);
	(CRMCORECLK => L0MCFOUND) = (100, 100);
	(CRMCORECLK => L0MSIENABLE0) = (100, 100);
	(CRMCORECLK => L0MULTIMSGEN0) = (100, 100);
	(CRMCORECLK => L0NONFATALERRMSGRCVD) = (100, 100);
	(CRMCORECLK => L0PMEACK) = (100, 100);
	(CRMCORECLK => L0PMEEN) = (100, 100);
	(CRMCORECLK => L0PMEREQOUT) = (100, 100);
	(CRMCORECLK => L0POWERCONTROLLERCONTROL) = (100, 100);
	(CRMCORECLK => L0POWERINDICATORCONTROL) = (100, 100);
	(CRMCORECLK => L0PWRINHIBITTRANSFERS) = (100, 100);
	(CRMCORECLK => L0PWRL1STATE) = (100, 100);
	(CRMCORECLK => L0PWRL23READYDEVICE) = (100, 100);
	(CRMCORECLK => L0PWRL23READYSTATE) = (100, 100);
	(CRMCORECLK => L0PWRSTATE0) = (100, 100);
	(CRMCORECLK => L0PWRTURNOFFREQ) = (100, 100);
	(CRMCORECLK => L0PWRTXL0SSTATE) = (100, 100);
	(CRMCORECLK => L0RECEIVEDASSERTINTALEGACYINT) = (100, 100);
	(CRMCORECLK => L0RECEIVEDASSERTINTBLEGACYINT) = (100, 100);
	(CRMCORECLK => L0RECEIVEDASSERTINTCLEGACYINT) = (100, 100);
	(CRMCORECLK => L0RECEIVEDASSERTINTDLEGACYINT) = (100, 100);
	(CRMCORECLK => L0RECEIVEDDEASSERTINTALEGACYINT) = (100, 100);
	(CRMCORECLK => L0RECEIVEDDEASSERTINTBLEGACYINT) = (100, 100);
	(CRMCORECLK => L0RECEIVEDDEASSERTINTCLEGACYINT) = (100, 100);
	(CRMCORECLK => L0RECEIVEDDEASSERTINTDLEGACYINT) = (100, 100);
	(CRMCORECLK => L0RXBEACON) = (100, 100);
	(CRMCORECLK => L0RXDLLFCCMPLMCCRED) = (100, 100);
	(CRMCORECLK => L0RXDLLFCCMPLMCUPDATE) = (100, 100);
	(CRMCORECLK => L0RXDLLFCNPOSTBYPCRED) = (100, 100);
	(CRMCORECLK => L0RXDLLFCNPOSTBYPUPDATE) = (100, 100);
	(CRMCORECLK => L0RXDLLFCPOSTORDCRED) = (100, 100);
	(CRMCORECLK => L0RXDLLFCPOSTORDUPDATE) = (100, 100);
	(CRMCORECLK => L0RXDLLPM) = (100, 100);
	(CRMCORECLK => L0RXDLLPMTYPE) = (100, 100);
	(CRMCORECLK => L0RXDLLSBFCDATA) = (100, 100);
	(CRMCORECLK => L0RXDLLSBFCUPDATE) = (100, 100);
	(CRMCORECLK => L0RXDLLTLPECRCOK) = (100, 100);
	(CRMCORECLK => L0RXDLLTLPEND) = (100, 100);
	(CRMCORECLK => L0RXMACLINKERROR) = (100, 100);
	(CRMCORECLK => L0STATSCFGOTHERRECEIVED) = (100, 100);
	(CRMCORECLK => L0STATSCFGOTHERTRANSMITTED) = (100, 100);
	(CRMCORECLK => L0STATSCFGRECEIVED) = (100, 100);
	(CRMCORECLK => L0STATSCFGTRANSMITTED) = (100, 100);
	(CRMCORECLK => L0STATSDLLPRECEIVED) = (100, 100);
	(CRMCORECLK => L0STATSDLLPTRANSMITTED) = (100, 100);
	(CRMCORECLK => L0STATSOSRECEIVED) = (100, 100);
	(CRMCORECLK => L0STATSOSTRANSMITTED) = (100, 100);
	(CRMCORECLK => L0STATSTLPRECEIVED) = (100, 100);
	(CRMCORECLK => L0STATSTLPTRANSMITTED) = (100, 100);
	(CRMCORECLK => L0TOGGLEELECTROMECHANICALINTERLOCK) = (100, 100);
	(CRMCORECLK => L0TRANSFORMEDVC) = (100, 100);
	(CRMCORECLK => L0TXDLLFCCMPLMCUPDATED) = (100, 100);
	(CRMCORECLK => L0TXDLLFCNPOSTBYPUPDATED) = (100, 100);
	(CRMCORECLK => L0TXDLLFCPOSTORDUPDATED) = (100, 100);
	(CRMCORECLK => L0TXDLLPMUPDATED) = (100, 100);
	(CRMCORECLK => L0TXDLLSBFCUPDATED) = (100, 100);
	(CRMCORECLK => L0UCBYPFOUND) = (100, 100);
	(CRMCORECLK => L0UCORDFOUND) = (100, 100);
	(CRMCORECLK => L0UNLOCKRECEIVED) = (100, 100);
	(CRMCORECLK => LLKRX4DWHEADERN) = (100, 100);
	(CRMCORECLK => LLKRXCHCOMPLETIONAVAILABLEN) = (100, 100);
	(CRMCORECLK => LLKRXCHCOMPLETIONPARTIALN) = (100, 100);
	(CRMCORECLK => LLKRXCHCONFIGAVAILABLEN) = (100, 100);
	(CRMCORECLK => LLKRXCHCONFIGPARTIALN) = (100, 100);
	(CRMCORECLK => LLKRXCHNONPOSTEDAVAILABLEN) = (100, 100);
	(CRMCORECLK => LLKRXCHNONPOSTEDPARTIALN) = (100, 100);
	(CRMCORECLK => LLKRXCHPOSTEDAVAILABLEN) = (100, 100);
	(CRMCORECLK => LLKRXCHPOSTEDPARTIALN) = (100, 100);
	(CRMCORECLK => LLKRXDATA) = (100, 100);
	(CRMCORECLK => LLKRXECRCBADN) = (100, 100);
	(CRMCORECLK => LLKRXEOFN) = (100, 100);
	(CRMCORECLK => LLKRXEOPN) = (100, 100);
	(CRMCORECLK => LLKRXPREFERREDTYPE) = (100, 100);
	(CRMCORECLK => LLKRXSOFN) = (100, 100);
	(CRMCORECLK => LLKRXSOPN) = (100, 100);
	(CRMCORECLK => LLKRXSRCDSCN) = (100, 100);
	(CRMCORECLK => LLKRXSRCLASTREQN) = (100, 100);
	(CRMCORECLK => LLKRXSRCRDYN) = (100, 100);
	(CRMCORECLK => LLKRXVALIDN) = (100, 100);
	(CRMCORECLK => LLKTCSTATUS) = (100, 100);
	(CRMCORECLK => LLKTXCHANSPACE) = (100, 100);
	(CRMCORECLK => LLKTXCHCOMPLETIONREADYN) = (100, 100);
	(CRMCORECLK => LLKTXCHNONPOSTEDREADYN) = (100, 100);
	(CRMCORECLK => LLKTXCHPOSTEDREADYN) = (100, 100);
	(CRMCORECLK => LLKTXCONFIGREADYN) = (100, 100);
	(CRMCORECLK => LLKTXDSTRDYN) = (100, 100);
	(CRMCORECLK => MAXPAYLOADSIZE) = (100, 100);
	(CRMCORECLK => MAXREADREQUESTSIZE) = (100, 100);
	(CRMCORECLK => MEMSPACEENABLE) = (100, 100);
	(CRMCORECLK => MGMTPSO) = (100, 100);
	(CRMCORECLK => MGMTRDATA) = (100, 100);
	(CRMCORECLK => MGMTSTATSCREDIT) = (100, 100);
	(CRMCORECLK => PARITYERRORRESPONSE) = (100, 100);
	(CRMCORECLK => PIPEDESKEWLANESL0) = (100, 100);
	(CRMCORECLK => PIPEDESKEWLANESL1) = (100, 100);
	(CRMCORECLK => PIPEDESKEWLANESL2) = (100, 100);
	(CRMCORECLK => PIPEDESKEWLANESL3) = (100, 100);
	(CRMCORECLK => PIPEDESKEWLANESL4) = (100, 100);
	(CRMCORECLK => PIPEDESKEWLANESL5) = (100, 100);
	(CRMCORECLK => PIPEDESKEWLANESL6) = (100, 100);
	(CRMCORECLK => PIPEDESKEWLANESL7) = (100, 100);
	(CRMCORECLK => PIPEPOWERDOWNL0) = (100, 100);
	(CRMCORECLK => PIPEPOWERDOWNL1) = (100, 100);
	(CRMCORECLK => PIPEPOWERDOWNL2) = (100, 100);
	(CRMCORECLK => PIPEPOWERDOWNL3) = (100, 100);
	(CRMCORECLK => PIPEPOWERDOWNL4) = (100, 100);
	(CRMCORECLK => PIPEPOWERDOWNL5) = (100, 100);
	(CRMCORECLK => PIPEPOWERDOWNL6) = (100, 100);
	(CRMCORECLK => PIPEPOWERDOWNL7) = (100, 100);
	(CRMCORECLK => PIPERESETL0) = (100, 100);
	(CRMCORECLK => PIPERESETL1) = (100, 100);
	(CRMCORECLK => PIPERESETL2) = (100, 100);
	(CRMCORECLK => PIPERESETL3) = (100, 100);
	(CRMCORECLK => PIPERESETL4) = (100, 100);
	(CRMCORECLK => PIPERESETL5) = (100, 100);
	(CRMCORECLK => PIPERESETL6) = (100, 100);
	(CRMCORECLK => PIPERESETL7) = (100, 100);
	(CRMCORECLK => PIPERXPOLARITYL0) = (100, 100);
	(CRMCORECLK => PIPERXPOLARITYL1) = (100, 100);
	(CRMCORECLK => PIPERXPOLARITYL2) = (100, 100);
	(CRMCORECLK => PIPERXPOLARITYL3) = (100, 100);
	(CRMCORECLK => PIPERXPOLARITYL4) = (100, 100);
	(CRMCORECLK => PIPERXPOLARITYL5) = (100, 100);
	(CRMCORECLK => PIPERXPOLARITYL6) = (100, 100);
	(CRMCORECLK => PIPERXPOLARITYL7) = (100, 100);
	(CRMCORECLK => PIPETXCOMPLIANCEL0) = (100, 100);
	(CRMCORECLK => PIPETXCOMPLIANCEL1) = (100, 100);
	(CRMCORECLK => PIPETXCOMPLIANCEL2) = (100, 100);
	(CRMCORECLK => PIPETXCOMPLIANCEL3) = (100, 100);
	(CRMCORECLK => PIPETXCOMPLIANCEL4) = (100, 100);
	(CRMCORECLK => PIPETXCOMPLIANCEL5) = (100, 100);
	(CRMCORECLK => PIPETXCOMPLIANCEL6) = (100, 100);
	(CRMCORECLK => PIPETXCOMPLIANCEL7) = (100, 100);
	(CRMCORECLK => PIPETXDATAKL0) = (100, 100);
	(CRMCORECLK => PIPETXDATAKL1) = (100, 100);
	(CRMCORECLK => PIPETXDATAKL2) = (100, 100);
	(CRMCORECLK => PIPETXDATAKL3) = (100, 100);
	(CRMCORECLK => PIPETXDATAKL4) = (100, 100);
	(CRMCORECLK => PIPETXDATAKL5) = (100, 100);
	(CRMCORECLK => PIPETXDATAKL6) = (100, 100);
	(CRMCORECLK => PIPETXDATAKL7) = (100, 100);
	(CRMCORECLK => PIPETXDATAL0) = (100, 100);
	(CRMCORECLK => PIPETXDATAL1) = (100, 100);
	(CRMCORECLK => PIPETXDATAL2) = (100, 100);
	(CRMCORECLK => PIPETXDATAL3) = (100, 100);
	(CRMCORECLK => PIPETXDATAL4) = (100, 100);
	(CRMCORECLK => PIPETXDATAL5) = (100, 100);
	(CRMCORECLK => PIPETXDATAL6) = (100, 100);
	(CRMCORECLK => PIPETXDATAL7) = (100, 100);
	(CRMCORECLK => PIPETXDETECTRXLOOPBACKL0) = (100, 100);
	(CRMCORECLK => PIPETXDETECTRXLOOPBACKL1) = (100, 100);
	(CRMCORECLK => PIPETXDETECTRXLOOPBACKL2) = (100, 100);
	(CRMCORECLK => PIPETXDETECTRXLOOPBACKL3) = (100, 100);
	(CRMCORECLK => PIPETXDETECTRXLOOPBACKL4) = (100, 100);
	(CRMCORECLK => PIPETXDETECTRXLOOPBACKL5) = (100, 100);
	(CRMCORECLK => PIPETXDETECTRXLOOPBACKL6) = (100, 100);
	(CRMCORECLK => PIPETXDETECTRXLOOPBACKL7) = (100, 100);
	(CRMCORECLK => PIPETXELECIDLEL0) = (100, 100);
	(CRMCORECLK => PIPETXELECIDLEL1) = (100, 100);
	(CRMCORECLK => PIPETXELECIDLEL2) = (100, 100);
	(CRMCORECLK => PIPETXELECIDLEL3) = (100, 100);
	(CRMCORECLK => PIPETXELECIDLEL4) = (100, 100);
	(CRMCORECLK => PIPETXELECIDLEL5) = (100, 100);
	(CRMCORECLK => PIPETXELECIDLEL6) = (100, 100);
	(CRMCORECLK => PIPETXELECIDLEL7) = (100, 100);
	(CRMCORECLK => SERRENABLE) = (100, 100);
	(CRMCORECLK => URREPORTINGENABLE) = (100, 100);
	(CRMCORECLKDLO => MIMDLLBRADD) = (100, 100);
	(CRMCORECLKDLO => MIMDLLBREN) = (100, 100);
	(CRMCORECLKDLO => MIMDLLBWADD) = (100, 100);
	(CRMCORECLKDLO => MIMDLLBWDATA) = (100, 100);
	(CRMCORECLKDLO => MIMDLLBWEN) = (100, 100);
	(CRMCORECLKRXO => MIMRXBRADD) = (100, 100);
	(CRMCORECLKRXO => MIMRXBREN) = (100, 100);
	(CRMCORECLKRXO => MIMRXBWADD) = (100, 100);
	(CRMCORECLKRXO => MIMRXBWDATA) = (100, 100);
	(CRMCORECLKRXO => MIMRXBWEN) = (100, 100);
	(CRMCORECLKTXO => MIMTXBRADD) = (100, 100);
	(CRMCORECLKTXO => MIMTXBREN) = (100, 100);
	(CRMCORECLKTXO => MIMTXBWADD) = (100, 100);
	(CRMCORECLKTXO => MIMTXBWDATA) = (100, 100);
	(CRMCORECLKTXO => MIMTXBWEN) = (100, 100);
	(CRMUSERCLK => BUSMASTERENABLE) = (100, 100);
	(CRMUSERCLK => INTERRUPTDISABLE) = (100, 100);
	(CRMUSERCLK => IOSPACEENABLE) = (100, 100);
	(CRMUSERCLK => L0ATTENTIONINDICATORCONTROL) = (100, 100);
	(CRMUSERCLK => L0COMPLETERID) = (100, 100);
	(CRMUSERCLK => L0CORRERRMSGRCVD) = (100, 100);
	(CRMUSERCLK => L0ERRMSGREQID) = (100, 100);
	(CRMUSERCLK => L0FATALERRMSGRCVD) = (100, 100);
	(CRMUSERCLK => L0FIRSTCFGWRITEOCCURRED) = (100, 100);
	(CRMUSERCLK => L0FWDCORRERROUT) = (100, 100);
	(CRMUSERCLK => L0FWDFATALERROUT) = (100, 100);
	(CRMUSERCLK => L0FWDNONFATALERROUT) = (100, 100);
	(CRMUSERCLK => L0MSIENABLE0) = (100, 100);
	(CRMUSERCLK => L0MULTIMSGEN0) = (100, 100);
	(CRMUSERCLK => L0NONFATALERRMSGRCVD) = (100, 100);
	(CRMUSERCLK => L0PMEACK) = (100, 100);
	(CRMUSERCLK => L0PMEEN) = (100, 100);
	(CRMUSERCLK => L0PMEREQOUT) = (100, 100);
	(CRMUSERCLK => L0POWERCONTROLLERCONTROL) = (100, 100);
	(CRMUSERCLK => L0POWERINDICATORCONTROL) = (100, 100);
	(CRMUSERCLK => L0PWRL1STATE) = (100, 100);
	(CRMUSERCLK => L0PWRL23READYDEVICE) = (100, 100);
	(CRMUSERCLK => L0PWRL23READYSTATE) = (100, 100);
	(CRMUSERCLK => L0PWRSTATE0) = (100, 100);
	(CRMUSERCLK => L0PWRTURNOFFREQ) = (100, 100);
	(CRMUSERCLK => L0PWRTXL0SSTATE) = (100, 100);
	(CRMUSERCLK => L0RECEIVEDASSERTINTALEGACYINT) = (100, 100);
	(CRMUSERCLK => L0RECEIVEDASSERTINTBLEGACYINT) = (100, 100);
	(CRMUSERCLK => L0RECEIVEDASSERTINTCLEGACYINT) = (100, 100);
	(CRMUSERCLK => L0RECEIVEDASSERTINTDLEGACYINT) = (100, 100);
	(CRMUSERCLK => L0RECEIVEDDEASSERTINTALEGACYINT) = (100, 100);
	(CRMUSERCLK => L0RECEIVEDDEASSERTINTBLEGACYINT) = (100, 100);
	(CRMUSERCLK => L0RECEIVEDDEASSERTINTCLEGACYINT) = (100, 100);
	(CRMUSERCLK => L0RECEIVEDDEASSERTINTDLEGACYINT) = (100, 100);
	(CRMUSERCLK => L0STATSCFGOTHERRECEIVED) = (100, 100);
	(CRMUSERCLK => L0STATSCFGOTHERTRANSMITTED) = (100, 100);
	(CRMUSERCLK => L0STATSCFGRECEIVED) = (100, 100);
	(CRMUSERCLK => L0STATSCFGTRANSMITTED) = (100, 100);
	(CRMUSERCLK => L0TOGGLEELECTROMECHANICALINTERLOCK) = (100, 100);
	(CRMUSERCLK => L0UNLOCKRECEIVED) = (100, 100);
	(CRMUSERCLK => LLKRX4DWHEADERN) = (100, 100);
	(CRMUSERCLK => LLKRXCHCOMPLETIONAVAILABLEN) = (100, 100);
	(CRMUSERCLK => LLKRXCHCOMPLETIONPARTIALN) = (100, 100);
	(CRMUSERCLK => LLKRXCHCONFIGAVAILABLEN) = (100, 100);
	(CRMUSERCLK => LLKRXCHCONFIGPARTIALN) = (100, 100);
	(CRMUSERCLK => LLKRXCHNONPOSTEDAVAILABLEN) = (100, 100);
	(CRMUSERCLK => LLKRXCHNONPOSTEDPARTIALN) = (100, 100);
	(CRMUSERCLK => LLKRXCHPOSTEDAVAILABLEN) = (100, 100);
	(CRMUSERCLK => LLKRXCHPOSTEDPARTIALN) = (100, 100);
	(CRMUSERCLK => LLKRXDATA) = (100, 100);
	(CRMUSERCLK => LLKRXECRCBADN) = (100, 100);
	(CRMUSERCLK => LLKRXEOFN) = (100, 100);
	(CRMUSERCLK => LLKRXEOPN) = (100, 100);
	(CRMUSERCLK => LLKRXPREFERREDTYPE) = (100, 100);
	(CRMUSERCLK => LLKRXSOFN) = (100, 100);
	(CRMUSERCLK => LLKRXSOPN) = (100, 100);
	(CRMUSERCLK => LLKRXSRCDSCN) = (100, 100);
	(CRMUSERCLK => LLKRXSRCLASTREQN) = (100, 100);
	(CRMUSERCLK => LLKRXSRCRDYN) = (100, 100);
	(CRMUSERCLK => LLKRXVALIDN) = (100, 100);
	(CRMUSERCLK => LLKTCSTATUS) = (100, 100);
	(CRMUSERCLK => LLKTXCHANSPACE) = (100, 100);
	(CRMUSERCLK => LLKTXCHCOMPLETIONREADYN) = (100, 100);
	(CRMUSERCLK => LLKTXCHNONPOSTEDREADYN) = (100, 100);
	(CRMUSERCLK => LLKTXCHPOSTEDREADYN) = (100, 100);
	(CRMUSERCLK => LLKTXCONFIGREADYN) = (100, 100);
	(CRMUSERCLK => LLKTXDSTRDYN) = (100, 100);
	(CRMUSERCLK => MAXPAYLOADSIZE) = (100, 100);
	(CRMUSERCLK => MAXREADREQUESTSIZE) = (100, 100);
	(CRMUSERCLK => MEMSPACEENABLE) = (100, 100);
	(CRMUSERCLK => MGMTPSO) = (100, 100);
	(CRMUSERCLK => MGMTRDATA) = (100, 100);
	(CRMUSERCLK => MGMTSTATSCREDIT) = (100, 100);
	(CRMUSERCLK => PARITYERRORRESPONSE) = (100, 100);
	(CRMUSERCLK => SERRENABLE) = (100, 100);
	(CRMUSERCLK => URREPORTINGENABLE) = (100, 100);
	(CRMUSERCLKRXO => MIMRXBRADD) = (100, 100);
	(CRMUSERCLKRXO => MIMRXBREN) = (100, 100);
	(CRMUSERCLKTXO => MIMTXBWADD) = (100, 100);
	(CRMUSERCLKTXO => MIMTXBWDATA) = (100, 100);
	(CRMUSERCLKTXO => MIMTXBWEN) = (100, 100);
	(L0WAKEN => L0RXBEACON) = (100, 100);
	(MAINPOWER => L0PMEEN) = (100, 100);
	(MAINPOWER => L0PMEREQOUT) = (100, 100);
	(MAINPOWER => L0RXBEACON) = (100, 100);
	(MAINPOWER => PIPEPOWERDOWNL0) = (100, 100);
	(MAINPOWER => PIPEPOWERDOWNL1) = (100, 100);
	(MAINPOWER => PIPEPOWERDOWNL2) = (100, 100);
	(MAINPOWER => PIPEPOWERDOWNL3) = (100, 100);
	(MAINPOWER => PIPEPOWERDOWNL4) = (100, 100);
	(MAINPOWER => PIPEPOWERDOWNL5) = (100, 100);
	(MAINPOWER => PIPEPOWERDOWNL6) = (100, 100);
	(MAINPOWER => PIPEPOWERDOWNL7) = (100, 100);
	specparam PATHPULSE$ = 0;
endspecify
endmodule
